/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.util.vm;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.openslx.bwlp.thrift.iface.OperatingSystem;
import org.openslx.bwlp.thrift.iface.Virtualizer;
import org.openslx.util.vm.UnsupportedVirtualizerFormatException;
import org.openslx.util.vm.VBoxDDAccelMeta;
import org.openslx.util.vm.VBoxEthernetDevTypeMeta;
import org.openslx.util.vm.VBoxHWVersionMeta;
import org.openslx.util.vm.VBoxSoundCardMeta;
import org.openslx.util.vm.VboxConfig;
import org.openslx.util.vm.VmMetaData;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VboxMetaData
extends VmMetaData<VBoxSoundCardMeta, VBoxDDAccelMeta, VBoxHWVersionMeta, VBoxEthernetDevTypeMeta> {
    private static final Logger LOGGER = Logger.getLogger(VboxMetaData.class);
    private static final Virtualizer virtualizer = new Virtualizer("virtualbox", "VirtualBox");
    private final VboxConfig config;

    public VboxMetaData(List<OperatingSystem> osList, File file) throws IOException, UnsupportedVirtualizerFormatException {
        super(osList);
        this.config = new VboxConfig(file);
        this.init();
    }

    public VboxMetaData(List<OperatingSystem> osList, byte[] vmContent, int length) throws IOException, UnsupportedVirtualizerFormatException {
        super(osList);
        this.config = new VboxConfig(vmContent, length);
        this.init();
    }

    private void init() {
        this.registerVirtualHW();
        this.displayName = this.config.getDisplayName();
        this.setOs(this.config.getOsName());
        this.isMachineSnapshot = this.config.isMachineSnapshot();
        for (VmMetaData.HardDisk hardDisk : this.config.getHdds()) {
            this.hdds.add(hardDisk);
        }
    }

    @Override
    public Virtualizer getVirtualizer() {
        return virtualizer;
    }

    @Override
    public void enableUsb(boolean enabled) {
        if (!enabled) {
            this.config.disableUsb();
        } else {
            this.config.enableUsb();
        }
    }

    @Override
    public void applySettingsForLocalEdit() {
    }

    @Override
    public byte[] getDefinitionArray() {
        return this.config.toString(false).getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public byte[] getFilteredDefinitionArray() {
        return this.config.toString(false).getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public boolean addHddTemplate(String diskImage, String hddMode, String redoDir) {
        this.config.changeAttribute("/VirtualBox/Machine/MediaRegistry/HardDisks/HardDisk[@location='" + VboxConfig.PlaceHolder.HDDLOCATION.toString() + "']", "location", diskImage);
        this.config.changeAttribute("/VirtualBox/Machine", "snapshotFolder", redoDir);
        return true;
    }

    @Override
    public boolean addHddTemplate(File diskImage, String hddMode, String redoDir) {
        String diskImagePath = diskImage.getName();
        this.config.changeAttribute("/VirtualBox/Machine/MediaRegistry/HardDisks/HardDisk", "location", diskImagePath);
        UUID newhdduuid = UUID.randomUUID();
        String vboxUUid = "{" + newhdduuid.toString() + "}";
        this.config.changeAttribute("/VirtualBox/Machine/MediaRegistry/HardDisks/HardDisk", "uuid", vboxUUid);
        this.config.changeAttribute("/VirtualBox/Machine/StorageControllers/StorageController/AttachedDevice/Image", "uuid", vboxUUid);
        ByteBuffer buffer = ByteBuffer.wrap(new byte[16]);
        buffer.putLong(newhdduuid.getMostSignificantBits());
        buffer.putLong(newhdduuid.getLeastSignificantBits());
        byte[] oldOrder = buffer.array();
        byte[] bytesToWrite = Arrays.copyOf(oldOrder, oldOrder.length);
        int[] offsets = new int[]{3, 2, 1, 0, 5, 4, 7, 6};
        for (int index = 0; index < 8; ++index) {
            bytesToWrite[index] = oldOrder[offsets[index]];
        }
        try (RandomAccessFile file = new RandomAccessFile(diskImage, "rw");){
            file.seek(392L);
            file.write(bytesToWrite, 0, 16);
        }
        catch (Exception e) {
            LOGGER.warn("could not patch new uuid in the vdi", e);
        }
        UUID newMachineUuid = UUID.randomUUID();
        if (newMachineUuid.equals(newhdduuid)) {
            LOGGER.warn("The new Machine UUID is the same as the new HDD UUID; tying again...this vm might not start");
            newMachineUuid = UUID.randomUUID();
        }
        String machineUUid = "{" + newMachineUuid.toString() + "}";
        return this.config.changeAttribute("/VirtualBox/Machine", "uuid", machineUUid);
    }

    @Override
    public boolean addDefaultNat() {
        if (this.config.addNewNode("/VirtualBox/Machine/Hardware/Network/Adapter", "NAT") == null) {
            LOGGER.error("Failed to set network adapter to NAT.");
            return false;
        }
        return this.config.changeAttribute("/VirtualBox/Machine/Hardware/Network/Adapter", "MACAddress", "080027B86D12");
    }

    @Override
    public void setOs(String vendorOsId) {
        this.config.changeAttribute("/VirtualBox/Machine", "OSType", vendorOsId);
        this.setOs("virtualbox", vendorOsId);
    }

    @Override
    public boolean addDisplayName(String name) {
        return this.config.changeAttribute("/VirtualBox/Machine", "name", name);
    }

    @Override
    public boolean addRam(int mem) {
        return this.config.changeAttribute("/VirtualBox/Machine/Hardware/Memory", "RAMSize", Integer.toString(mem));
    }

    @Override
    public void addFloppy(int index, String image, boolean readOnly) {
        Element floppyDevice;
        Element floppyController = null;
        NodeList matches = this.config.findNodes("/VirtualBox/Machine/StorageControllers/StorageController[@name='Floppy']");
        if (matches == null || matches.getLength() == 0) {
            floppyController = (Element)this.config.addNewNode("/VirtualBox/Machine/StorageControllers", "StorageController");
            if (floppyController == null) {
                LOGGER.error("Failed to add <Image> to floppy device.");
                return;
            }
            floppyController.setAttribute("name", "Floppy");
            floppyController.setAttribute("type", "I82078");
            floppyController.setAttribute("PortCount", "1");
            floppyController.setAttribute("useHostIOCache", "true");
            floppyController.setAttribute("Bootable", "false");
        }
        if (matches.getLength() > 1) {
            LOGGER.error("Multiple floppy controllers detected, this should never happen! ");
            return;
        }
        if (floppyController == null) {
            floppyController = (Element)matches.item(0);
        }
        if ((floppyDevice = (Element)this.config.addNewNode(floppyController, "AttachedDevice")) == null) {
            LOGGER.error("Failed to add <Image> to floppy device.");
            return;
        }
        floppyDevice.setAttribute("type", "Floppy");
        floppyDevice.setAttribute("hotpluggable", "false");
        floppyDevice.setAttribute("port", "0");
        floppyDevice.setAttribute("device", Integer.toString(index));
        if (image != null) {
            Element floppyImage = (Element)this.config.addNewNode(floppyDevice, "Image");
            if (floppyImage == null) {
                LOGGER.error("Failed to add <Image> to floppy device.");
                return;
            }
            floppyImage.setAttribute("uuid", VboxConfig.PlaceHolder.FLOPPYUUID.toString());
            Element floppyImages = (Element)this.config.addNewNode("/VirtualBox/Machine/MediaRegistry", "FloppyImages");
            if (floppyImages == null) {
                LOGGER.error("Failed to add <FloppyImages> to media registry.");
                return;
            }
            Element floppyImageReg = (Element)this.config.addNewNode("/VirtualBox/Machine/MediaRegistry/FloppyImages", "Image");
            if (floppyImageReg == null) {
                LOGGER.error("Failed to add <Image> to floppy images in the media registry.");
                return;
            }
            floppyImageReg.setAttribute("uuid", VboxConfig.PlaceHolder.FLOPPYUUID.toString());
            floppyImageReg.setAttribute("location", VboxConfig.PlaceHolder.FLOPPYLOCATION.toString());
        }
    }

    @Override
    public boolean addCdrom(String image) {
        return false;
    }

    @Override
    public boolean addCpuCoreCount(int nrOfCores) {
        return this.config.changeAttribute("/VirtualBox/Machine/Hardware/CPU", "count", Integer.toString(nrOfCores));
    }

    @Override
    public void setSoundCard(VmMetaData.SoundCardType type) {
        VBoxSoundCardMeta sound = (VBoxSoundCardMeta)this.soundCards.get((Object)type);
        this.config.changeAttribute("/VirtualBox/Machine/Hardware/AudioAdapter", "enabled", Boolean.toString(sound.isPresent));
        this.config.changeAttribute("/VirtualBox/Machine/Hardware/AudioAdapter", "controller", sound.value);
    }

    @Override
    public VmMetaData.SoundCardType getSoundCard() {
        VmMetaData.SoundCardType returnsct = VmMetaData.SoundCardType.NONE;
        Element x = (Element)this.config.findNodes("/VirtualBox/Machine/Hardware/AudioAdapter").item(0);
        if (!x.hasAttribute("enabled") || x.hasAttribute("enabled") && x.getAttribute("enabled").equals("false")) {
            return returnsct;
        }
        if (!x.hasAttribute("controller")) {
            returnsct = VmMetaData.SoundCardType.AC;
        } else {
            String controller = x.getAttribute("controller");
            VBoxSoundCardMeta soundMeta = null;
            for (VmMetaData.SoundCardType type : VmMetaData.SoundCardType.values()) {
                soundMeta = (VBoxSoundCardMeta)this.soundCards.get((Object)type);
                if (soundMeta == null || !controller.equals(soundMeta.value)) continue;
                returnsct = type;
            }
        }
        return returnsct;
    }

    @Override
    public void setDDAcceleration(VmMetaData.DDAcceleration type) {
        VBoxDDAccelMeta accel = (VBoxDDAccelMeta)this.ddacc.get((Object)type);
        this.config.changeAttribute("/VirtualBox/Machine/Hardware/Display", "accelerate3D", Boolean.toString(accel.isPresent));
    }

    @Override
    public VmMetaData.DDAcceleration getDDAcceleration() {
        VmMetaData.DDAcceleration returndda = null;
        Element x = (Element)this.config.findNodes("/VirtualBox/Machine/Hardware/Display").item(0);
        returndda = x.hasAttribute("accelerate3D") ? (x.getAttribute("accelerate3D").equals("true") ? VmMetaData.DDAcceleration.ON : VmMetaData.DDAcceleration.OFF) : VmMetaData.DDAcceleration.OFF;
        return returndda;
    }

    @Override
    public void setHWVersion(VmMetaData.HWVersion type) {
    }

    @Override
    public VmMetaData.HWVersion getHWVersion() {
        return VmMetaData.HWVersion.DEFAULT;
    }

    @Override
    public void setEthernetDevType(int cardIndex, VmMetaData.EthernetDevType type) {
        String index = "0";
        VBoxEthernetDevTypeMeta nic = (VBoxEthernetDevTypeMeta)this.networkCards.get((Object)type);
        this.config.changeAttribute("/VirtualBox/Machine/Hardware/Network/Adapter[@slot='" + index + "']", "enabled", Boolean.toString(nic.isPresent));
        this.config.changeAttribute("/VirtualBox/Machine/Hardware/Network/Adapter[@slot='" + index + "']", "type", nic.value);
    }

    @Override
    public VmMetaData.EthernetDevType getEthernetDevType(int cardIndex) {
        VmMetaData.EthernetDevType returnedt = VmMetaData.EthernetDevType.NONE;
        Element x = (Element)this.config.findNodes("/VirtualBox/Machine/Hardware/Network/Adapter").item(0);
        if (!x.hasAttribute("enabled") || x.hasAttribute("enabled") && x.getAttribute("enabled").equals("false")) {
            return returnedt;
        }
        if (!x.hasAttribute("type")) {
            returnedt = VmMetaData.EthernetDevType.PCNETFAST3;
        } else {
            String temp = x.getAttribute("type");
            VBoxEthernetDevTypeMeta etherMeta = null;
            for (VmMetaData.EthernetDevType type : VmMetaData.EthernetDevType.values()) {
                etherMeta = (VBoxEthernetDevTypeMeta)this.networkCards.get((Object)type);
                if (etherMeta == null || !temp.equals(etherMeta.value)) continue;
                returnedt = type;
            }
        }
        return returnedt;
    }

    @Override
    public void registerVirtualHW() {
        this.soundCards.put(VmMetaData.SoundCardType.NONE, new VBoxSoundCardMeta(false, "AC97"));
        this.soundCards.put(VmMetaData.SoundCardType.SOUND_BLASTER, new VBoxSoundCardMeta(true, "SB16"));
        this.soundCards.put(VmMetaData.SoundCardType.HD_AUDIO, new VBoxSoundCardMeta(true, "HDA"));
        this.soundCards.put(VmMetaData.SoundCardType.AC, new VBoxSoundCardMeta(true, "AC97"));
        this.ddacc.put(VmMetaData.DDAcceleration.OFF, new VBoxDDAccelMeta(false));
        this.ddacc.put(VmMetaData.DDAcceleration.ON, new VBoxDDAccelMeta(true));
        this.hwversion.put(VmMetaData.HWVersion.DEFAULT, new VBoxHWVersionMeta(0));
        this.networkCards.put(VmMetaData.EthernetDevType.NONE, new VBoxEthernetDevTypeMeta(false, "Am79C970A"));
        this.networkCards.put(VmMetaData.EthernetDevType.PCNETPCI2, new VBoxEthernetDevTypeMeta(true, "Am79C970A"));
        this.networkCards.put(VmMetaData.EthernetDevType.PCNETFAST3, new VBoxEthernetDevTypeMeta(true, "Am79C973"));
        this.networkCards.put(VmMetaData.EthernetDevType.PRO1000MTD, new VBoxEthernetDevTypeMeta(true, "82540EM"));
        this.networkCards.put(VmMetaData.EthernetDevType.PRO1000TS, new VBoxEthernetDevTypeMeta(true, "82543GC"));
        this.networkCards.put(VmMetaData.EthernetDevType.PRO1000MTS, new VBoxEthernetDevTypeMeta(true, "82545EM"));
        this.networkCards.put(VmMetaData.EthernetDevType.PARAVIRT, new VBoxEthernetDevTypeMeta(true, "virtio"));
    }

    @Override
    public boolean addEthernet(VmMetaData.EtherType type) {
        Node hostOnlyInterfaceNode = this.config.addNewNode("/VirtualBox/Machine/Hardware/Network/Adapter[@slot='0']", "HostOnlyInterface");
        if (hostOnlyInterfaceNode == null) {
            LOGGER.error("Failed to create node for HostOnlyInterface.");
            return false;
        }
        return this.config.addAttributeToNode(hostOnlyInterfaceNode, "name", EthernetType.valueOf((String)type.name()).vnet);
    }

    @Override
    public boolean disableSuspend() {
        return true;
    }

    public static enum EthernetType {
        NAT("vboxnet1"),
        BRIDGED("vboxnet0"),
        HOST_ONLY("vboxnet2");

        public final String vnet;

        private EthernetType(String vnet) {
            this.vnet = vnet;
        }
    }
}

