/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.util.vm;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.apache.log4j.Logger;
import org.openslx.util.Util;
import org.openslx.util.XmlHelper;
import org.openslx.util.vm.UnsupportedVirtualizerFormatException;
import org.openslx.util.vm.VmMetaData;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class VboxConfig {
    private static final Logger LOGGER = Logger.getLogger(VboxConfig.class);
    private String osName = new String();
    private ArrayList<VmMetaData.HardDisk> hddsArray = new ArrayList();
    private Document doc = null;
    private static String[] blacklist = new String[]{"/VirtualBox/Machine/Hardware/GuestProperties", "/VirtualBox/Machine/Hardware/VideoCapture", "/VirtualBox/Machine/Hardware/HID", "/VirtualBox/Machine/Hardware/USB", "/VirtualBox/Machine/Hardware/LPT", "/VirtualBox/Machine/Hardware/SharedFolders", "/VirtualBox/Machine/Hardware/Network/Adapter[@enabled='true']/*", "/VirtualBox/Machine/ExtraData", "/VirtualBox/Machine/StorageControllers/StorageController/AttachedDevice[not(@type='HardDisk')]", "/VirtualBox/Machine/MediaRegistry/FloppyImages", "/VirtualBox/Machine/MediaRegistry/DVDImages"};

    public VboxConfig(File file) throws IOException, UnsupportedVirtualizerFormatException {
        try {
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            InputStream xsdStream = VboxConfig.class.getResourceAsStream("/master-sync-shared/xml/VirtualBox-settings.xsd");
            if (xsdStream == null) {
                LOGGER.warn("Cannot validate Vbox XML: No XSD found in JAR");
            } else {
                Schema schema = factory.newSchema(new StreamSource(xsdStream));
                Validator validator = schema.newValidator();
                validator.validate(new StreamSource(file));
            }
        }
        catch (SAXException e) {
            LOGGER.error("Selected vbox file was not validated against the XSD schema: " + e.getMessage());
        }
        this.doc = XmlHelper.parseDocumentFromStream(new FileInputStream(file));
        this.doc = XmlHelper.removeFormattingNodes(this.doc);
        if (this.doc == null) {
            throw new UnsupportedVirtualizerFormatException("Could not create DOM from given VirtualBox machine configuration file!");
        }
        this.init();
    }

    public VboxConfig(byte[] machineDescription, int length) throws UnsupportedVirtualizerFormatException {
        ByteArrayInputStream is = new ByteArrayInputStream(machineDescription);
        this.doc = XmlHelper.parseDocumentFromStream(is);
        if (this.doc == null) {
            LOGGER.error("Failed to create a DOM from given machine description.");
            throw new UnsupportedVirtualizerFormatException("Could not create DOM from given machine description as. byte array.");
        }
        this.init();
    }

    private void init() throws UnsupportedVirtualizerFormatException {
        if (Util.isEmptyString(this.getDisplayName())) {
            throw new UnsupportedVirtualizerFormatException("Machine doesn't have a name");
        }
        try {
            this.ensureHardwareUuid();
            this.setOsType();
            if (this.checkForPlaceholders()) {
                return;
            }
            this.setHdds();
            this.removeBlacklistedElements();
            this.addPlaceHolders();
        }
        catch (XPathExpressionException e) {
            LOGGER.debug("Could not initialize VBoxConfig", e);
            return;
        }
    }

    private void ensureHardwareUuid() throws XPathExpressionException, UnsupportedVirtualizerFormatException {
        String machineUuid = XmlHelper.XPath.compile("/VirtualBox/Machine/@uuid").evaluate(this.doc);
        if (machineUuid.isEmpty()) {
            LOGGER.error("Machine UUID empty, should never happen!");
            throw new UnsupportedVirtualizerFormatException("XML doesn't contain a machine uuid");
        }
        NodeList hwNodes = this.findNodes("/VirtualBox/Machine/Hardware");
        int count = hwNodes.getLength();
        if (count != 1) {
            throw new UnsupportedVirtualizerFormatException("Zero or more '/VirtualBox/Machine/Hardware' node were found, should never happen!");
        }
        Element hw = (Element)hwNodes.item(0);
        String hwUuid = hw.getAttribute("uuid");
        if (!hwUuid.isEmpty()) {
            LOGGER.info("Found hardware uuid: " + hwUuid);
            return;
        }
        if (!this.addAttributeToNode(hw, "uuid", machineUuid)) {
            LOGGER.error("Failed to set machine UUID '" + machineUuid + "' as hardware UUID.");
            return;
        }
        LOGGER.info("Saved machine UUID as hardware UUID.");
    }

    public void addPlaceHolders() {
        this.changeAttribute("/VirtualBox/Machine", "uuid", PlaceHolder.MACHINEUUID.toString());
        this.changeAttribute("/VirtualBox/Machine/MediaRegistry/HardDisks/HardDisk", "location", PlaceHolder.HDDLOCATION.toString());
        this.changeAttribute("/VirtualBox/Machine/Hardware/Memory", "RAMSize", PlaceHolder.MEMORY.toString());
        this.changeAttribute("/VirtualBox/Machine/Hardware/CPU", "count", PlaceHolder.CPU.toString());
        this.changeAttribute("/VirtualBox/Machine/Hardware/Network/Adapter", "MACAddress", PlaceHolder.NETWORKMAC.toString());
        NodeList hdds = this.findNodes("/VirtualBox/Machine/MediaRegistry/HardDisks/HardDisk");
        block0: for (int i = 0; i < hdds.getLength(); ++i) {
            Element hdd = (Element)hdds.item(i);
            if (hdd == null) continue;
            String hddUuid = hdd.getAttribute("uuid");
            hdd.setAttribute("uuid", PlaceHolder.HDDUUID.toString() + i + "%");
            NodeList images = this.findNodes("/VirtualBox/Machine/StorageControllers/StorageController/AttachedDevice/Image");
            for (int j = 0; j < images.getLength(); ++j) {
                Element image = (Element)images.item(j);
                if (image == null || !hddUuid.equals(image.getAttribute("uuid"))) continue;
                image.setAttribute("uuid", PlaceHolder.HDDUUID.toString() + i + "%");
                continue block0;
            }
        }
    }

    private boolean checkForPlaceholders() {
        NodeList hdds = this.findNodes("/VirtualBox/Machine/MediaRegistry/HardDisks/HardDisk");
        for (int i = 0; i < hdds.getLength(); ++i) {
            Element hdd = (Element)hdds.item(i);
            if (hdd == null || !hdd.getAttribute("location").equals(PlaceHolder.HDDLOCATION.toString())) continue;
            return true;
        }
        return false;
    }

    private void removeBlacklistedElements() throws XPathExpressionException {
        for (String blackedTag : blacklist) {
            XPathExpression blackedExpr = XmlHelper.XPath.compile(blackedTag);
            NodeList blackedNodes = (NodeList)blackedExpr.evaluate(this.doc, XPathConstants.NODESET);
            for (int i = 0; i < blackedNodes.getLength(); ++i) {
                Element child = (Element)blackedNodes.item(i);
                this.removeNode(child);
            }
        }
    }

    public String getDisplayName() {
        try {
            return XmlHelper.XPath.compile("/VirtualBox/Machine/@name").evaluate(this.doc);
        }
        catch (XPathExpressionException e) {
            return "";
        }
    }

    public void setOsType() throws XPathExpressionException {
        String os = XmlHelper.XPath.compile("/VirtualBox/Machine/@OSType").evaluate(this.doc);
        if (os != null && !os.isEmpty()) {
            this.osName = os;
        }
    }

    public String getOsName() {
        return this.osName;
    }

    public void setHdds() throws XPathExpressionException {
        XPathExpression hddsExpr = XmlHelper.XPath.compile("/VirtualBox/Machine/MediaRegistry/HardDisks/*");
        NodeList nodes = (NodeList)hddsExpr.evaluate(this.doc, XPathConstants.NODESET);
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node hddDevice;
            Element hddElement = (Element)nodes.item(i);
            if (hddElement == null) continue;
            String fileName = hddElement.getAttribute("location");
            String type = hddElement.getAttribute("type");
            if (!type.equals("Normal") && !type.equals("Writethrough")) {
                LOGGER.warn("Type of the disk file is neither 'Normal' nor 'Writethrough' but: " + type);
                LOGGER.warn("This makes the image not directly modificable, which might lead to problems when editing it locally.");
            }
            if ((hddDevice = hddElement.getParentNode()) == null) {
                LOGGER.error("HDD node had a null parent, shouldn't happen");
                continue;
            }
            Element hddController = (Element)hddDevice.getParentNode();
            if (hddController == null) {
                LOGGER.error("HDD node had a null parent, shouldn't happen");
                continue;
            }
            String controllerDevice = hddController.getAttribute("type");
            String bus = hddController.getAttribute("name");
            VmMetaData.DriveBusType busType = null;
            if (bus.equals("IDE")) {
                busType = VmMetaData.DriveBusType.IDE;
            } else if (bus.equals("SCSI")) {
                busType = VmMetaData.DriveBusType.SCSI;
            } else if (bus.equals("SATA")) {
                busType = VmMetaData.DriveBusType.SATA;
            }
            this.hddsArray.add(new VmMetaData.HardDisk(controllerDevice, busType, fileName));
        }
    }

    public ArrayList<VmMetaData.HardDisk> getHdds() {
        return this.hddsArray;
    }

    public void enableUsb() {
        this.addNewNode("/VirtualBox/Machine/Hardware", "USB");
        this.addNewNode("/VirtualBox/Machine/Hardware/USB", "Controllers");
        Node ohci = this.addNewNode("/VirtualBox/Machine/Hardware/USB/Controllers", "Controller");
        this.addAttributeToNode(ohci, "name", "OHCI");
        this.addAttributeToNode(ohci, "type", "OHCI");
        Node ehci = this.addNewNode("/VirtualBox/Machine/Hardware/USB/Controllers", "Controller");
        this.addAttributeToNode(ehci, "name", "EHCI");
        this.addAttributeToNode(ehci, "type", "EHCI");
    }

    public void disableUsb() {
        NodeList usbList = this.findNodes("/VirtualBox/Machine/Hardware/USB");
        for (int i = 0; i < usbList.getLength(); ++i) {
            this.removeNode(usbList.item(0));
        }
    }

    public boolean isMachineSnapshot() {
        NodeList machineSnapshots = this.findNodes("/VirtualBox/Machine/Snapshot");
        return machineSnapshots != null && machineSnapshots.getLength() > 0;
    }

    public NodeList findNodes(String xpath) {
        NodeList nodes = null;
        try {
            XPathExpression expr = XmlHelper.XPath.compile(xpath);
            Object nodesObject = expr.evaluate(this.doc, XPathConstants.NODESET);
            nodes = (NodeList)nodesObject;
        }
        catch (XPathExpressionException e) {
            LOGGER.error("Could not build path", e);
        }
        return nodes;
    }

    public boolean changeAttribute(String elementXPath, String attribute, String value) {
        NodeList nodes = this.findNodes(elementXPath);
        if (nodes == null || nodes.getLength() != 1) {
            LOGGER.error("No unique node could be found for: " + elementXPath);
            return false;
        }
        return this.addAttributeToNode(nodes.item(0), attribute, value);
    }

    public boolean addAttributeToNode(Node node, String attribute, String value) {
        if (node == null || node.getNodeType() != 1) {
            LOGGER.error("Trying to change attribute of a non element node!");
            return false;
        }
        try {
            ((Element)node).setAttribute(attribute, value);
        }
        catch (DOMException e) {
            LOGGER.error("Failed set '" + attribute + "' to '" + value + "' of xml node '" + node.getNodeName() + "': ", e);
            return false;
        }
        return true;
    }

    public Node addNewNode(String parentXPath, String childName) {
        NodeList possibleParents = this.findNodes(parentXPath);
        if (possibleParents == null || possibleParents.getLength() != 1) {
            LOGGER.error("Could not find unique parent node to add new node to: " + parentXPath);
            return null;
        }
        return this.addNewNode(possibleParents.item(0), childName);
    }

    public Node addNewNode(Node parent, String childName) {
        if (parent == null || parent.getNodeType() != 1) {
            return null;
        }
        Element newNode = null;
        try {
            newNode = this.doc.createElement(childName);
            parent.appendChild(newNode);
        }
        catch (DOMException e) {
            LOGGER.error("Failed to add '" + childName + "' to '" + parent.getNodeName() + "'.");
        }
        return newNode;
    }

    private void removeNode(Node node) {
        if (node == null) {
            return;
        }
        Node parent = node.getParentNode();
        if (parent != null) {
            parent.removeChild(node);
        }
    }

    public String toString(boolean prettyPrint) {
        return XmlHelper.getXmlFromDocument(this.doc, prettyPrint);
    }

    public static enum PlaceHolder {
        FLOPPYUUID("%VM_FLOPPY_UUID%"),
        FLOPPYLOCATION("%VM_FLOPPY_LOCATION%"),
        CPU("%VM_CPU_CORES%"),
        MEMORY("%VM_RAM%"),
        MACHINEUUID("%VM_MACHINE_UUID%"),
        NETWORKMAC("%VM_NIC_MAC%"),
        HDDLOCATION("%VM_HDD_LOCATION%"),
        HDDUUID("%VM_HDD_UUID_");

        private final String holderName;

        private PlaceHolder(String name) {
            this.holderName = name;
        }

        public String toString() {
            return this.holderName;
        }
    }
}

