/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.util.vm;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;
import org.apache.log4j.Logger;
import org.openslx.bwlp.thrift.iface.Virtualizer;
import org.openslx.util.Util;
import org.openslx.util.vm.UnsupportedVirtualizerFormatException;
import org.openslx.util.vm.VmwareConfig;

public class DiskImage {
    private static final Logger LOGGER = Logger.getLogger(DiskImage.class);
    private static final int VMDK_MAGIC = 1262767446;
    private static final int VDI_MAGIC = 2131811006;
    private static final int QEMU_MAGIC = 1363560955;
    public final boolean isStandalone;
    public final boolean isCompressed;
    public final boolean isSnapshot;
    public final ImageFormat format;
    public final String subFormat;
    public final int hwVersion;
    public final String diskDescription;

    public ImageFormat getImageFormat() {
        return this.format;
    }

    public DiskImage(File disk) throws FileNotFoundException, IOException, UnknownImageFormatException {
        LOGGER.debug("Validating disk file: " + disk.getAbsolutePath());
        try (RandomAccessFile file = new RandomAccessFile(disk, "r");){
            boolean isVmdkMagic;
            boolean bl = isVmdkMagic = file.readInt() == 1262767446;
            if (isVmdkMagic || file.length() < 4096L) {
                VmwareConfig config;
                if (isVmdkMagic) {
                    file.seek(512L);
                } else {
                    file.seek(0L);
                }
                byte[] buffer = new byte[(int)Math.min(2048L, file.length())];
                file.readFully(buffer);
                try {
                    config = new VmwareConfig(buffer, this.findNull(buffer));
                }
                catch (UnsupportedVirtualizerFormatException e) {
                    config = null;
                }
                if (config != null) {
                    String sf = config.get("createType");
                    String parent = config.get("parentCID");
                    if (sf != null || parent != null) {
                        this.subFormat = sf;
                        this.isStandalone = this.isStandaloneCreateType(this.subFormat, parent);
                        this.isCompressed = this.subFormat != null && this.subFormat.equalsIgnoreCase("streamOptimized");
                        this.isSnapshot = parent != null && !parent.equalsIgnoreCase("ffffffff");
                        this.format = ImageFormat.VMDK;
                        String hwv = config.get("ddb.virtualHWVersion");
                        this.hwVersion = hwv == null ? 10 : Util.parseInt(hwv, 10);
                        this.diskDescription = null;
                        return;
                    }
                }
            }
            file.seek(64L);
            if (file.readInt() == 2131811006) {
                file.skipBytes(16);
                byte[] imageDesc = new byte[256];
                file.readFully(imageDesc);
                file.skipBytes(52);
                byte[] diskUuid = new byte[16];
                file.readFully(diskUuid);
                file.skipBytes(32);
                byte[] parentUuid = new byte[16];
                file.readFully(parentUuid);
                byte[] zeroUuid = new byte[16];
                Arrays.fill(zeroUuid, (byte)0);
                this.isSnapshot = !Arrays.equals(parentUuid, zeroUuid);
                this.isStandalone = true;
                this.isCompressed = false;
                this.format = ImageFormat.VDI;
                this.subFormat = null;
                this.diskDescription = new String(imageDesc);
                this.hwVersion = 0;
                return;
            }
            file.seek(0L);
            if (file.readInt() == 1363560955) {
                this.isStandalone = true;
                this.isCompressed = false;
                this.isSnapshot = false;
                this.format = ImageFormat.QCOW2;
                this.subFormat = null;
                this.diskDescription = null;
                this.hwVersion = 0;
                return;
            }
        }
        throw new UnknownImageFormatException();
    }

    private int findNull(byte[] buffer) {
        for (int i = 0; i < buffer.length; ++i) {
            if (buffer[i] != 0) continue;
            return i;
        }
        return buffer.length;
    }

    private boolean isStandaloneCreateType(String type, String parent) {
        if (type == null) {
            return false;
        }
        if (parent != null && !parent.equalsIgnoreCase("ffffffff")) {
            return false;
        }
        return type.equalsIgnoreCase("streamOptimized") || type.equalsIgnoreCase("monolithicSparse");
    }

    public static class UnknownImageFormatException
    extends Exception {
        private static final long serialVersionUID = -6647935235475007171L;
    }

    public static enum ImageFormat {
        VMDK("vmdk"),
        QCOW2("qcow2"),
        VDI("vdi");

        public final String extension;

        private ImageFormat(String extension) {
            this.extension = extension;
        }

        public static ImageFormat defaultForVirtualizer(Virtualizer virt) {
            if (virt == null) {
                return null;
            }
            return ImageFormat.defaultForVirtualizer(virt.virtId);
        }

        public static ImageFormat defaultForVirtualizer(String virtId) {
            if (virtId == null) {
                return null;
            }
            if (virtId.equals("vmware")) {
                return VMDK;
            }
            if (virtId.equals("virtualbox")) {
                return VDI;
            }
            if (virtId.equals("qemukvm")) {
                return QCOW2;
            }
            return null;
        }
    }
}

