/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.thrift.cache;

import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.openslx.bwlp.thrift.iface.Organization;
import org.openslx.bwlp.thrift.iface.SatelliteServer;
import org.openslx.bwlp.thrift.iface.UserInfo;
import org.openslx.dozmod.thrift.Sorters;
import org.openslx.thrifthelper.ThriftManager;
import org.openslx.util.GenericDataCache;

public class OrganizationCache {
    private static final Logger LOGGER = Logger.getLogger(OrganizationCache.class);
    private static final int CACHE_TIME_MS = 1200000;
    private static final GenericDataCache<List<Organization>> cache = new GenericDataCache<List<Organization>>(1200000){

        @Override
        protected List<Organization> update() throws Exception {
            List<Organization> orgs = null;
            try {
                orgs = ThriftManager.getMasterClient().getOrganizations();
            }
            catch (Exception e) {
                LOGGER.warn("Failed to get organization list from master server, trying satellite for backup..", e);
            }
            if (orgs == null) {
                SatelliteServer.Iface client = ThriftManager.getSatClient();
                if (client == null) {
                    LOGGER.warn("Satellite server not known yet.");
                } else {
                    try {
                        orgs = client.getAllOrganizations();
                    }
                    catch (Exception e) {
                        LOGGER.error("Failed to get organization list from satellite server. ", e);
                    }
                }
            }
            if (orgs != null) {
                Collections.sort(orgs, Sorters.organization);
            }
            return orgs;
        }
    };

    private OrganizationCache() {
    }

    public static List<Organization> getAll() {
        return cache.get();
    }

    public static Organization find(UserInfo user) {
        return OrganizationCache.find(user.organizationId);
    }

    public static Organization find(String organizationId) {
        List<Organization> list = cache.get(GenericDataCache.CacheMode.PREFER_CACHED);
        Organization org = OrganizationCache.find(organizationId, list);
        if (org != null) {
            return org;
        }
        List<Organization> newList = cache.get(GenericDataCache.CacheMode.DEFAULT);
        if (list == newList) {
            return null;
        }
        return OrganizationCache.find(organizationId, newList);
    }

    private static Organization find(String organizationId, List<Organization> list) {
        if (list != null) {
            for (Organization org : list) {
                if (!org.organizationId.equals(organizationId)) continue;
                return org;
            }
        }
        return null;
    }
}

