/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.thrift;

import java.util.Comparator;
import org.openslx.bwlp.thrift.iface.Location;
import org.openslx.bwlp.thrift.iface.NetShareAuth;
import org.openslx.bwlp.thrift.iface.OperatingSystem;
import org.openslx.bwlp.thrift.iface.Organization;
import org.openslx.bwlp.thrift.iface.UserInfo;
import org.openslx.dozmod.thrift.cache.MetaDataCache;
import org.openslx.dozmod.thrift.cache.UserCache;
import org.openslx.dozmod.util.FormatHelper;

public class Sorters {
    public static final Comparator<UserInfo> userName = new Comparator<UserInfo>(){

        @Override
        public int compare(UserInfo o1, UserInfo o2) {
            return FormatHelper.userName(o1).compareTo(FormatHelper.userName(o2));
        }
    };
    public static final Comparator<String> userNameById = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            return userName.compare(UserCache.find(o1), UserCache.find(o2));
        }
    };
    public static final Comparator<OperatingSystem> osName = new Comparator<OperatingSystem>(){

        @Override
        public int compare(OperatingSystem o1, OperatingSystem o2) {
            if (o1 == null) {
                if (o2 == null) {
                    return 0;
                }
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            return FormatHelper.osName(o1).compareTo(FormatHelper.osName(o2));
        }
    };
    public static final Comparator<Integer> osNameById = new Comparator<Integer>(){

        @Override
        public int compare(Integer o1, Integer o2) {
            if (o1 == null) {
                o1 = 0;
            }
            if (o2 == null) {
                o2 = 0;
            }
            return osName.compare(MetaDataCache.getOsById(o1), MetaDataCache.getOsById(o2));
        }
    };
    public static Comparator<Organization> organization = new Comparator<Organization>(){

        @Override
        public int compare(Organization o1, Organization o2) {
            if (o1 == null || o1.displayName == null) {
                if (o2 == null) {
                    return 0;
                }
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return o1.displayName.compareTo(o2.displayName);
        }
    };
    public static Comparator<Location> locByName = new Comparator<Location>(){

        @Override
        public int compare(Location o1, Location o2) {
            if (o1 == null || o1.locationName == null) {
                if (o2 == null) {
                    return 0;
                }
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return o1.locationName.compareTo(o2.locationName);
        }
    };
    public static final Comparator<NetShareAuth> netShareAuth = new Comparator<NetShareAuth>(){

        @Override
        public int compare(NetShareAuth o1, NetShareAuth o2) {
            if (o1 == null) {
                if (o2 == null) {
                    return 0;
                }
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return o1.compareTo(o2);
        }
    };
}

