/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.gui.wizard;

import java.awt.Window;
import org.apache.log4j.Logger;
import org.apache.thrift.TException;
import org.openslx.bwlp.thrift.iface.ImageDetailsRead;
import org.openslx.bwlp.thrift.iface.ImageVersionWrite;
import org.openslx.dozmod.gui.Gui;
import org.openslx.dozmod.gui.helper.MessageType;
import org.openslx.dozmod.gui.helper.UiFeedback;
import org.openslx.dozmod.gui.wizard.ImageCreationWizard;
import org.openslx.dozmod.gui.wizard.Wizard;
import org.openslx.dozmod.gui.wizard.WizardPage;
import org.openslx.dozmod.gui.wizard.page.ImageUploadPage;
import org.openslx.dozmod.gui.wizard.page.ImageUploadSummaryPage;
import org.openslx.dozmod.state.UploadWizardState;
import org.openslx.dozmod.thrift.ThriftActions;
import org.openslx.dozmod.thrift.UploadInitiator;
import org.openslx.util.QuickTimer;

public class ImageUpdateWizard
extends Wizard
implements UiFeedback {
    private static final Logger LOGGER = Logger.getLogger(ImageCreationWizard.class);
    private final UploadWizardState state = new UploadWizardState();
    protected ImageUploadPage imageUploadPage;

    public ImageUpdateWizard(Window parent, ImageDetailsRead image) {
        super(parent);
        this.imageUploadPage = new ImageUploadPage(this, this.state, image);
        this.addPage(this.imageUploadPage);
    }

    @Override
    protected boolean wantFinish() {
        QuickTimer.scheduleOnce(new QuickTimer.Task(){

            @Override
            public void fire() {
                ((ImageUpdateWizard)ImageUpdateWizard.this).state.upload.startUpload(new UploadInitiator.GotUploadTokenCallback(){

                    @Override
                    public void fire() {
                        block2: {
                            try {
                                ThriftActions.updateImageVersion(((ImageUpdateWizard)ImageUpdateWizard.this).state.upload.getToken(), new ImageVersionWrite(((ImageUpdateWizard)ImageUpdateWizard.this).state.isRestricted));
                            }
                            catch (TException e) {
                                if (!((ImageUpdateWizard)ImageUpdateWizard.this).state.isRestricted) break block2;
                                Gui.showMessageBox(null, "Unerwarteter Fehler beim Setzen der Option 'Enth\u00e4lt lizenzpflichtige Software' f\u00fcr diese Virtuelle Maschine.", MessageType.WARNING, LOGGER, e);
                            }
                        }
                    }
                });
            }
        }, 500L);
        return true;
    }

    @Override
    public WizardPage performFinish() {
        return new ImageUploadSummaryPage(this, this.state, false);
    }

    @Override
    protected boolean onCancelRequest() {
        if (this.state.uuid == null) {
            return true;
        }
        boolean confirmed = Gui.showMessageBox(this, "M\u00f6chten Sie den Vorgang wirklich abbrechen?", MessageType.QUESTION_YESNO, null, null);
        if (confirmed && this.state.upload != null) {
            QuickTimer.scheduleOnce(new QuickTimer.Task(){

                @Override
                public void fire() {
                    ((ImageUpdateWizard)ImageUpdateWizard.this).state.upload.cancelError();
                }
            });
        }
        return confirmed;
    }

    @Override
    public boolean wantConfirmQuit() {
        return this.state.upload != null;
    }

    @Override
    public void escapePressed() {
        this.doCancel();
    }

    @Override
    public String getWindowTitle() {
        return "Neue VM-Version";
    }
}

