/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.gui.window.layout;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Window;
import java.util.Calendar;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerDateModel;
import javax.swing.text.DateFormatter;
import org.jdatepicker.JDatePicker;
import org.openslx.bwlp.thrift.iface.ImageVersionDetails;
import org.openslx.dozmod.Branding;
import org.openslx.dozmod.gui.Gui;
import org.openslx.dozmod.gui.configurator.LdapFilterConfigurator;
import org.openslx.dozmod.gui.configurator.LecturePermissionConfigurator;
import org.openslx.dozmod.gui.configurator.NetrulesConfigurator;
import org.openslx.dozmod.gui.configurator.NetshareConfigurator;
import org.openslx.dozmod.gui.configurator.StartupConfigurator;
import org.openslx.dozmod.gui.control.ComboBox;
import org.openslx.dozmod.gui.control.LocationSelector;
import org.openslx.dozmod.gui.control.PersonLabel;
import org.openslx.dozmod.gui.control.QDatePickerImpl;
import org.openslx.dozmod.gui.control.QLabel;
import org.openslx.dozmod.gui.control.WordWrapLabel;
import org.openslx.dozmod.gui.helper.GridManager;
import org.openslx.dozmod.thrift.Session;
import org.openslx.dozmod.thrift.cache.MetaDataCache;
import org.openslx.dozmod.util.FormatHelper;
import org.openslx.sat.thrift.version.Feature;
import org.openslx.thrifthelper.Comparators;

public abstract class LectureDetailsWindowLayout
extends JDialog {
    protected final QLabel lblTitleInfo;
    protected final JTextField txtTitle;
    protected final JTextArea txtDescription;
    protected final QLabel lblImageNameInfo;
    protected final QLabel txtImageName;
    protected final JButton btnLinkImage;
    protected final PersonLabel lblOwnerInfo;
    protected final PersonLabel lblOwner;
    protected final JButton btnChangeOwner;
    protected final QLabel lblCreateTime;
    protected final PersonLabel lblUpdater;
    protected final QLabel lblUpdateTime;
    protected final QLabel lblStartTime;
    protected final QLabel lblEndTime;
    protected final JCheckBox chkAutoUpdate;
    protected final QLabel lblVersionInfo;
    protected final ComboBox<ImageVersionDetails> cboVersions;
    protected final JCheckBox chkIsExam;
    protected final JCheckBox chkHasInternetAccess;
    protected final JCheckBox chkHasUsbAccess;
    protected final JCheckBox chkIsActive;
    protected final JTextField txtId;
    protected final QLabel lblUseCount;
    protected final QLabel lblError;
    protected final JButton btnSaveChanges;
    protected final JButton btnClose;
    protected final JButton btnDownloadImage;
    protected final JDatePicker dtpStartDate;
    protected final JDatePicker dtpEndDate;
    protected final JSpinner spnStartTime;
    protected final JSpinner spnEndTime;
    protected final JTabbedPane pnlTabs;
    protected final LecturePermissionConfigurator ctlPermissionManager;
    protected final LocationSelector ctlLocationSelector;
    protected final StartupConfigurator ctlRunscriptConfigurator;
    protected final NetshareConfigurator ctlNetshareConfigurator;
    protected final LdapFilterConfigurator ctlLdapFilterConfigurator;
    protected final NetrulesConfigurator ctlNetrulesConfigurator;
    protected final JCheckBox chkCustomPermEdit;
    protected final JCheckBox chkCustomPermAdmin;
    protected final JPanel pnlTabGeneral;
    protected final JPanel pnlTabInfo;
    protected final JPanel pnlTabNetrules;
    protected final JPanel pnlTabRestrictions;
    protected final JPanel pnlTabPermissions;
    protected final JPanel pnlTabLocations;
    protected final JPanel pnlTabRunscript;
    protected final JPanel pnlTabNetshare;
    protected final JPanel pnlTabLdapFilter;

    public LectureDetailsWindowLayout(Frame modalParent) {
        super((Window)modalParent, "Veranstaltungsdetails", Dialog.ModalityType.APPLICATION_MODAL);
        this.setResizable(true);
        this.setPreferredSize(Gui.getScaledDimension(570, 650));
        this.setDefaultCloseOperation(1);
        this.setLayout(new BorderLayout());
        ((JPanel)this.getContentPane()).setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.pnlTabInfo = new JPanel();
        this.pnlTabInfo.setBorder(BorderFactory.createEmptyBorder(25, 25, 25, 25));
        GridManager grdInfo = new GridManager(this.pnlTabInfo, 3, true, new Insets(7, 7, 7, 7));
        this.lblTitleInfo = new QLabel();
        this.lblTitleInfo.setFont(this.lblTitleInfo.getFont().deriveFont(1, this.lblTitleInfo.getFont().getSize2D() * 1.5f));
        grdInfo.add(this.lblTitleInfo, 3);
        grdInfo.nextRow();
        this.lblOwnerInfo = new PersonLabel();
        grdInfo.add(new QLabel("Besitzer"));
        grdInfo.add(this.lblOwnerInfo, 2).expand(true, false);
        grdInfo.nextRow();
        this.lblCreateTime = new QLabel();
        grdInfo.add(new QLabel("Erstellt am"));
        grdInfo.add(this.lblCreateTime, 2);
        grdInfo.nextRow();
        this.lblUpdater = new PersonLabel();
        grdInfo.add(new QLabel("Ge\u00e4ndert durch"));
        grdInfo.add(this.lblUpdater, 2);
        grdInfo.nextRow();
        this.lblUpdateTime = new QLabel();
        grdInfo.add(new QLabel("Ge\u00e4ndert am"));
        grdInfo.add(this.lblUpdateTime, 2);
        grdInfo.nextRow();
        this.lblVersionInfo = new QLabel();
        this.lblImageNameInfo = new QLabel();
        grdInfo.add(new QLabel("Verkn\u00fcpfte VM"), 2);
        grdInfo.add(this.lblImageNameInfo);
        grdInfo.nextRow();
        this.lblStartTime = new QLabel();
        grdInfo.add(new QLabel("Startdatum"), 2);
        grdInfo.add(this.lblStartTime);
        grdInfo.nextRow();
        this.lblEndTime = new QLabel();
        grdInfo.add(new QLabel("Enddatum"), 2);
        grdInfo.add(this.lblEndTime);
        grdInfo.nextRow();
        this.lblUseCount = new QLabel();
        grdInfo.add(new QLabel("Aufrufe"));
        grdInfo.add(this.lblUseCount, 2);
        grdInfo.finish(true);
        this.pnlTabGeneral = new JPanel();
        this.pnlTabGeneral.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        GridManager grdGeneral = new GridManager(this.pnlTabGeneral, 5, true, new Insets(3, 3, 3, 3));
        this.txtTitle = new JTextField();
        grdGeneral.add(new QLabel("Name"));
        grdGeneral.add(this.txtTitle, 4).expand(true, false).fill(true, false);
        grdGeneral.nextRow();
        this.txtDescription = new JTextArea();
        this.txtDescription.setLineWrap(true);
        this.txtDescription.setWrapStyleWord(true);
        grdGeneral.add(new QLabel("Beschreibung")).anchor(23);
        JScrollPane jsp = new JScrollPane(this.txtDescription, 20, 31);
        jsp.setMinimumSize(Gui.getScaledDimension(450, 120));
        jsp.setPreferredSize(Gui.getScaledDimension(450, 120));
        grdGeneral.add(jsp, 4).expand(true, true).fill(true, true);
        grdGeneral.nextRow();
        this.txtId = new JTextField();
        this.txtId.setEditable(false);
        this.txtId.setFont(this.txtId.getFont().deriveFont(1, this.txtId.getFont().getSize2D() * 0.66f));
        grdGeneral.add(new QLabel("ID"));
        grdGeneral.add(this.txtId, 4).expand(true, false).fill(true, false);
        grdGeneral.nextRow();
        this.lblOwner = new PersonLabel();
        this.btnChangeOwner = new JButton("\u00c4ndern");
        grdGeneral.add(new QLabel("Besitzer"));
        grdGeneral.add(this.lblOwner, 3).expand(true, false);
        grdGeneral.add(this.btnChangeOwner).fill(true, false);
        grdGeneral.nextRow();
        this.txtImageName = new QLabel();
        grdGeneral.add(new QLabel("Verkn\u00fcpfte VM"));
        grdGeneral.add(this.txtImageName, 3).expand(true, false);
        this.btnLinkImage = new JButton("\u00c4ndern");
        grdGeneral.add(this.btnLinkImage).fill(true, false);
        grdGeneral.nextRow();
        this.chkAutoUpdate = new JCheckBox("Immer aktuellste Version verwenden");
        this.cboVersions = new ComboBox<ImageVersionDetails>(Comparators.imageVersionDetails, new ComboBox.ComboBoxRenderer<ImageVersionDetails>(){

            @Override
            public String renderItem(ImageVersionDetails item) {
                if (item == null) {
                    return null;
                }
                if (item.isValid) {
                    return FormatHelper.longDate(item.getCreateTime());
                }
                return FormatHelper.longDate(item.getCreateTime()) + " [ung\u00fcltig]";
            }
        });
        this.btnDownloadImage = new JButton("Download");
        this.btnDownloadImage.setToolTipText("Momentan verwendete Version herunterladen");
        JPanel versionPanel = new JPanel(new BorderLayout());
        versionPanel.add(this.cboVersions, "Center");
        versionPanel.add((Component)this.chkAutoUpdate, "South");
        grdGeneral.add(new QLabel("VM-Version"));
        grdGeneral.add(versionPanel, 3);
        grdGeneral.add(this.btnDownloadImage).fill(true, false);
        grdGeneral.nextRow();
        JPanel startTimePanel = new JPanel();
        startTimePanel.setLayout(new BoxLayout(startTimePanel, 2));
        this.dtpStartDate = new QDatePickerImpl();
        this.spnStartTime = this.makeTimeSpinner(23, 59);
        startTimePanel.add(this.dtpStartDate);
        startTimePanel.add(this.spnStartTime);
        startTimePanel.setMinimumSize(startTimePanel.getPreferredSize());
        startTimePanel.setMaximumSize(startTimePanel.getPreferredSize());
        grdGeneral.add(new QLabel("Startdatum"));
        grdGeneral.add(startTimePanel, 4);
        grdGeneral.nextRow();
        JPanel endTimePanel = new JPanel();
        endTimePanel.setLayout(new BoxLayout(endTimePanel, 2));
        this.dtpEndDate = new QDatePickerImpl();
        this.spnEndTime = this.makeTimeSpinner(0, 59);
        endTimePanel.add(this.dtpEndDate);
        endTimePanel.add(this.spnEndTime);
        endTimePanel.setMinimumSize(endTimePanel.getPreferredSize());
        endTimePanel.setMaximumSize(endTimePanel.getPreferredSize());
        grdGeneral.add(new QLabel("Enddatum"));
        grdGeneral.add(endTimePanel, 4);
        grdGeneral.nextRow();
        this.chkIsActive = new JCheckBox("Veranstaltung aktiv");
        grdGeneral.skip();
        grdGeneral.add(this.chkIsActive, 4);
        grdGeneral.nextRow();
        grdGeneral.finish(true);
        Insets descriptionInset = new Insets(2, 4, 2, 4);
        Insets firstInset = new Insets(12, 4, 2, 4);
        this.pnlTabNetrules = new JPanel();
        GridManager grdNetrules = new GridManager(this.pnlTabNetrules, 1, true, new Insets(9, 4, 2, 4));
        this.chkHasInternetAccess = new JCheckBox("Netzwerk-/Internetzugriff zulassen");
        grdNetrules.add(this.chkHasInternetAccess).expand(true, false).insets(firstInset);
        grdNetrules.nextRow();
        grdNetrules.add(new WordWrapLabel("Legen Sie hier fest, ob die Veranstaltung Zugriff zum Internet haben soll. In der Liste k\u00f6nnen Sie bestimmte Adressen und Services ein- oder ausschlie\u00dfen.", false, true)).fill(true, false).expand(true, false).insets(descriptionInset);
        grdNetrules.nextRow();
        this.ctlNetrulesConfigurator = new NetrulesConfigurator();
        grdNetrules.add(this.ctlNetrulesConfigurator).fill(true, true).expand(true, true);
        grdNetrules.nextRow();
        grdNetrules.finish(false);
        this.pnlTabRestrictions = new JPanel();
        GridManager grdRestrictions = new GridManager(this.pnlTabRestrictions, 2, true, new Insets(9, 4, 2, 4));
        this.chkHasUsbAccess = new JCheckBox("Externe Speichermedien zulassen");
        grdRestrictions.add(this.chkHasUsbAccess, 2);
        grdRestrictions.nextRow();
        grdRestrictions.add(new WordWrapLabel("Legen Sie hier fest, ob die Veranstaltung den Zugriff auf Speichermedien (CD, USB, ...) erlauben soll", false, true), 2).fill(true, false).expand(true, false).insets(descriptionInset);
        grdRestrictions.nextRow();
        this.chkIsExam = new JCheckBox("Pr\u00fcfungsmodus");
        grdRestrictions.add(this.chkIsExam, 2);
        grdRestrictions.nextRow();
        grdRestrictions.add(new WordWrapLabel("Markieren Sie diese Veranstaltung als E-Pr\u00fcfung.\nDie Veranstaltung wird nur dann startbar sein, wenn " + Branding.getServiceName() + " in den Pr\u00fcfungsmodus versetzt wird. Kontaktieren Sie dazu Ihren lokalen " + Branding.getServiceName() + "-Administrator.", false, true), 2).fill(true, false).expand(true, false).insets(descriptionInset);
        grdRestrictions.finish(true);
        this.ctlPermissionManager = new LecturePermissionConfigurator();
        this.pnlTabPermissions = new JPanel();
        GridManager grdPermissions = new GridManager(this.pnlTabPermissions, 1, false);
        JPanel defaultPermissionPane = new JPanel();
        defaultPermissionPane.setBorder(BorderFactory.createTitledBorder("Andere Nutzer"));
        this.chkCustomPermEdit = new JCheckBox("Bearbeiten");
        this.chkCustomPermAdmin = new JCheckBox("Admin");
        defaultPermissionPane.add(this.chkCustomPermEdit);
        defaultPermissionPane.add(this.chkCustomPermAdmin);
        grdPermissions.add(this.ctlPermissionManager).fill(true, true).expand(true, true);
        grdPermissions.nextRow();
        grdPermissions.add(defaultPermissionPane).fill(true, false).expand(true, false);
        grdPermissions.finish(false);
        this.ctlLocationSelector = new LocationSelector();
        this.pnlTabLocations = new JPanel();
        GridManager grdLocations = new GridManager(this.pnlTabLocations, 1, false);
        grdLocations.add(this.ctlLocationSelector).fill(true, true).expand(true, true);
        grdLocations.finish(false);
        this.ctlRunscriptConfigurator = new StartupConfigurator();
        this.pnlTabRunscript = new JPanel();
        GridManager grdAdvanced = new GridManager(this.pnlTabRunscript, 1, false);
        grdAdvanced.add(this.ctlRunscriptConfigurator).fill(true, true).expand(true, true);
        grdAdvanced.finish(false);
        this.ctlNetshareConfigurator = new NetshareConfigurator();
        this.pnlTabNetshare = new JPanel();
        GridManager grdNetshare = new GridManager(this.pnlTabNetshare, 1, false, new Insets(8, 2, 8, 2));
        grdNetshare.add(this.ctlNetshareConfigurator).fill(true, true).expand(true, true);
        grdNetshare.finish(false);
        this.ctlLdapFilterConfigurator = new LdapFilterConfigurator();
        this.pnlTabLdapFilter = new JPanel();
        GridManager grdLdap = new GridManager(this.pnlTabLdapFilter, 1, false, new Insets(8, 2, 8, 2));
        grdLdap.add(this.ctlLdapFilterConfigurator).fill(true, true).expand(true, true);
        grdLdap.finish(false);
        this.pnlTabs = new JTabbedPane();
        this.pnlTabs.addTab("\u00dcbersicht", this.pnlTabInfo);
        this.pnlTabs.addTab("Allgemein", this.pnlTabGeneral);
        if (Session.isLectureRestrictionsSupported()) {
            this.pnlTabs.addTab("Beschr\u00e4nkungen", this.pnlTabRestrictions);
            this.pnlTabs.addTab("Firewall", this.pnlTabNetrules);
        }
        if (MetaDataCache.getLocations() != null && !MetaDataCache.getLocations().isEmpty()) {
            this.pnlTabs.addTab("Raumauswahl", this.pnlTabLocations);
        }
        if (Session.isLectureRestrictionsSupported()) {
            this.pnlTabs.addTab("VM-Start", this.pnlTabRunscript);
        }
        this.pnlTabs.addTab("Berechtigungen", this.pnlTabPermissions);
        if (Session.hasFeature(Feature.NETWORK_SHARES)) {
            this.pnlTabs.addTab("Netzlaufwerke", this.pnlTabNetshare);
        }
        if (Session.hasFeature(Feature.LECTURE_FILTER_LDAP)) {
            this.pnlTabs.addTab("LDAP-Filter", this.pnlTabLdapFilter);
        }
        this.add((Component)this.pnlTabs, "Center");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 2));
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.btnClose = new JButton("Schlie\u00dfen");
        this.btnSaveChanges = new JButton("Speichern");
        this.lblError = new QLabel("");
        this.lblError.setForeground(Color.RED);
        buttonPanel.add(this.lblError);
        buttonPanel.add(Box.createGlue());
        buttonPanel.add(this.btnClose);
        buttonPanel.add(this.btnSaveChanges);
        this.add((Component)buttonPanel, "South");
    }

    private JSpinner makeTimeSpinner(int h, int m) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, h);
        calendar.set(12, m);
        calendar.set(13, 0);
        SpinnerDateModel model = new SpinnerDateModel();
        model.setValue(calendar.getTime());
        JSpinner spinner = new JSpinner(model);
        JSpinner.DateEditor editor = new JSpinner.DateEditor(spinner, "HH:mm");
        DateFormatter formatter = (DateFormatter)editor.getTextField().getFormatter();
        formatter.setAllowsInvalid(false);
        formatter.setOverwriteMode(true);
        spinner.setEditor(editor);
        return spinner;
    }
}

