/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.gui.control;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Field;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JTextField;
import org.apache.log4j.Logger;
import org.jdatepicker.ComponentColorDefaults;
import org.jdatepicker.JDatePicker;
import org.openslx.dozmod.gui.helper.ColorUtil;
import org.openslx.dozmod.gui.helper.TextChangeListener;

public class QDatePickerImpl
extends JDatePicker {
    private static final Logger LOGGER;
    private final JButton pickButton;
    private final JTextField displayTextField;
    private final Set<ActionListener> actionListeners = new HashSet<ActionListener>();

    public QDatePickerImpl() {
        super(Calendar.getInstance());
        Field cfButton = null;
        Field cfTextField = null;
        try {
            cfButton = JDatePicker.class.getDeclaredField("button");
            cfButton.setAccessible(true);
        }
        catch (Exception e) {
            LOGGER.warn("Could not get button field", e);
        }
        try {
            cfTextField = JDatePicker.class.getDeclaredField("formattedTextField");
            cfTextField.setAccessible(true);
        }
        catch (Exception e) {
            LOGGER.warn("Could not get text field", e);
        }
        JButton button = null;
        JTextField textField = null;
        if (cfButton != null) {
            try {
                button = (JButton)cfButton.get(this);
            }
            catch (Exception e) {
                LOGGER.warn("Could not get button from this", e);
            }
        }
        if (cfTextField != null) {
            try {
                textField = (JTextField)cfTextField.get(this);
            }
            catch (Exception e) {
                LOGGER.warn("Could not get textfield from this", e);
            }
        }
        this.pickButton = button;
        this.displayTextField = textField;
        if (this.displayTextField != null) {
            this.displayTextField.getDocument().addDocumentListener(new TextChangeListener(){

                @Override
                public void changed() {
                    QDatePickerImpl.this.fireChangeEvent();
                }
            });
        }
    }

    private void fireChangeEvent() {
        if (this.actionListeners.isEmpty()) {
            return;
        }
        ActionEvent ae = new ActionEvent(this, 1001, "Date selected");
        for (ActionListener al : this.actionListeners) {
            al.actionPerformed(ae);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.pickButton != null) {
            this.pickButton.setEnabled(enabled);
        }
        if (this.displayTextField != null) {
            this.displayTextField.setEnabled(enabled);
        }
        super.setEnabled(enabled);
    }

    @Override
    public void addActionListener(ActionListener actionListener) {
        this.actionListeners.add(actionListener);
    }

    static {
        Color c2;
        LOGGER = Logger.getLogger(QDatePickerImpl.class);
        ComponentColorDefaults def = ComponentColorDefaults.getInstance();
        Color c1 = def.getColor(ComponentColorDefaults.Key.FG_MONTH_SELECTOR);
        if ((double)ColorUtil.getContrast(c1, c2 = def.getColor(ComponentColorDefaults.Key.BG_MONTH_SELECTOR)) < 4.5) {
            def.setColor(ComponentColorDefaults.Key.FG_MONTH_SELECTOR, Color.WHITE);
            def.setColor(ComponentColorDefaults.Key.BG_MONTH_SELECTOR, new Color(0, 0, 128));
        }
    }
}

