/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.gui.configurator;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;
import org.openslx.bwlp.thrift.iface.ImagePermissions;
import org.openslx.bwlp.thrift.iface.UserInfo;
import org.openslx.dozmod.gui.changemonitor.GenericControlWindow;
import org.openslx.dozmod.gui.control.table.ImagePermissionTable;
import org.openslx.dozmod.gui.control.table.QScrollPane;
import org.openslx.dozmod.gui.helper.GridManager;
import org.openslx.dozmod.gui.window.UserListWindow;
import org.openslx.dozmod.thrift.cache.UserCache;
import org.openslx.dozmod.util.FormatHelper;

public class ImagePermissionConfigurator
extends JPanel
implements GenericControlWindow<Map<String, ImagePermissions>> {
    protected ImagePermissionTable permissionTable;
    protected JButton btnAddUser;
    protected JButton btnRemoveUser;
    private String ownerId;
    private ArrayList<ImagePermissionTable.UserImagePermissions> permissionList = new ArrayList();
    private ImagePermissions defaultPermissions;
    private static final Logger LOGGER = Logger.getLogger(ImagePermissionConfigurator.class);
    private final List<ChangeListener> listeners = new ArrayList<ChangeListener>(1);

    public ImagePermissionConfigurator() {
        GridManager grid = new GridManager(this, 1);
        this.permissionTable = new ImagePermissionTable();
        JPanel userButtonPane = new JPanel();
        userButtonPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        userButtonPane.setLayout(new BoxLayout(userButtonPane, 2));
        this.btnAddUser = new JButton("Benutzer hinzuf\u00fcgen");
        userButtonPane.add(this.btnAddUser);
        this.btnRemoveUser = new JButton("Benutzer entfernen");
        userButtonPane.add(this.btnRemoveUser);
        userButtonPane.add(Box.createGlue());
        QScrollPane jsp = new QScrollPane(this.permissionTable);
        jsp.setBackground(UIManager.getColor("Table.background"));
        grid.add(jsp).fill(true, true).expand(true, true);
        grid.nextRow();
        grid.add(userButtonPane).fill(true, false).expand(true, false);
        grid.nextRow();
        grid.finish(false);
        this.btnAddUser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UserListWindow.open(SwingUtilities.getWindowAncestor(ImagePermissionConfigurator.this), new UserListWindow.UserAddedCallback(){

                    @Override
                    public void userAdded(UserInfo newUser, UserListWindow window) {
                        for (ImagePermissionTable.UserImagePermissions current : ImagePermissionConfigurator.this.permissionList) {
                            if (!current.userId.equals(newUser.userId)) continue;
                            LOGGER.debug("User already present in the list, skipping!");
                            return;
                        }
                        ImagePermissionConfigurator.this.permissionList.add(new ImagePermissionTable.UserImagePermissions(newUser.userId, new ImagePermissions(ImagePermissionConfigurator.this.defaultPermissions)));
                        ImagePermissionConfigurator.this.permissionTable.setData(ImagePermissionConfigurator.this.permissionList, false);
                        ImagePermissionConfigurator.this.fireUserChangeEvent();
                    }
                }, "Hinzuf\u00fcgen", ImagePermissionConfigurator.this.ownerId);
            }
        });
        this.btnRemoveUser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImagePermissionTable.UserImagePermissions selected = (ImagePermissionTable.UserImagePermissions)ImagePermissionConfigurator.this.permissionTable.getSelectedItem();
                if (selected != null && !ImagePermissionConfigurator.this.permissionList.remove(selected)) {
                    LOGGER.debug("Could not remove: " + selected);
                }
                ImagePermissionConfigurator.this.permissionTable.setData(ImagePermissionConfigurator.this.permissionList, false);
                ImagePermissionConfigurator.this.fireUserChangeEvent();
            }
        });
        this.permissionTable.getInputMap(1).put(KeyStroke.getKeyStroke(127, 0), "delete");
        this.permissionTable.getActionMap().put("delete", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ImagePermissionConfigurator.this.btnRemoveUser.doClick();
            }
        });
        this.permissionTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ImagePermissionConfigurator.this.fireUserChangeEvent();
            }
        });
    }

    public void initPanel(Map<String, ImagePermissions> permissionMap, ImagePermissions defaultPermissions, String ownerId) {
        this.ownerId = ownerId;
        this.defaultPermissions = defaultPermissions;
        this.permissionList.clear();
        if (permissionMap != null) {
            for (Map.Entry<String, ImagePermissions> e : permissionMap.entrySet()) {
                this.permissionList.add(new ImagePermissionTable.UserImagePermissions(e.getKey(), e.getValue()));
            }
        }
        Collections.sort(this.permissionList, new Comparator<ImagePermissionTable.UserImagePermissions>(){

            @Override
            public int compare(ImagePermissionTable.UserImagePermissions o1, ImagePermissionTable.UserImagePermissions o2) {
                UserInfo u1 = UserCache.find(o1.userId);
                UserInfo u2 = UserCache.find(o2.userId);
                if (u1 != null && u2 != null) {
                    return FormatHelper.userName(u1).compareTo(FormatHelper.userName(u2));
                }
                return 0;
            }
        });
        this.permissionTable.setData(this.permissionList, false);
    }

    public Map<String, ImagePermissions> getPermissions() {
        HashMap<String, ImagePermissions> newPermissionMap = new HashMap<String, ImagePermissions>(this.permissionList.size());
        for (ImagePermissionTable.UserImagePermissions perm : this.permissionList) {
            newPermissionMap.put(perm.userId, new ImagePermissions(perm.permissions));
        }
        return newPermissionMap;
    }

    void fireUserChangeEvent() {
        for (ChangeListener cl : this.listeners) {
            cl.stateChanged(null);
        }
    }

    @Override
    public Map<String, ImagePermissions> getState() {
        return this.getPermissions();
    }

    @Override
    public void addChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }
}

