/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.openslx.dozmod.App;
import org.openslx.dozmod.Config;

public final class Branding {
    private static final Logger LOGGER = Logger.getLogger(Branding.class);
    private static final String PROPERTIES_FILE = "branding.properties";
    private static final Properties PROPERTIES = new Properties();
    private static final List<Path> RESOURCES = new ArrayList<Path>();

    public static final String getMasterServerAddress() {
        return PROPERTIES.getProperty("masterserver.address", "bwlp-masterserver.ruf.uni-freiburg.de");
    }

    public static final String getMasterServerIdm() {
        return PROPERTIES.getProperty("masterserver.idm", "bwIDM");
    }

    public static final String getApplicationName() {
        return PROPERTIES.getProperty("application.name", "bwLehrpool-Suite");
    }

    public static final String getServiceFAQWebsite() {
        return PROPERTIES.getProperty("service.faq.website", "https://www.bwLehrpool.de");
    }

    public static final String getServiceName() {
        return PROPERTIES.getProperty("service.name", "bwLehrpool");
    }

    public static final String getConfigDirectory() {
        return PROPERTIES.getProperty("config.directory", "bwSuite");
    }

    public static final String getServiceEmail() {
        return PROPERTIES.getProperty("service.email", "bwlehrpool@hs-offenburg.de");
    }

    public static final String getProxyMode() {
        return PROPERTIES.getProperty("proxy.mode", Config.ProxyMode.AUTO.toString());
    }

    public static void dump(String localDir) {
        URI jarUri;
        if (localDir == null || localDir.isEmpty()) {
            return;
        }
        Path dumpDir = Paths.get(localDir, new String[0]);
        if (!Files.isDirectory(dumpDir, new LinkOption[0])) {
            try {
                Files.createDirectories(dumpDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                LOGGER.error("Failed to create missing dump directory: ", e);
                return;
            }
        }
        if ((jarUri = Branding.getRunningJarURI()) == null || jarUri.getPath() == null || jarUri.getPath().isEmpty()) {
            return;
        }
        Branding.copyBranding(jarUri, dumpDir.toString(), false);
    }

    public static void pack(String localDir, String outputJar) {
        URI jarUri = Branding.getRunningJarURI();
        if (jarUri == null || jarUri.getPath() == null || jarUri.getPath().isEmpty()) {
            return;
        }
        File brandingDir = new File(localDir);
        if (!brandingDir.isDirectory()) {
            LOGGER.error("Given path is not a directory: " + localDir);
            return;
        }
        Path newJarPath = Paths.get(outputJar, new String[0]);
        try {
            Files.copy(Paths.get(jarUri), newJarPath, new CopyOption[0]);
        }
        catch (Exception e) {
            LOGGER.error("Failed to copy jar file at location '" + jarUri.getPath() + "' to '" + newJarPath + "': ", e);
            try {
                Files.delete(newJarPath);
            }
            catch (IOException e1) {
                LOGGER.error("Failed to cleanup '" + newJarPath + ": ", e1);
            }
        }
        Branding.copyBranding(newJarPath.toUri(), localDir, true);
    }

    private static void copyBranding(URI jarUri, String localDir, boolean pack) {
        try (FileSystem fs = FileSystems.newFileSystem(URI.create("jar:" + jarUri), new HashMap<String, String>(){
            {
                this.put("create", "true");
                this.put("encoding", "UTF-8");
            }
        });){
            Path rootPathJar = fs.getPath(fs.getSeparator(), new String[0]);
            Iterator<Path> it = fs.getRootDirectories().iterator();
            if (it.hasNext()) {
                rootPathJar = it.next();
                if (it.hasNext()) {
                    LOGGER.debug("Multiple root directories within the JAR found? Trying with first one '" + rootPathJar + "'...");
                }
            }
            Path rootPathLocal = Paths.get(localDir, new String[0]);
            for (Path res : RESOURCES) {
                Path dst;
                Path src;
                if (pack) {
                    src = rootPathLocal.resolve(res);
                    dst = rootPathJar.resolve(rootPathLocal.relativize(res).toString());
                } else {
                    src = rootPathJar.resolve(res.toString());
                    dst = rootPathLocal.resolve(res);
                }
                if (!Files.isReadable(src)) {
                    LOGGER.error("Failed to find or read '" + src + "'.");
                    return;
                }
                if (Files.isDirectory(src, new LinkOption[0])) {
                    Files.walkFileTree(src, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                            Path cur = dst.resolve(src.relativize(file).toString());
                            if (!Files.isDirectory(cur.getParent(), new LinkOption[0])) {
                                Files.createDirectory(cur.getParent(), new FileAttribute[0]);
                            }
                            Files.copy(file, cur, StandardCopyOption.REPLACE_EXISTING);
                            return FileVisitResult.CONTINUE;
                        }
                    });
                    continue;
                }
                if (Files.isRegularFile(src, new LinkOption[0])) {
                    Files.copy(src, dst, StandardCopyOption.REPLACE_EXISTING);
                    continue;
                }
                LOGGER.error("Unknown file type for '" + src + "'.");
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to dump branding resources from JAR: ", e);
            return;
        }
    }

    private static URI getRunningJarURI() {
        CodeSource cs = App.class.getProtectionDomain().getCodeSource();
        if (cs == null) {
            LOGGER.error("Failed to get code source of this class.");
            return null;
        }
        try {
            return cs.getLocation().toURI();
        }
        catch (URISyntaxException e) {
            LOGGER.error("Failed to get location of this JAR.");
            return null;
        }
    }

    static {
        try (InputStream in = App.class.getClassLoader().getResourceAsStream(PROPERTIES_FILE);){
            PROPERTIES.load(in);
        }
        catch (Exception e) {
            LOGGER.error("Failed to read 'branding.properties': ", e);
        }
        RESOURCES.add(Paths.get(PROPERTIES_FILE, new String[0]));
        RESOURCES.add(Paths.get("img", new String[0]));
        RESOURCES.add(Paths.get("txt", new String[0]));
    }
}

