/*
 * Decompiled with CFR 0.152.
 */
package com.btr.proxy.selector.misc;

import com.btr.proxy.util.ProxyUtil;
import java.io.IOException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ProxyListFallbackSelector
extends ProxySelector {
    private static final int DEFAULT_RETRY_DELAY = 600000;
    private ProxySelector delegate;
    private ConcurrentHashMap<SocketAddress, Long> failedDelayCache = new ConcurrentHashMap();
    private long retryAfterMs;

    public ProxyListFallbackSelector(ProxySelector delegate) {
        this(600000L, delegate);
    }

    public ProxyListFallbackSelector(long retryAfterMs, ProxySelector delegate) {
        this.delegate = delegate;
        this.retryAfterMs = retryAfterMs;
    }

    @Override
    public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
        this.failedDelayCache.put(sa, System.currentTimeMillis());
        this.delegate.connectFailed(uri, sa, ioe);
    }

    @Override
    public List<Proxy> select(URI uri) {
        this.cleanupCache();
        List<Proxy> proxyList = this.delegate.select(uri);
        List<Proxy> result = this.filterUnresponsiveProxiesFromList(proxyList);
        if (result.isEmpty()) {
            return ProxyUtil.noProxyList();
        }
        return result;
    }

    private void cleanupCache() {
        Iterator<Map.Entry<SocketAddress, Long>> it = this.failedDelayCache.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<SocketAddress, Long> e = it.next();
            Long lastFailTime = e.getValue();
            if (!this.retryDelayHasPassedBy(lastFailTime)) continue;
            it.remove();
        }
    }

    private List<Proxy> filterUnresponsiveProxiesFromList(List<Proxy> proxyList) {
        if (this.failedDelayCache.isEmpty()) {
            return proxyList;
        }
        ArrayList<Proxy> result = new ArrayList<Proxy>(proxyList.size());
        for (Proxy proxy : proxyList) {
            if (!this.isDirect(proxy) && !this.isNotUnresponsive(proxy)) continue;
            result.add(proxy);
        }
        return result;
    }

    private boolean isDirect(Proxy proxy) {
        return Proxy.NO_PROXY.equals(proxy);
    }

    private boolean isNotUnresponsive(Proxy proxy) {
        Long lastFailTime = this.failedDelayCache.get(proxy.address());
        return this.retryDelayHasPassedBy(lastFailTime);
    }

    private boolean retryDelayHasPassedBy(Long lastFailTime) {
        return lastFailTime == null || lastFailTime + this.retryAfterMs < System.currentTimeMillis();
    }

    final void setRetryAfterMs(long retryAfterMs) {
        this.retryAfterMs = retryAfterMs;
    }
}

