/*
 * Decompiled with CFR 0.152.
 */
package com.btr.proxy.selector.fixed;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class FixedProxySelector
extends ProxySelector {
    private List<Proxy> proxyList;

    public FixedProxySelector(Proxy ... proxy) {
        if (proxy.length == 0) {
            throw new IllegalArgumentException("Empty list was passed");
        }
        this.proxyList = Collections.unmodifiableList(Arrays.asList(proxy));
        if (this.proxyList.contains(null)) {
            throw new NullPointerException("List conains NULL proxy");
        }
    }

    public FixedProxySelector(Proxy.Type type, String proxyHost, int proxyPort) {
        this(new Proxy(type, InetSocketAddress.createUnresolved(proxyHost, proxyPort)));
    }

    @Override
    public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
        List<Proxy> list = this.proxyList;
        if (list.size() < 2) {
            return;
        }
        if (!list.get(0).address().equals(sa)) {
            return;
        }
        ArrayList<Proxy> newList = new ArrayList<Proxy>(list.size());
        Proxy broken = null;
        for (Proxy p : list) {
            if (p.address().equals(sa)) {
                broken = p;
                continue;
            }
            newList.add(p);
        }
        if (broken != null) {
            newList.add(broken);
        }
        this.proxyList = Collections.unmodifiableList(newList);
    }

    @Override
    public List<Proxy> select(URI uri) {
        return this.proxyList;
    }

    public Proxy.Type getType() {
        return this.proxyList.get(0).type();
    }
}

