/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XmlHelper {
    private static final Logger LOGGER = Logger.getLogger(XmlHelper.class);
    public static final XPath XPath = XPathFactory.newInstance().newXPath();
    private static DocumentBuilder dBuilder;

    public static Document parseDocumentFromStream(InputStream is) {
        Document doc = null;
        try {
            doc = dBuilder.parse(is);
        }
        catch (IOException | SAXException e) {
            LOGGER.error("Failed to parse input stream to document.");
        }
        if (doc == null) {
            return null;
        }
        doc.getDocumentElement().normalize();
        return doc;
    }

    public static Document removeFormattingNodes(Document doc) {
        NodeList empty;
        try {
            empty = (NodeList)XPath.evaluate("//text()[normalize-space(.) = '']", doc, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            LOGGER.error("Bad XPath expression to find all empty text nodes.");
            return null;
        }
        for (int i = 0; i < empty.getLength(); ++i) {
            Node node = empty.item(i);
            node.getParentNode().removeChild(node);
        }
        return doc;
    }

    public static String getUnformattedXml(InputStream is) {
        Document doc = XmlHelper.parseDocumentFromStream(is);
        return XmlHelper.getXmlFromDocument(XmlHelper.removeFormattingNodes(doc), false);
    }

    public static String getFormattedXml(InputStream is) {
        Document doc = XmlHelper.parseDocumentFromStream(is);
        return XmlHelper.getXmlFromDocument(doc, true);
    }

    public static String getXmlFromDocument(Document doc, boolean humanReadable) {
        try {
            StringWriter writer = new StringWriter();
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "no");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("method", "xml");
            if (humanReadable) {
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            }
            transformer.transform(new DOMSource(doc), new StreamResult(writer));
            return writer.toString();
        }
        catch (Exception ex) {
            LOGGER.error("Failed to transform XML to String: ", ex);
            return null;
        }
    }

    static {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        dbFactory.setIgnoringComments(true);
        try {
            dBuilder = dbFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            LOGGER.error("Failed to initalize DOM parser with default configurations.");
        }
    }
}

