/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.util;

import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class Util {
    private static Logger log = Logger.getLogger(Util.class);
    private static Pattern nonprintableExp = Pattern.compile("[\\p{C}\\p{Zl}\\p{Zp}]");
    private static Pattern nonSpaceExp = Pattern.compile("[^\\p{C}\\p{Z}]");

    public static void notNullFatal(Object something, String message) {
        if (something == null) {
            if (message != null) {
                log.fatal("[NOTNULL] " + message);
            }
            log.warn("Fatal null pointer exception", new NullPointerException());
            System.exit(2);
        }
    }

    public static boolean isPrintable(String string) {
        return !nonprintableExp.matcher(string).find();
    }

    public static boolean isEmptyString(String string) {
        return string == null || !nonSpaceExp.matcher(string).find();
    }

    public static void notNullOrEmptyFatal(String something, String message) {
        if (Util.isEmptyString(something)) {
            if (message != null) {
                log.fatal("[NOTNULL] " + message);
            }
            log.warn("Fatal null pointer or empty exception", new NullPointerException());
            System.exit(2);
        }
    }

    public static int parseInt(String value, int defaultValue) {
        try {
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static void safeClose(AutoCloseable ... closeable) {
        for (AutoCloseable c : closeable) {
            if (c == null) continue;
            try {
                c.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static boolean sleep(int millis) {
        try {
            Thread.sleep(millis);
            return true;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    public static boolean joinThread(Thread t) {
        try {
            t.join();
            return true;
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    public static long unixTime() {
        return System.currentTimeMillis() / 1000L;
    }
}

