/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.openslx.util.TimeoutReference;

public class TimeoutHashMap<K, V>
implements Map<K, V> {
    private final Map<K, TimeoutReference<V>> map = new HashMap<K, TimeoutReference<V>>();
    private final long timeout;

    public TimeoutHashMap(long timeout) {
        this.timeout = timeout;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public V get(Object key) {
        TimeoutReference<V> timeoutReference = this.map.get(key);
        if (timeoutReference == null) {
            return null;
        }
        V obj = timeoutReference.get();
        if (obj == null && timeoutReference.isInvalid()) {
            this.map.remove(key);
        }
        return obj;
    }

    @Override
    public V put(K key, V value) {
        this.map.put(key, new TimeoutReference<V>(false, this.timeout, value));
        return value;
    }

    @Override
    public V remove(Object key) {
        TimeoutReference<V> remove = this.map.remove(key);
        if (remove == null) {
            return null;
        }
        return remove.get();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    public Map<K, V> getImmutableSnapshot() {
        HashMap<K, V> copy = new HashMap<K, V>();
        for (Map.Entry<K, TimeoutReference<V>> i : this.map.entrySet()) {
            V v = i.getValue().get();
            if (i.getValue().isInvalid()) continue;
            copy.put(i.getKey(), v);
        }
        return Collections.unmodifiableMap(copy);
    }

    @Override
    public Collection<V> values() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        throw new UnsupportedOperationException();
    }
}

