/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.imagemaster.crcchecker;

import java.io.IOException;
import java.util.zip.CRC32;
import org.openslx.imagemaster.crcchecker.CrcFile;
import org.openslx.imagemaster.crcchecker.ImageFile;

public class CrcChecker {
    private static final int blockSize = 0x1000000;
    private ImageFile imageFile;
    private CrcFile crcFile;
    private byte[] block = new byte[0x1000000];

    public CrcChecker(ImageFile imageFile, CrcFile crcFile) {
        this.imageFile = imageFile;
        this.crcFile = crcFile;
    }

    public void done() {
        this.imageFile.close();
    }

    public boolean hasValidCrcFile() {
        return this.crcFile.isValid();
    }

    public boolean checkBlock(int blockNumber) throws IOException {
        int length;
        if (!this.hasValidCrcFile()) {
            return false;
        }
        try {
            length = this.imageFile.getBlock(blockNumber, this.block);
        }
        catch (IOException e) {
            throw new IOException("image", e);
        }
        if (length <= 0) {
            return false;
        }
        CRC32 crcCalc = new CRC32();
        if (length == 0x1000000) {
            crcCalc.update(this.block);
        } else {
            crcCalc.update(this.block, 0, length);
        }
        int crcSum = Integer.reverseBytes((int)crcCalc.getValue());
        int crcSumFromFile = this.crcFile.getCRCSum(blockNumber);
        return crcSum == crcSumFromFile;
    }
}

