/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.filetransfer;

import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.KeyStore;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.log4j.BasicConfigurator;
import org.openslx.filetransfer.Downloader;
import org.openslx.filetransfer.FileRange;
import org.openslx.filetransfer.IncomingEvent;
import org.openslx.filetransfer.Listener;
import org.openslx.filetransfer.Uploader;
import org.openslx.filetransfer.WantRangeCallback;
import org.slf4j.LoggerFactory;

public class ClassTest {
    private static final int CHUNK_SIZE = 11111111;
    private static String inFile;
    private static String outFile;

    public static void main(String[] args) throws Exception {
        if (args.length != 4) {
            System.out.println("Need 4 argument: <keystore> <passphrase> <infile> <outfile>");
            System.exit(1);
        }
        String pathToKeyStore = args[0];
        char[] passphrase = args[1].toCharArray();
        inFile = args[2];
        outFile = args[3];
        KeyStore keystore = KeyStore.getInstance("JKS");
        keystore.load(new FileInputStream(pathToKeyStore), passphrase);
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmf.init(keystore, passphrase);
        SSLContext context = SSLContext.getInstance("TLSv1.2");
        KeyManager[] keyManagers = kmf.getKeyManagers();
        context.init(keyManagers, null, null);
        Listener listener = new Listener(new Test(), context, 6789, 10000);
        listener.start();
        Thread.sleep(2000L);
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(keystore);
        context = SSLContext.getInstance("TLSv1.2");
        TrustManager[] trustManagers = tmf.getTrustManagers();
        context.init(null, trustManagers, null);
        Downloader d = new Downloader("localhost", 6789, 10000, context, "xyz");
        boolean res = d.download(outFile, new WantRangeCallback(){
            long pos = 0L;
            long size = -1L;

            @Override
            public FileRange get() {
                if (this.size == -1L) {
                    try {
                        this.size = Files.size(Paths.get(inFile, new String[0]));
                    }
                    catch (IOException e) {
                        return null;
                    }
                }
                if (this.pos >= this.size) {
                    return null;
                }
                long end = Math.min(this.pos + 11111111L, this.size);
                FileRange range = new FileRange(this.pos, end);
                this.pos += 11111111L;
                return range;
            }
        });
        if (res) {
            System.out.println("Active Download OK");
        } else {
            System.out.println("Active Download FAILED");
        }
    }

    static {
        BasicConfigurator.configure();
        LoggerFactory.getLogger("ROOT");
    }

    static class Test
    implements IncomingEvent {
        Test() {
        }

        @Override
        public void incomingDownloadRequest(Uploader uploader) throws IOException {
            if (uploader.getToken() == null) {
                System.out.println("Incoming uploader: could not get token!");
                return;
            }
            if (!uploader.upload(inFile)) {
                System.out.println("Incoming uploader failed!");
            } else {
                System.out.println("Incomgin uploader OK");
            }
        }

        @Override
        public void incomingUploadRequest(Downloader downloader) throws IOException {
            if (downloader.getToken() == null) {
                System.out.println("Incoming downloader: could not get token!");
                return;
            }
        }
    }
}

