/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.thrift;

import java.awt.Frame;
import java.awt.Window;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.thrift.TException;
import org.apache.thrift.transport.TTransportException;
import org.openslx.bwlp.thrift.iface.ImageBaseWrite;
import org.openslx.bwlp.thrift.iface.ImageDetailsRead;
import org.openslx.bwlp.thrift.iface.ImagePermissions;
import org.openslx.bwlp.thrift.iface.ImagePublishData;
import org.openslx.bwlp.thrift.iface.ImageVersionDetails;
import org.openslx.bwlp.thrift.iface.ImageVersionWrite;
import org.openslx.bwlp.thrift.iface.LecturePermissions;
import org.openslx.bwlp.thrift.iface.LectureRead;
import org.openslx.bwlp.thrift.iface.LectureSummary;
import org.openslx.bwlp.thrift.iface.LectureWrite;
import org.openslx.bwlp.thrift.iface.Satellite;
import org.openslx.bwlp.thrift.iface.SatelliteServer;
import org.openslx.bwlp.thrift.iface.TAuthorizationException;
import org.openslx.bwlp.thrift.iface.TInvocationException;
import org.openslx.bwlp.thrift.iface.TNotFoundException;
import org.openslx.bwlp.thrift.iface.TransferInformation;
import org.openslx.bwlp.thrift.iface.TransferState;
import org.openslx.bwlp.thrift.iface.UserInfo;
import org.openslx.bwlp.thrift.iface.WhoamiInfo;
import org.openslx.dozmod.App;
import org.openslx.dozmod.Branding;
import org.openslx.dozmod.Config;
import org.openslx.dozmod.authentication.Authenticator;
import org.openslx.dozmod.filetransfer.DownloadTask;
import org.openslx.dozmod.filetransfer.TransferEvent;
import org.openslx.dozmod.filetransfer.TransferEventListener;
import org.openslx.dozmod.gui.GraphicalCertHandler;
import org.openslx.dozmod.gui.Gui;
import org.openslx.dozmod.gui.MainWindow;
import org.openslx.dozmod.gui.helper.MessageType;
import org.openslx.dozmod.gui.helper.QFileChooser;
import org.openslx.dozmod.gui.window.SatelliteListWindow;
import org.openslx.dozmod.thrift.Session;
import org.openslx.dozmod.thrift.ThriftError;
import org.openslx.dozmod.thrift.cache.ImageCache;
import org.openslx.dozmod.thrift.cache.LectureCache;
import org.openslx.dozmod.thrift.cache.MetaDataCache;
import org.openslx.dozmod.thrift.cache.UserCache;
import org.openslx.dozmod.util.FormatHelper;
import org.openslx.dozmod.util.VmWrapper;
import org.openslx.thrifthelper.ThriftManager;
import org.openslx.util.QuickTimer;
import org.openslx.util.vm.DiskImage;

public class ThriftActions {
    private static final Logger LOGGER = Logger.getLogger(ThriftActions.class);
    private static final long SIZE_CHECK_EXTRA_DL = 0x3200000L;

    public static boolean initSession(Authenticator.AuthenticationData data, boolean forceCustomSatellite, Window window) {
        boolean interactive = data != null;
        SatelliteServer.Client client = null;
        WhoamiInfo whoami2 = null;
        String address = null;
        String satToken = null;
        String masterToken = null;
        long remoteVersion = -1L;
        if (interactive && !forceCustomSatellite && (data.satellites == null || data.satellites.isEmpty())) {
            Gui.asyncMessageBox("Login erfolgreich, aber es wurde kein Satellitenserver gefunden.\n Bitte geben Sie die Adresse Ihres Servers manuell an.", MessageType.ERROR, LOGGER, null);
        }
        do {
            if (!interactive) {
                Config.SavedSession session = Config.getSavedSession();
                if (session == null) {
                    return false;
                }
                address = session.address;
                satToken = session.token;
                masterToken = session.masterToken;
            } else {
                Satellite sat = null;
                if (forceCustomSatellite && (sat = SatelliteListWindow.open(window, data.satellites)) == null) {
                    return false;
                }
                if (sat == null) {
                    if (data.satellites != null && data.satellites.size() == 1) {
                        sat = data.satellites.get(0);
                    }
                    if (sat == null) {
                        if (!forceCustomSatellite) {
                            Iterator<Satellite> it = data.satellites.iterator();
                            while (it.hasNext()) {
                                Satellite entry = it.next();
                                if (entry.displayName == null || !entry.displayName.startsWith("{x}")) continue;
                                it.remove();
                            }
                        }
                        if (data.satellites.size() != 1) {
                            sat = SatelliteListWindow.open(window, data.satellites);
                            if (sat == null) {
                                return false;
                            }
                        } else {
                            sat = data.satellites.get(0);
                        }
                    }
                }
                if (sat.addressList == null || sat.addressList.isEmpty()) {
                    Gui.asyncMessageBox("Login erfolgreich, aber f\u00fcr den ausgew\u00e4hlten Satellitenserver ist\nkeine Adresse hinterlegt. Kann nicht verbinden.", MessageType.ERROR, LOGGER, null);
                    continue;
                }
                address = sat.addressList.get(0);
                satToken = data.satelliteToken;
                masterToken = data.masterToken;
                forceCustomSatellite = true;
            }
            client = ThriftManager.getNewSatelliteClient(GraphicalCertHandler.getSslContext(address), address, 9091, 5000);
            if (client != null) {
                try {
                    remoteVersion = client.getVersion(5L);
                }
                catch (TTransportException sat) {
                }
                catch (TException e) {
                    remoteVersion = 1L;
                }
            }
            if (client == null || remoteVersion == -1L) {
                if (interactive) {
                    Gui.asyncMessageBox("Authentifizierung erfolgreich, die Verbindung zum Satellitenserver ist jedoch nicht m\u00f6glich.\n\nM\u00f6glicherweise ist der Server nicht verf\u00fcgbar, oder die Netzwerkverbindung gest\u00f6rt.", MessageType.ERROR, null, null);
                    if (data.satellites.size() != 1) continue;
                    return false;
                }
                return false;
            }
            if (remoteVersion < 4L || remoteVersion > 5L) {
                if (interactive) {
                    Gui.asyncMessageBox("Das von Ihnen verwendete Dozentenmodul ist nicht mit dem gew\u00e4hlten Satellitenserver kompatibel.\nIhre Version: 5\nSatelliten-Version: " + remoteVersion, MessageType.ERROR, LOGGER, null);
                    continue;
                }
                return false;
            }
            try {
                whoami2 = client.whoami(satToken);
            }
            catch (TAuthorizationException e) {
                if (interactive) {
                    ThriftError.showMessage(window, LOGGER, e, "Authentifizierung erfolgreich, der Satellitenserver verweigert jedoch die Verbindung.\nVersuchen Sie, sich erneut anzumelden.\n");
                }
                return false;
            }
            catch (TException e) {
                if (interactive) {
                    ThriftError.showMessage(window, LOGGER, e, "Authentifizierung erfolgreich, bei der Kommunikation mit dem Satellitenserver trat jedoch ein interner Fehler auf.");
                    continue;
                }
                return false;
            }
            catch (Exception e) {
                if (interactive) {
                    Gui.asyncMessageBox("Unbekannter Fehler beim Verbinden mit dem Satellitenserver.", MessageType.ERROR, LOGGER, e);
                    continue;
                }
                return false;
            }
        } while (interactive && whoami2 == null);
        if (whoami2 != null) {
            Session.initialize(whoami2, address, satToken, masterToken, remoteVersion);
            ThriftManager.setSatelliteAddress(GraphicalCertHandler.getSslContext(Session.getSatelliteAddress()), Session.getSatelliteAddress(), 9091, 15000);
            QuickTimer.scheduleOnce(new QuickTimer.Task(){

                @Override
                public void fire() {
                    MetaDataCache.getOperatingSystems();
                    MetaDataCache.getVirtualizers();
                    UserCache.getAll();
                    ImageCache.get(false);
                    LectureCache.get(false);
                }
            });
            return true;
        }
        return false;
    }

    public static String createImage(Frame frame, String name) {
        String uuid = null;
        try {
            uuid = ThriftManager.getSatClient().createImage(Session.getSatelliteToken(), name);
        }
        catch (TException e) {
            ThriftError.showMessage(frame, LOGGER, e, "Erstellen der VM fehlgeschlagen");
        }
        catch (Exception e) {
            Gui.showMessageBox(frame, "Unbekannter Fehler beim Erstellen der VM", MessageType.ERROR, LOGGER, e);
        }
        return uuid;
    }

    public static void updateImageBase(String imageBaseId, ImageBaseWrite meta) throws TAuthorizationException, TNotFoundException, TInvocationException, TException {
        ThriftManager.getSatClient().updateImageBase(Session.getSatelliteToken(), imageBaseId, meta);
    }

    public static void writeImagePermissions(String imageBaseId, Map<String, ImagePermissions> permissions) throws TAuthorizationException, TNotFoundException, TInvocationException, TException {
        ThriftManager.getSatClient().writeImagePermissions(Session.getSatelliteToken(), imageBaseId, permissions);
    }

    public static void updateImageVersion(String versionId, ImageVersionWrite versionInfo) throws TAuthorizationException, TNotFoundException, TInvocationException, TException {
        ThriftManager.getSatClient().updateImageVersion(Session.getSatelliteToken(), versionId, versionInfo);
    }

    public static void initDownload(final Frame frame, final String imageVersionId, final String imageName, final String virtualizerId, final int osId, final long imageSize, final DownloadCallback callback) {
        QFileChooser fc = new QFileChooser(Config.getDownloadPath(), true);
        fc.setDialogTitle("Bitte w\u00e4hlen Sie einen Speicherort");
        int action = fc.showSaveDialog(frame);
        File selected = fc.getSelectedFile();
        if (action != 0 || selected == null) {
            if (callback != null) {
                callback.downloadInitialized(false);
            }
            return;
        }
        final File destDir = new File(selected, ThriftActions.generateDirname(imageName, imageVersionId));
        final File tmpDiskFile = new File(destDir.getAbsolutePath(), VmWrapper.generateFilename(imageName, null) + ".part");
        if (destDir.exists()) {
            boolean ret = Gui.showMessageBox(frame, "Verzeichnis '" + destDir.getAbsolutePath() + "' existiert bereits, wollen Sie die VM darin \u00fcberschreiben?", MessageType.QUESTION_YESNO, LOGGER, null);
            if (!ret) {
                if (callback != null) {
                    callback.downloadInitialized(false);
                }
                return;
            }
            if (!tmpDiskFile.delete() && tmpDiskFile.exists()) {
                Gui.showMessageBox(frame, "Datei konnte nicht \u00fcberschrieben werden!", MessageType.ERROR, LOGGER, null);
                if (callback != null) {
                    callback.downloadInitialized(false);
                }
                return;
            }
        } else {
            destDir.getAbsoluteFile().mkdirs();
        }
        if (destDir.getUsableSpace() < imageSize + 0x3200000L) {
            Gui.showMessageBox(frame, "Nicht gen\u00fcgend Speicherplatz im ausgew\u00e4hlten Verzeichnis verf\u00fcgbar.\nBrauche: " + FormatHelper.bytes(imageSize + 0x3200000L, false) + "\nHabe: " + FormatHelper.bytes(destDir.getUsableSpace(), false), MessageType.ERROR, LOGGER, null);
            if (callback != null) {
                callback.downloadInitialized(false);
            }
            return;
        }
        QuickTimer.scheduleOnce(new QuickTimer.Task(){

            @Override
            public void fire() {
                DownloadTask dlTask;
                TException transEx = null;
                String transHost = null;
                TransferInformation transInf = null;
                try {
                    transInf = ThriftManager.getSatClient().requestDownload(Session.getSatelliteToken(), imageVersionId);
                    transHost = Session.getSatelliteAddress();
                }
                catch (TException e) {
                    transEx = e;
                }
                if (transInf == null) {
                    transHost = null;
                    try {
                        transInf = ThriftManager.getMasterClient().downloadImage(Session.getSatelliteToken(), imageVersionId);
                        transHost = App.getMasterServerAddress();
                    }
                    catch (TException e) {
                        transEx = e;
                    }
                }
                if (transInf == null) {
                    ThriftError.showMessage(frame, LOGGER, transEx, "Die Download-Anfrage ist gescheitert");
                    if (callback != null) {
                        callback.downloadInitialized(false);
                    }
                    return;
                }
                String fTransHost = transHost;
                final TransferInformation fTransInf = transInf;
                try {
                    dlTask = new DownloadTask(fTransHost, transInf.getPlainPort(), transInf.getToken(), tmpDiskFile, imageSize, null);
                }
                catch (FileNotFoundException e) {
                    Gui.asyncMessageBox("Konnte Download nicht vorbereiten: Der gew\u00e4hlte Zielort ist nicht beschreibbar", MessageType.ERROR, LOGGER, e);
                    if (callback != null) {
                        callback.downloadInitialized(false);
                    }
                    return;
                }
                dlTask.setMinConnections(Config.getTransferConnectionCount());
                dlTask.addListener(new TransferEventListener(){

                    @Override
                    public void update(TransferEvent event) {
                        if (event.state != TransferState.FINISHED) {
                            return;
                        }
                        DiskImage diskImage = null;
                        String ext = virtualizerId;
                        try {
                            diskImage = new DiskImage(tmpDiskFile);
                        }
                        catch (IOException | DiskImage.UnknownImageFormatException e) {
                            LOGGER.warn("Could not open downloaded image for analyze step", e);
                        }
                        if (diskImage != null) {
                            if (diskImage.format != null) {
                                ext = diskImage.format.extension;
                            }
                            if (diskImage.isCompressed) {
                                String msg = "<html>Die heruntergeladene VM '" + imageName + "' ist ein komprimiertes Abbild.<br>Sie m\u00fcssen das Abbild dekomprimieren, bevor Sie es ver\u00e4ndern k\u00f6nnen.<br> Die VM wird lokal voraussichtlich nicht startf\u00e4hig sein!<br><br>Bitte lesen Sie die Hinweise unter <a href=\"" + Branding.getServiceFAQWebsite() + "\">VMDK Disk Types</a>";
                                Gui.asyncMessageBox(msg, MessageType.WARNING, null, null);
                            }
                        }
                        File destImage = new File(destDir.getAbsolutePath(), VmWrapper.generateFilename(imageName, ext));
                        destImage.delete();
                        if (!tmpDiskFile.renameTo(destImage)) {
                            destImage = tmpDiskFile;
                        }
                        try {
                            VmWrapper.wrapVm(destImage, imageName, fTransInf.getMachineDescription(), virtualizerId, osId, diskImage);
                        }
                        catch (IOException | VmWrapper.MetaDataMissingException e) {
                            Gui.asyncMessageBox("Zur heruntergeladenen VM konnte keine vmx-Datei angelegt werden.\nSie k\u00f6nnen versuchen, das Abbild manuell in den VMWare-Player zu importieren.", MessageType.WARNING, LOGGER, e);
                        }
                    }
                });
                Gui.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        MainWindow.addDownload(imageName, tmpDiskFile.getName(), dlTask);
                    }
                });
                new Thread(dlTask).start();
                Config.setDownloadPath(destDir.getParentFile().getAbsolutePath());
                if (callback != null) {
                    callback.downloadInitialized(true);
                }
            }
        });
    }

    private static String generateDirname(String imageName, String imageVersionId) {
        String fileName = imageName.replaceAll("[^a-zA-Z0-9_\\.\\-]+", "_");
        if (fileName.length() > 50) {
            fileName = fileName.substring(0, 50);
        }
        fileName = fileName + "--" + imageVersionId.substring(0, 8);
        return fileName;
    }

    public static ImageDetailsRead getImageDetails(Frame frame, String imageBaseId) {
        ImageDetailsRead details = null;
        try {
            details = ThriftManager.getSatClient().getImageDetails(Session.getSatelliteToken(), imageBaseId);
        }
        catch (TException e) {
            ThriftError.showMessage(frame, LOGGER, e, "Fehler beim Lesen der Metadaten");
        }
        return details;
    }

    public static void getImageDetails(final Frame frame, final String imageBaseId, final ImageMetaCallback callback) {
        QuickTimer.scheduleOnce(new QuickTimer.Task(){
            ImageDetailsRead details = null;

            @Override
            public void fire() {
                this.details = ThriftActions.getImageDetails(frame, imageBaseId);
                Gui.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (callback != null) {
                            callback.fetchedImageDetails(details, null);
                        }
                    }
                });
            }
        });
    }

    public static ImagePublishData getImageData(String imageBaseId) {
        ImagePublishData data = null;
        try {
            data = ThriftManager.getMasterClient().getImageData(Session.getSatelliteToken(), imageBaseId);
        }
        catch (TException e) {
            LOGGER.error("Could not query sat for ImagePublishData for '" + imageBaseId + "':", e);
        }
        return data;
    }

    public static void getImagePermissions(final Frame frame, final String imageBaseId, final ImageMetaCallback callback) {
        QuickTimer.scheduleOnce(new QuickTimer.Task(){
            Map<String, ImagePermissions> permissionMap = null;

            @Override
            public void fire() {
                this.permissionMap = ThriftActions.getImagePermissions(frame, imageBaseId);
                Gui.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (callback != null) {
                            callback.fetchedImageDetails(null, permissionMap);
                        }
                    }
                });
            }
        });
    }

    public static Map<String, ImagePermissions> getImagePermissions(Frame frame, String imageBaseId) {
        Map<String, ImagePermissions> permissionMap = null;
        try {
            permissionMap = ThriftManager.getSatClient().getImagePermissions(Session.getSatelliteToken(), imageBaseId);
        }
        catch (TException e) {
            ThriftError.showMessage(frame, LOGGER, e, "Fehler beim Lesen der Metadaten");
        }
        return permissionMap;
    }

    public static boolean setImageOwner(Frame frame, String lectureId, UserInfo newOwner) {
        try {
            ThriftManager.getSatClient().setImageOwner(Session.getSatelliteToken(), lectureId, newOwner.getUserId());
        }
        catch (TException e) {
            ThriftError.showMessage(frame, LOGGER, e, "Fehler beim \u00dcbertragen der Besitzrechte");
            return false;
        }
        return true;
    }

    public static void deleteImageBase(Frame frame, String imageBaseId) {
        String questionText;
        if (imageBaseId == null || imageBaseId.isEmpty()) {
            return;
        }
        ImageDetailsRead details = null;
        ArrayList<LectureSummary> lecturesToBeDeleted = null;
        ArrayList<ImageVersionDetails> versionToBeDeleted = null;
        try {
            details = ThriftManager.getSatClient().getImageDetails(Session.getSatelliteToken(), imageBaseId);
            List<LectureSummary> lectureList = ThriftManager.getSatClient().getLectureList(Session.getSatelliteToken(), 100);
            for (LectureSummary lecture : lectureList) {
                if (!imageBaseId.equals(lecture.getImageBaseId())) continue;
                if (lecturesToBeDeleted == null) {
                    lecturesToBeDeleted = new ArrayList<LectureSummary>();
                }
                lecturesToBeDeleted.add(lecture);
            }
            for (ImageVersionDetails version : details.getVersions()) {
                if (!version.isValid) continue;
                if (versionToBeDeleted == null) {
                    versionToBeDeleted = new ArrayList<ImageVersionDetails>();
                }
                versionToBeDeleted.add(version);
            }
        }
        catch (TException e) {
            ThriftError.showMessage(frame, LOGGER, e, "Fehler beim Holen der Versionen/Veranstaltung zu folgender VM: " + imageBaseId);
            return;
        }
        if (versionToBeDeleted != null && !versionToBeDeleted.isEmpty()) {
            questionText = "Die VM \"" + details.getImageName() + "\" hat folgende g\u00fcltige Versionen:\n";
            for (ImageVersionDetails version : versionToBeDeleted) {
                questionText = questionText + version.getVersionId() + "\n";
            }
            questionText = questionText + "\n";
        } else {
            questionText = "";
        }
        if (lecturesToBeDeleted != null && !lecturesToBeDeleted.isEmpty()) {
            questionText = questionText + "Folgende Veranstaltungen sind mit dieser VM verkn\u00fcpft: \n";
            for (LectureSummary lecture : lecturesToBeDeleted) {
                questionText = questionText + lecture.getLectureName() + "\n";
            }
            questionText = questionText + "\n";
        }
        if (!ThriftActions.userConfirmed(frame, questionText = questionText + "Wollen Sie wirklich mit dem L\u00f6schen fortfahren?")) {
            return;
        }
        try {
            ThriftManager.getSatClient().deleteImageBase(Session.getSatelliteToken(), imageBaseId);
        }
        catch (TException e) {
            ThriftError.showMessage(frame, LOGGER, e, "Konnte VM-Daten nicht l\u00f6schen!");
        }
    }

    public static void deleteImageVersion(Frame frame, ImageVersionDetails version, final DeleteCallback callback) {
        if (version == null || version.versionId == null || version.versionId.isEmpty()) {
            return;
        }
        String versionId = version.versionId;
        boolean success = false;
        List<LectureSummary> lectureList = null;
        try {
            lectureList = ThriftManager.getSatClient().getLectureList(Session.getSatelliteToken(), 100);
        }
        catch (TException e) {
            ThriftError.showMessage(frame, LOGGER, e, "Fehler beim Holen der Liste der Veranstaltungen");
            if (callback != null) {
                callback.isDeleted(success);
            }
            return;
        }
        String questionText = "";
        boolean matches = false;
        if (lectureList != null && !lectureList.isEmpty()) {
            for (LectureSummary lecture : lectureList) {
                if (!versionId.equals(lecture.getImageVersionId())) continue;
                if (!matches) {
                    questionText = "Diese Version ist zu folgende Veranstaltungen verkn\u00fcpft:\n";
                }
                matches = true;
                questionText = questionText + lecture.getLectureName() + "\n";
            }
            if (matches) {
                questionText = questionText + "\nWollen Sie diese Version samt Veranstaltungen l\u00f6schen?\n";
            }
        }
        if (!matches) {
            questionText = "Wollen Sie die VM-Image-Version vom " + FormatHelper.shortDate(version.createTime) + " Uhr wirklich l\u00f6schen?";
        }
        if (!ThriftActions.userConfirmed(frame, questionText)) {
            return;
        }
        try {
            ThriftManager.getSatClient().deleteImageVersion(Session.getSatelliteToken(), versionId);
            LOGGER.info("Deleted version '" + versionId + "'.");
            success = true;
        }
        catch (TException e) {
            ThriftError.showMessage(frame, LOGGER, e, "Fehler beim L\u00f6schen der Version");
            if (callback != null) {
                callback.isDeleted(success);
            }
            return;
        }
        final boolean fSuccess = success;
        Gui.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (callback != null) {
                    callback.isDeleted(fSuccess);
                }
            }
        });
    }

    public static String createLecture(Frame frame, LectureWrite meta) {
        if (meta == null) {
            return null;
        }
        String uuid = null;
        try {
            uuid = ThriftManager.getSatClient().createLecture(Session.getSatelliteToken(), meta);
        }
        catch (TException e) {
            ThriftError.showMessage(frame, LOGGER, e, "Failed to create lecture");
        }
        return uuid;
    }

    public static boolean writeLecturePermissions(Frame frame, String lectureId, Map<String, LecturePermissions> permissions) {
        try {
            ThriftManager.getSatClient().writeLecturePermissions(Session.getSatelliteToken(), lectureId, permissions);
        }
        catch (TException e) {
            ThriftError.showMessage(frame, LOGGER, e, "Failed to write lecture permissions");
            return false;
        }
        return true;
    }

    public static void getLectureAndImageDetails(final Frame frame, final String lectureId, final LectureMetaCallback callback) {
        QuickTimer.scheduleOnce(new QuickTimer.Task(){

            @Override
            public void fire() {
                final LectureRead lecture = ThriftActions.getLectureDetails(frame, lectureId);
                final ImageDetailsRead fImage = lecture != null && lecture.imageBaseId != null ? ThriftActions.getImageDetails(frame, lecture.getImageBaseId()) : null;
                Gui.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (callback != null) {
                            callback.fetchedLectureAndImageDetails(lecture, fImage);
                        }
                    }
                });
            }
        });
    }

    public static LectureRead getLectureDetails(Frame frame, String lectureId) {
        LectureRead lecture = null;
        try {
            lecture = ThriftManager.getSatClient().getLectureDetails(Session.getSatelliteToken(), lectureId);
        }
        catch (TException e) {
            ThriftError.showMessage(frame, LOGGER, e, "Konnte Veranstaltungdaten nicht abrufen");
        }
        return lecture;
    }

    public static boolean updateLecture(Frame frame, String lectureId, LectureWrite lectureWrite) {
        try {
            ThriftManager.getSatClient().updateLecture(Session.getSatelliteToken(), lectureId, lectureWrite);
        }
        catch (TException e) {
            ThriftError.showMessage(frame, LOGGER, e, "Fehler beim Updaten der Veranstaltung");
            return false;
        }
        return true;
    }

    public static Map<String, LecturePermissions> getLecturePermissions(Frame frame, String lectureId) {
        Map<String, LecturePermissions> permissions = null;
        try {
            permissions = ThriftManager.getSatClient().getLecturePermissions(Session.getSatelliteToken(), lectureId);
        }
        catch (TException e) {
            ThriftError.showMessage(frame, LOGGER, e, "Konnte Veranstaltungdaten nicht abrufen");
        }
        return permissions;
    }

    public static boolean setLectureOwner(Frame frame, String lectureId, UserInfo newOwner) {
        try {
            ThriftManager.getSatClient().setLectureOwner(Session.getSatelliteToken(), lectureId, newOwner.getUserId());
        }
        catch (TException e) {
            ThriftError.showMessage(frame, LOGGER, e, "Fehler beim \u00dcbertragen der Besitzrechte");
            return false;
        }
        return true;
    }

    public static void deleteLecture(Frame frame, final List<LectureSummary> lectures, final DeleteLectureCallback callback) {
        String messageText;
        if (lectures == null) {
            return;
        }
        String string = messageText = lectures.size() == 1 ? "Wollen Sie diese Veranstaltung wirklich l\u00f6schen?" : "Wollen Sie die " + lectures.size() + " Veranstaltungen wirklich l\u00f6schen?";
        if (!ThriftActions.userConfirmed(frame, messageText)) {
            return;
        }
        QuickTimer.scheduleOnce(new QuickTimer.Task(){
            Map<LectureSummary, TException> failedLectures = new HashMap<LectureSummary, TException>();

            @Override
            public void fire() {
                for (LectureSummary l : lectures) {
                    if (l == null) continue;
                    try {
                        ThriftManager.getSatClient().deleteLecture(Session.getSatelliteToken(), l.lectureId);
                    }
                    catch (TException e) {
                        this.failedLectures.put(l, e);
                    }
                }
                Gui.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (callback != null) {
                            callback.deleted(failedLectures);
                        }
                    }
                });
            }
        });
    }

    public static ImageDetailsRead getPublishedImageDetails(String imageBaseId) {
        ImageDetailsRead data = null;
        try {
            data = ThriftManager.getMasterClient().getImageDetails(Session.getMasterToken(), imageBaseId);
        }
        catch (TException e) {
            LOGGER.error("Could not query masterserver for ImageDetailsRead for version '" + imageBaseId + "':", e);
        }
        return data;
    }

    private static boolean userConfirmed(Frame frame, String message) {
        return Gui.showMessageBox(frame, message, MessageType.QUESTION_YESNO, null, null);
    }

    public static interface DeleteLectureCallback {
        public void deleted(Map<LectureSummary, TException> var1);
    }

    public static interface LectureMetaCallback {
        public void fetchedLectureAndImageDetails(LectureRead var1, ImageDetailsRead var2);
    }

    public static interface DeleteCallback {
        public void isDeleted(boolean var1);
    }

    public static interface ImageMetaCallback {
        public void fetchedImageDetails(ImageDetailsRead var1, Map<String, ImagePermissions> var2);
    }

    public static interface DownloadCallback {
        public void downloadInitialized(boolean var1);
    }
}

