/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.gui.wizard;

import java.awt.Color;
import java.awt.Dialog;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.openslx.dozmod.gui.wizard.Wizard;

public abstract class WizardPage
extends JPanel {
    private static final Color WARNING_COLOR = new Color(200, 100, 0);
    private final String title;
    private String description = null;
    private String message = null;
    private boolean isError = false;
    private boolean isComplete = false;
    protected final Wizard wizard;
    protected boolean canComeBack = true;

    public WizardPage(Wizard wizard, String title) {
        if (wizard == null) {
            throw new NullPointerException("WizardPage needs a Wizard");
        }
        this.wizard = wizard;
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public String getMessage() {
        if (this.message != null) {
            return this.message;
        }
        return this.description;
    }

    private void updateHeader() {
        if (this.wizard != null) {
            this.wizard.updateHeader(this);
        }
    }

    protected Dialog getDialog() {
        return this.wizard;
    }

    public boolean isComplete() {
        return this.isComplete;
    }

    protected boolean wantNextOrFinish() {
        return this.isComplete;
    }

    protected void onPageEnter() {
    }

    protected void onPageLeave() {
    }

    protected void setPageComplete(boolean b) {
        if (this.isComplete == b) {
            return;
        }
        this.isComplete = b;
        if (this.wizard != null) {
            this.wizard.updateButtons(this);
        }
    }

    protected void setDescription(String description) {
        this.message = null;
        this.description = description;
        this.updateHeader();
    }

    protected void setErrorMessage(String message) {
        this.message = message;
        this.isError = true;
        this.updateHeader();
    }

    protected void setWarningMessage(String message) {
        this.message = message;
        this.isError = false;
        this.updateHeader();
    }

    protected Icon getMessageIcon() {
        if (this.message == null) {
            return null;
        }
        if (this.isError) {
            return UIManager.getIcon("OptionPane.errorIcon");
        }
        return UIManager.getIcon("OptionPane.warningIcon");
    }

    public Color getMessageColor() {
        if (this.message == null) {
            return Color.BLACK;
        }
        if (this.isError) {
            return Color.RED;
        }
        return WARNING_COLOR;
    }
}

