/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.gui.window;

import java.awt.Color;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.apache.thrift.TException;
import org.openslx.bwlp.thrift.iface.ImageBaseWrite;
import org.openslx.bwlp.thrift.iface.ImageDetailsRead;
import org.openslx.bwlp.thrift.iface.ImagePermissions;
import org.openslx.bwlp.thrift.iface.ImageSummaryRead;
import org.openslx.bwlp.thrift.iface.ImageVersionDetails;
import org.openslx.bwlp.thrift.iface.LectureSummary;
import org.openslx.bwlp.thrift.iface.OperatingSystem;
import org.openslx.bwlp.thrift.iface.ShareMode;
import org.openslx.bwlp.thrift.iface.UserInfo;
import org.openslx.bwlp.thrift.iface.Virtualizer;
import org.openslx.dozmod.Branding;
import org.openslx.dozmod.gui.Gui;
import org.openslx.dozmod.gui.MainWindow;
import org.openslx.dozmod.gui.changemonitor.AbstractControlWrapper;
import org.openslx.dozmod.gui.changemonitor.DialogChangeMonitor;
import org.openslx.dozmod.gui.helper.DateTimeHelper;
import org.openslx.dozmod.gui.helper.ExpiryDateChooser;
import org.openslx.dozmod.gui.helper.MessageType;
import org.openslx.dozmod.gui.helper.PopupMenu;
import org.openslx.dozmod.gui.helper.UiFeedback;
import org.openslx.dozmod.gui.window.LectureListWindow;
import org.openslx.dozmod.gui.window.UserListWindow;
import org.openslx.dozmod.gui.window.VirtConfigEditorWindow;
import org.openslx.dozmod.gui.window.VirtDropDownConfigEditorWindow;
import org.openslx.dozmod.gui.window.layout.ImageDetailsWindowLayout;
import org.openslx.dozmod.gui.wizard.ImageUpdateWizard;
import org.openslx.dozmod.gui.wizard.LectureWizard;
import org.openslx.dozmod.permissions.ImagePerms;
import org.openslx.dozmod.thrift.ImageDetailsActions;
import org.openslx.dozmod.thrift.Session;
import org.openslx.dozmod.thrift.ThriftActions;
import org.openslx.dozmod.thrift.ThriftError;
import org.openslx.dozmod.thrift.cache.LectureCache;
import org.openslx.dozmod.thrift.cache.MetaDataCache;
import org.openslx.dozmod.thrift.cache.UserCache;
import org.openslx.dozmod.util.DesktopEnvironment;
import org.openslx.dozmod.util.FormatHelper;
import org.openslx.sat.thrift.version.Feature;
import org.openslx.thrifthelper.Comparators;
import org.openslx.thrifthelper.ThriftManager;
import org.openslx.util.QuickTimer;
import org.openslx.util.ThriftUtil;
import org.openslx.util.Util;

public class ImageDetailsWindow
extends ImageDetailsWindowLayout
implements UiFeedback {
    private static final Logger LOGGER = Logger.getLogger(ImageDetailsWindow.class);
    private final ImageDetailsWindow me = this;
    private final ImageDetailsActions actionHandler;
    private ImageUpdatedCallback callback = null;
    private ImageDetailsRead image = null;
    private Map<String, ImagePermissions> customPermissions;
    private boolean adminRightsFromDefaultPermissions;
    private final JMenuItem mnuNewLecture = new JMenuItem("Neue Veranstaltung");
    private final JMenuItem mnuDownload = new JMenuItem("Download");
    private final JMenuItem mnuVmConfig = new JMenuItem("VM-Konfiguration");
    private final JMenuItem mnuDelete = new JMenuItem("L\u00f6schen");
    private final JMenuItem mnuExtendExpiryDate = new JMenuItem("Ablaufzeitpunkt verl\u00e4ngern");
    private DialogChangeMonitor changeMonitor;
    private AbstractControlWrapper<?> changeListenerPermissions;

    public ImageDetailsWindow(Frame modalParent, ImageUpdatedCallback callback, ImageDetailsActions actionHandler) {
        super(modalParent);
        this.callback = callback;
        this.actionHandler = actionHandler;
        this.changeMonitor = new DialogChangeMonitor(new DialogChangeMonitor.Callback(){

            @Override
            public void validityChanged(String errorMessage) {
                ImageDetailsWindow.this.lblError.setText(errorMessage);
                ImageDetailsWindow.this.btnSaveChanges.setEnabled(ImageDetailsWindow.this.changeMonitor.isValid() && ImageDetailsWindow.this.changeMonitor.wasEverModified());
                LOGGER.info("Valid: " + ImageDetailsWindow.this.changeMonitor.isValid());
            }

            @Override
            public void modificationChanged() {
                ImageDetailsWindow.this.btnSaveChanges.setEnabled(ImageDetailsWindow.this.changeMonitor.isValid() && ImageDetailsWindow.this.changeMonitor.wasEverModified());
                LOGGER.info("Changed: " + ImageDetailsWindow.this.changeMonitor.isCurrentlyModified());
            }
        });
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ImageDetailsWindow.this.safeClose();
            }
        });
        this.btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageDetailsWindow.this.safeClose();
            }
        });
        this.btnSaveChanges.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageDetailsWindow.this.saveChanges();
            }
        });
        this.btnUpdateImage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new ImageUpdateWizard((Window)ImageDetailsWindow.this.me, ImageDetailsWindow.this.image).setVisible(true);
                ImageDetailsWindow.this.refresh(true);
            }
        });
        this.btnUploadToMaster.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageDetailsWindow.this.uploadToMaster();
            }
        });
        this.btnShowLinkingLectures.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ImageDetailsWindow.this.safeClose()) {
                    LectureListWindow page = MainWindow.showPage(LectureListWindow.class);
                    page.filterByImageBaseId(((ImageDetailsWindow)ImageDetailsWindow.this).image.imageBaseId);
                }
            }
        });
        this.btnChangeOwner.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UserListWindow.open(ImageDetailsWindow.this.me, new UserListWindow.UserAddedCallback(){

                    @Override
                    public void userAdded(UserInfo user, UserListWindow window) {
                        window.dispose();
                        if (Gui.showMessageBox(ImageDetailsWindow.this.me, "Sind Sie sicher, dass sie die Besitzerrechte an einen anderen Benutzer \u00fcbertragen wollen?", MessageType.QUESTION_YESNO, LOGGER, null)) {
                            ImageDetailsWindow.this.setImageOwner(user);
                        }
                    }
                }, "Besitzer festlegen", ((ImageDetailsWindow)ImageDetailsWindow.this).image.ownerId);
            }
        });
        this.tblVersions.setSelectionMode(2);
        final PopupMenu pop = new PopupMenu(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageVersionDetails selected = (ImageVersionDetails)ImageDetailsWindow.this.tblVersions.getSelectedItem();
                if (selected == null) {
                    return;
                }
                if (e.getSource().equals(ImageDetailsWindow.this.mnuNewLecture)) {
                    ImageSummaryRead summary = new ImageSummaryRead();
                    summary.setImageName(ImageDetailsWindow.this.image.getImageName());
                    new LectureWizard((Window)ImageDetailsWindow.this.me, summary, selected.getVersionId()).setVisible(true);
                }
                if (e.getSource().equals(ImageDetailsWindow.this.mnuDownload)) {
                    ImageDetailsWindow.this.performImageDownload(selected);
                }
                if (e.getSource().equals(ImageDetailsWindow.this.mnuDelete)) {
                    ImageDetailsWindow.this.deleteVersions(ImageDetailsWindow.this.tblVersions.getSelectedItems());
                }
                if (e.getSource().equals(ImageDetailsWindow.this.mnuVmConfig)) {
                    ImageDetailsWindow.this.editVmConfig(selected);
                }
                if (e.getSource().equals(ImageDetailsWindow.this.mnuExtendExpiryDate)) {
                    ImageDetailsWindow.this.extendVersionExpiry(ImageDetailsWindow.this.tblVersions.getSelectedItems());
                }
            }
        });
        pop.addMenuItem(this.mnuNewLecture);
        pop.addMenuItem(this.mnuDownload);
        if (Session.isLectureRestrictionsSupported()) {
            pop.addMenuItem(this.mnuVmConfig);
        }
        pop.addSeparator();
        pop.addMenuItem(this.mnuDelete);
        if (Session.canExtendImageExpiry()) {
            pop.addSeparator();
            pop.addMenuItem(this.mnuExtendExpiryDate);
        }
        this.tblVersions.getInputMap(1).put(KeyStroke.getKeyStroke(127, 0), "delete");
        this.tblVersions.getActionMap().put("delete", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (ImagePerms.canEdit(ImageDetailsWindow.this.image)) {
                    ImageDetailsWindow.this.deleteVersions(ImageDetailsWindow.this.tblVersions.getSelectedItems());
                }
            }
        });
        MouseAdapter ma = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.processClick(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.processClick(e);
            }

            private void processClick(MouseEvent e) {
                int mouseRowIndex = ImageDetailsWindow.this.tblVersions.rowAtPoint(e.getPoint());
                boolean alreadySelectedRow = false;
                for (int i : ImageDetailsWindow.this.tblVersions.getSelectedRows()) {
                    if (i != mouseRowIndex) continue;
                    alreadySelectedRow = true;
                    break;
                }
                if (mouseRowIndex >= 0 && mouseRowIndex < ImageDetailsWindow.this.tblVersions.getRowCount() && SwingUtilities.isRightMouseButton(e)) {
                    if (!alreadySelectedRow) {
                        ImageDetailsWindow.this.tblVersions.setRowSelectionInterval(mouseRowIndex, mouseRowIndex);
                    }
                    if (e.isPopupTrigger()) {
                        boolean multiSelection = ImageDetailsWindow.this.tblVersions.getSelectedRowCount() != 1;
                        ImageVersionDetails selectedVersion = (ImageVersionDetails)ImageDetailsWindow.this.tblVersions.getSelectedItem();
                        ImageDetailsWindow.this.mnuNewLecture.setEnabled(!multiSelection && selectedVersion.isValid && ImagePerms.canLink(ImageDetailsWindow.this.image));
                        ImageDetailsWindow.this.mnuDownload.setEnabled(!multiSelection && ImagePerms.canDownload(ImageDetailsWindow.this.image));
                        ImageDetailsWindow.this.mnuVmConfig.setEnabled(!multiSelection && selectedVersion.isValid && ImagePerms.canEdit(ImageDetailsWindow.this.image) && (((ImageDetailsWindow)ImageDetailsWindow.this).image.shareMode == ShareMode.LOCAL || ((ImageDetailsWindow)ImageDetailsWindow.this).image.shareMode == ShareMode.PUBLISH));
                        ImageDetailsWindow.this.mnuDelete.setEnabled(ImagePerms.canEdit(ImageDetailsWindow.this.image));
                        ImageDetailsWindow.this.mnuExtendExpiryDate.setEnabled(!multiSelection && (selectedVersion.isValid || Session.hasFeature(Feature.EXTEND_EXPIRED_VM)));
                        pop.show(e.getComponent(), e.getX(), e.getY());
                    }
                }
            }
        };
        this.scpVersions.addMouseListener(ma);
        this.tblVersions.addMouseListener(ma);
        this.changeMonitor.add(this.txtTitle).addConstraint(new DialogChangeMonitor.TextNotEmptyConstraint("Name darf nicht leer sein"));
        this.changeMonitor.add(this.txtDescription).addConstraint(new DialogChangeMonitor.TextNotEmptyConstraint("Beschreibung darf nicht leer sein"));
        this.changeMonitor.add(this.txtTags);
        this.changeMonitor.addFixedCombo(this.cboOperatingSystem, Comparators.operatingSystem).addConstraint(new DialogChangeMonitor.ValidationConstraint<OperatingSystem>(){

            @Override
            public String checkStateValid(OperatingSystem userInput) {
                if (userInput != null && MetaDataCache.getOsById(userInput.osId) != null) {
                    return null;
                }
                return "Ung\u00fcltiges Betriebssystem ausgew\u00e4hlt!";
            }
        });
        this.changeMonitor.addFixedCombo(this.cboShareMode, null).addConstraint(new DialogChangeMonitor.ValidationConstraint<ShareMode>(){

            @Override
            public String checkStateValid(ShareMode userInput) {
                if (userInput != null) {
                    return null;
                }
                return "Ung\u00fcltiges Betriebssystem ausgew\u00e4hlt!";
            }
        });
        this.changeMonitor.add(this.chkIsTemplate);
        this.changeMonitor.add(this.chkDefaultPermLink);
        this.changeMonitor.add(this.chkDefaultPermDownload);
        this.changeMonitor.add(this.chkDefaultPermEdit);
        this.changeMonitor.add(this.chkDefaultPermAdmin);
        this.changeListenerPermissions = this.changeMonitor.add(this.ctlImagePermissionConfigurator);
        ItemListener updateDefaultPermissionsListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getSource() == ImageDetailsWindow.this.chkDefaultPermLink) {
                    ((ImageDetailsWindow)ImageDetailsWindow.this).image.defaultPermissions.link = ImageDetailsWindow.this.chkDefaultPermLink.isSelected();
                }
                if (e.getSource() == ImageDetailsWindow.this.chkDefaultPermDownload) {
                    ((ImageDetailsWindow)ImageDetailsWindow.this).image.defaultPermissions.download = ImageDetailsWindow.this.chkDefaultPermDownload.isSelected();
                }
                if (e.getSource() == ImageDetailsWindow.this.chkDefaultPermEdit) {
                    ((ImageDetailsWindow)ImageDetailsWindow.this).image.defaultPermissions.edit = ImageDetailsWindow.this.chkDefaultPermEdit.isSelected();
                }
                if (e.getSource() == ImageDetailsWindow.this.chkDefaultPermAdmin) {
                    ((ImageDetailsWindow)ImageDetailsWindow.this).image.defaultPermissions.admin = ImageDetailsWindow.this.chkDefaultPermAdmin.isSelected();
                }
            }
        };
        this.chkDefaultPermLink.addItemListener(updateDefaultPermissionsListener);
        this.chkDefaultPermDownload.addItemListener(updateDefaultPermissionsListener);
        this.chkDefaultPermEdit.addItemListener(updateDefaultPermissionsListener);
        this.chkDefaultPermAdmin.addItemListener(updateDefaultPermissionsListener);
        this.setFocusable(true);
        this.btnSaveChanges.setEnabled(false);
        this.txtVersion.setEditable(false);
        this.txtId.setEditable(false);
        this.chkIsTemplate.setEnabled(Session.isSuperUser());
        this.btnUploadToMaster.setVisible(actionHandler.isImagePublishSupported());
        this.makeEditable(false);
        this.cboShareMode.setEnabled(false);
    }

    private void editVmConfig(final ImageVersionDetails selected) {
        QuickTimer.scheduleOnce(new QuickTimer.Task(){
            ByteBuffer machineDescription = null;

            @Override
            public void fire() {
                try {
                    this.machineDescription = ThriftManager.getSatClient().getImageVersionVirtConfig(Session.getSatelliteToken(), selected.versionId);
                }
                catch (TException e) {
                    LOGGER.error("Failed to retrieve virtualizer config for image version '" + ((ImageDetailsWindow)ImageDetailsWindow.this).image.latestVersionId + ", see trace: ", e);
                    return;
                }
                Gui.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (machineDescription == null) {
                            Gui.showMessageBox("Konnte VM-Konfiguration nicht abrufen.", MessageType.ERROR, LOGGER, null);
                            return;
                        }
                        String tmp = ThriftUtil.byteBufferToString(machineDescription);
                        if ("qemukvm".equals(((ImageDetailsWindow)ImageDetailsWindow.this).image.virtId)) {
                            VirtConfigEditorWindow.open(ImageDetailsWindow.this.me, ImageDetailsWindow.this.actionHandler, selected.versionId, ThriftUtil.byteBufferToString(machineDescription), tmp);
                        } else {
                            VirtDropDownConfigEditorWindow.open(ImageDetailsWindow.this.me, ImageDetailsWindow.this.actionHandler, selected.versionId, machineDescription);
                        }
                    }
                });
            }
        });
    }

    public void setImage(String imageBaseId) {
        MetaDataCache.getOperatingSystems();
        MetaDataCache.getVirtualizers();
        ThriftActions.ImageMetaCallback callback = new ThriftActions.ImageMetaCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void fetchedImageDetails(ImageDetailsRead imageDetails, Map<String, ImagePermissions> permissions) {
                if (imageDetails == null) {
                    return;
                }
                if (permissions == null) {
                    permissions = new HashMap<String, ImagePermissions>();
                }
                ImageDetailsWindow imageDetailsWindow = ImageDetailsWindow.this.me;
                synchronized (imageDetailsWindow) {
                    ImageDetailsWindow.this.image = imageDetails;
                    ImageDetailsWindow.this.customPermissions = permissions;
                }
                ImageDetailsWindow.this.fillDetails();
            }
        };
        this.actionHandler.getImageDetails(imageBaseId, callback);
    }

    private void setImageOwner(UserInfo user) {
        if (!this.actionHandler.setImageOwner(this.image.getImageBaseId(), user)) {
            return;
        }
        Gui.showMessageBox(this.me, "Besitzrechte \u00fcbertragen an " + FormatHelper.userName(user), MessageType.INFO, null, null);
        this.makeEditable(false);
        this.refresh(true);
    }

    private void uploadToMaster() {
        if (Session.hasFeature(Feature.MULTIPLE_HYPERVISORS) && !"vmware".equals(this.image.virtId)) {
            Gui.showMessageBox(MetaDataCache.getVirtualizerById((String)this.image.virtId).virtName + " ist derzeit nicht f\u00fcr den \u00f6ffentlichen Austausch freigegeben.", MessageType.ERROR, null, null);
            return;
        }
        if (this.changeMonitor.isCurrentlyModified() && Gui.showMessageBox("Sie haben unspeicherte \u00c4nderungen, wollen Sie diese erst speichern?", MessageType.QUESTION_YESNO, null, null) && !this.saveChangesInternal()) {
            return;
        }
        if (!Gui.showMessageBox("Wollen Sie diese VM wirklich landesweit ver\u00f6ffentlichen?", MessageType.QUESTION_YESNO, null, null)) {
            return;
        }
        QuickTimer.scheduleOnce(new QuickTimer.Task(){

            @Override
            public void fire() {
                String transferId;
                try {
                    transferId = ThriftManager.getSatClient().publishImageVersion(Session.getSatelliteToken(), ((ImageDetailsWindow)ImageDetailsWindow.this).image.latestVersionId);
                }
                catch (TException e1) {
                    ThriftError.showMessage(ImageDetailsWindow.this.me, LOGGER, e1, "Upload der VM auf den Masterserver fehlgeschlagen. Pr\u00fcfen Sie, ob Sie bei der Registrierung dem landesweiten VM-Austausch zugestimmt haben.\n Sie k\u00f6nnen dies hier \u00fcberpr\u00fcfen:\n" + DesktopEnvironment.Link.REGISTER_BWIDM.uri.toString() + "\n\n");
                    return;
                }
                Gui.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        MainWindow.addPassiveTransfer(transferId, ((ImageDetailsWindow)ImageDetailsWindow.this).image.imageName, true);
                        Gui.showMessageBox(ImageDetailsWindow.this, "Die \u00dcbertragung l\u00e4uft direkt zwischen Satellitenserver und dem " + Branding.getServiceName() + " Zentral-Server.\nWenn Sie die " + Branding.getApplicationName() + " schlie\u00dfen, wird der Transfer trotzdemweiterlaufen.", MessageType.INFO, null, null);
                    }
                });
            }
        });
    }

    private void saveChanges() {
        boolean saved = this.saveChangesInternal();
        if (saved) {
            if (this.callback != null) {
                this.callback.updated();
            }
            this.dispose();
        } else {
            this.btnSaveChanges.setEnabled(true);
        }
    }

    private boolean saveChangesInternal() {
        if (this.adminRightsFromDefaultPermissions && this.changeListenerPermissions.isCurrentlyChanged()) {
            if (!this.saveCustomPermissions()) {
                return false;
            }
            this.changeListenerPermissions.reset();
        }
        ImageBaseWrite ibw = new ImageBaseWrite(this.txtTitle.getText(), this.txtDescription.getText(), ((OperatingSystem)this.cboOperatingSystem.getItemAt((int)this.cboOperatingSystem.getSelectedIndex())).osId, this.image.virtId, this.chkIsTemplate.isSelected(), new ImagePermissions(this.image.defaultPermissions.link, this.image.defaultPermissions.download, this.image.defaultPermissions.edit, this.image.defaultPermissions.admin), (ShareMode)this.cboShareMode.getItemAt(this.cboShareMode.getSelectedIndex()));
        try {
            this.actionHandler.updateImageBase(this.image.getImageBaseId(), ibw);
            LOGGER.info("Successfully saved new metadata");
        }
        catch (TException e) {
            ThriftError.showMessage(this.me, LOGGER, e, "Konnte aktualisierte Metadaten nicht an den Server \u00fcbermitteln");
            return false;
        }
        if (this.changeListenerPermissions.isCurrentlyChanged() && !this.saveCustomPermissions()) {
            return false;
        }
        this.changeMonitor.reset();
        return true;
    }

    private boolean saveCustomPermissions() {
        try {
            this.actionHandler.writeImagePermissions(this.image.getImageBaseId(), this.ctlImagePermissionConfigurator.getPermissions());
            LOGGER.info("Successfully saved new custom permissions");
        }
        catch (TException e) {
            ThriftError.showMessage(this.me, LOGGER, e, "Konnte ge\u00e4nderte Berechtigungen nicht an den Server \u00fcbermitteln");
            return false;
        }
        return true;
    }

    private void performImageDownload(ImageVersionDetails selected) {
        if (selected.getVersionId() == null) {
            Gui.showMessageBox(this, "Ausgew\u00e4hlte Version ist ung\u00fcltig", MessageType.ERROR, null, null);
            return;
        }
        ThriftActions.initDownload(JOptionPane.getFrameForComponent(this), selected.versionId, this.image.imageName, this.image.virtId, this.image.osId, selected.fileSize, null);
    }

    private void deleteVersion(ImageVersionDetails version) {
        if (version == null) {
            return;
        }
        this.actionHandler.deleteImageVersion(version, new ThriftActions.DeleteCallback(){

            @Override
            public void isDeleted(boolean success) {
                ImageDetailsWindow.this.refresh(success);
            }
        });
    }

    private void deleteVersions(List<ImageVersionDetails> versions) {
        if (versions == null || versions.isEmpty()) {
            return;
        }
        for (ImageVersionDetails version : versions) {
            this.deleteVersion(version);
        }
    }

    private void extendVersionExpiry(List<ImageVersionDetails> versions) {
        int daysToExtend = -1;
        if (versions.size() > 1 && (daysToExtend = ExpiryDateChooser.askFutureExpiryDuration(this, null)) == -1) {
            return;
        }
        int count = 0;
        for (ImageVersionDetails img : versions) {
            long currentExpiryTime = img.expireTime < Util.unixTime() ? Util.unixTime() : img.expireTime;
            Date currentExpiryTimeAsDate = DateTimeHelper.endOfDay(new Date(currentExpiryTime * 1000L));
            if (daysToExtend == -1 && (daysToExtend = ExpiryDateChooser.askFutureExpiryDuration(this, currentExpiryTimeAsDate)) == -1) {
                return;
            }
            currentExpiryTimeAsDate = DateTimeHelper.addDaysTo(currentExpiryTimeAsDate, daysToExtend);
            try {
                ThriftManager.getSatClient().setImageVersionExpiry(Session.getSatelliteToken(), img.versionId, currentExpiryTimeAsDate.getTime() / 1000L);
                ++count;
            }
            catch (TException e) {
                ThriftError.showMessage(this, LOGGER, e, "Konnte Ablaufdatum der Version " + img.versionId + " nicht verl\u00e4ngern.");
            }
        }
        if (count > 0) {
            Gui.showMessageBox(this, "Erfolgreich verl\u00e4ngerte Abbilder: " + count, MessageType.INFO, null, null);
            this.refresh(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refresh(boolean forceRefresh) {
        String baseId = this.image.getImageBaseId();
        ImageDetailsWindow imageDetailsWindow = this.me;
        synchronized (imageDetailsWindow) {
            this.image = null;
        }
        this.setImage(baseId);
    }

    private void fillDetails() {
        Virtualizer virt;
        if (this.image == null) {
            return;
        }
        this.txtTitle.setText(this.image.getImageName());
        this.txtTitle.setCaretPosition(0);
        this.txtDescription.setText(this.image.getDescription());
        this.lblOwner.setUser(UserCache.find(this.image.getOwnerId()));
        this.lblUpdater.setUser(UserCache.find(this.image.getUpdaterId()));
        this.lblCreateTime.setText(FormatHelper.longDate(this.image.getCreateTime()));
        this.lblUpdateTime.setText(FormatHelper.longDate(this.image.getUpdateTime()));
        this.txtVersion.setText(this.image.getLatestVersionId());
        this.txtId.setText(this.image.getImageBaseId());
        this.chkIsTemplate.setSelected(this.image.isTemplate);
        this.setTitle(this.image.getImageName());
        if (this.cboOperatingSystem.getItemCount() == 0) {
            List<OperatingSystem> osList = MetaDataCache.getOperatingSystems();
            Collections.sort(osList, new Comparator<OperatingSystem>(){

                @Override
                public int compare(OperatingSystem o1, OperatingSystem o2) {
                    return o1.getOsName().compareTo(o2.getOsName());
                }
            });
            for (OperatingSystem os : osList) {
                this.cboOperatingSystem.addItem(os);
            }
            this.cboOperatingSystem.setSelectedItem(new OperatingSystem(this.image.getOsId(), null, null, null, 0, 0));
        }
        if ((virt = MetaDataCache.getVirtualizerById(this.image.getVirtId(), true)) != null) {
            this.lblVirtualizer.setText(virt.getVirtName());
        }
        if (this.cboShareMode.getItemCount() == 0) {
            for (ShareMode mode : ShareMode.values()) {
                this.cboShareMode.addItem(mode);
            }
        }
        this.cboShareMode.setSelectedItem(this.image.getShareMode());
        String tagsString = "";
        if (this.image.getTags() != null) {
            for (String tag : this.image.getTags()) {
                tagsString = tagsString + ", " + tag;
            }
        }
        this.txtTags.setText(tagsString);
        this.adminRightsFromDefaultPermissions = this.image.defaultPermissions.admin;
        this.ctlImagePermissionConfigurator.initPanel(this.customPermissions, this.image.defaultPermissions, this.image.ownerId);
        this.chkDefaultPermAdmin.setSelected(this.image.defaultPermissions.admin);
        this.chkDefaultPermEdit.setSelected(this.image.defaultPermissions.edit);
        this.chkDefaultPermDownload.setSelected(this.image.defaultPermissions.download);
        this.chkDefaultPermLink.setSelected(this.image.defaultPermissions.link);
        int lectureCount = 0;
        for (LectureSummary lecture : LectureCache.get(false)) {
            if (lecture == null || lecture.imageBaseId == null || !lecture.imageBaseId.equals(this.image.imageBaseId)) continue;
            ++lectureCount;
        }
        this.lblLinkedLectureCount.setText(Integer.toString(lectureCount));
        this.lblLinkedLectureCount.setForeground(lectureCount > 0 ? null : Color.RED);
        this.btnShowLinkingLectures.setEnabled(lectureCount > 0);
        this.tblVersions.setData(this.image.getVersions(), true);
        this.makeEditable(true);
        this.changeMonitor.reset();
        this.setVisible(true);
    }

    private void makeEditable(boolean editable) {
        if (this.image != null) {
            editable &= this.image.shareMode == ShareMode.LOCAL || this.image.shareMode == ShareMode.PUBLISH;
        }
        editable = editable && (ImagePerms.canEdit(this.image) || ImagePerms.canAdmin(this.image));
        this.txtTitle.setEditable(editable);
        this.txtDescription.setEditable(editable);
        this.txtTags.setEditable(editable);
        this.cboOperatingSystem.setEnabled(editable);
        this.btnChangeOwner.setEnabled(editable && ImagePerms.canAdmin(this.image));
        this.btnUpdateImage.setEnabled(editable);
        if (this.actionHandler.isImagePublishSupported()) {
            this.btnUploadToMaster.setEnabled(editable);
        }
    }

    public static void open(Frame modalParent, String imageBaseId, ImageUpdatedCallback callback, ImageDetailsActions actionHandler) {
        ImageDetailsWindow win = new ImageDetailsWindow(modalParent, callback, actionHandler);
        win.setImage(imageBaseId);
        win.setVisible(true);
    }

    @Override
    public void show() {
        if (!this.isVisible()) {
            this.pack();
            MainWindow.centerShell(this);
        }
        super.show();
    }

    @Override
    public boolean wantConfirmQuit() {
        return this.changeMonitor.isCurrentlyModified();
    }

    @Override
    public void escapePressed() {
        this.safeClose();
    }

    private boolean safeClose() {
        if (this.changeMonitor.isCurrentlyModified() && !Gui.showMessageBox(this.me, "\u00c4nderungen werden verworfen, wollen Sie wirklich schlie\u00dfen?", MessageType.QUESTION_YESNO, null, null)) {
            return false;
        }
        this.dispose();
        return true;
    }

    public static interface ImageUpdatedCallback {
        public void updated();
    }
}

