/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.gui.helper;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.JPanel;

public class GridManager {
    public static boolean debugEmptyCells = true;
    private final Container container;
    private final Insets defaultInsets;
    private final int columnCount;
    private final boolean strict;
    private int nextColumn = 0;
    private int currentRow = 0;
    private boolean valid = true;
    private final ArrayList<Component[]> currentRows = new ArrayList();
    private GBC currentGbc = null;
    private static final GridBagConstraints emptyFiller = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 1, new Insets(0, 0, 0, 0), 0, 0);

    public GridManager(Container container, int columnCount) {
        this(container, columnCount, true);
    }

    public GridManager(Container container, int columnCount, boolean strict) {
        this(container, columnCount, strict, new Insets(1, 1, 1, 1));
    }

    public GridManager(Container container, int columnCount, boolean strict, Insets defaultInsets) {
        this.defaultInsets = defaultInsets;
        this.container = container;
        this.columnCount = columnCount;
        this.strict = strict;
        this.container.setLayout(new GridBagLayout());
        this.currentRows.add(new Component[columnCount]);
    }

    public GBC add(Component component) {
        return this.add(component, 1, 1);
    }

    public GBC add(Component component, int spanX) {
        return this.add(component, spanX, 1);
    }

    public GBC add(Component component, int spanX, int spanY) {
        this.checkValid();
        if (spanX < 1 || spanY < 1) {
            throw new IllegalArgumentException("Span must be >= 1");
        }
        if (!this.strict && this.nextColumn == this.columnCount) {
            this.nextRow();
        }
        if (!this.hasFreeColumns(spanX)) {
            throw new IllegalArgumentException("Cannot add component: Not enough columns left in row");
        }
        this.addCurrentControl();
        this.currentGbc = new GBC(component, spanX, spanY);
        this.nextColumn += spanX;
        this.skipToFreeColumn();
        return this.currentGbc;
    }

    public GBC skip() {
        return this.add(Box.createGlue());
    }

    public GBC skip(int spanX) {
        return this.add(Box.createGlue(), spanX);
    }

    public GBC skip(int spanX, int spanY) {
        return this.add(Box.createGlue(), spanX, spanY);
    }

    public void nextRow() {
        int i;
        Component[] row;
        this.checkValid();
        if (this.nextColumn == 0 && this.currentRows.size() == 1 && this.allCellsEmpty()) {
            if (this.strict) {
                throw new IllegalStateException("Cannot call nextRow when current row is empty");
            }
            return;
        }
        this.addCurrentControl();
        if (this.nextColumn < this.columnCount && debugEmptyCells) {
            GridManager.emptyFiller.gridy = this.currentRow;
            row = this.currentRows.get(0);
            for (i = this.nextColumn; i < this.columnCount; ++i) {
                if (row[i] != null) continue;
                JPanel p = new JPanel();
                p.setBackground(Color.GREEN);
                GridManager.emptyFiller.gridx = i;
                this.container.add((Component)p, emptyFiller);
            }
        }
        ++this.currentRow;
        if (this.currentRows.size() == 1) {
            row = this.currentRows.get(0);
            for (i = 0; i < this.columnCount; ++i) {
                row[i] = null;
            }
        } else {
            this.currentRows.remove(0);
        }
        this.nextColumn = 0;
        this.skipToFreeColumn();
    }

    public void finish(boolean addVerticalGlue) {
        this.checkValid();
        if (this.nextColumn != 0) {
            this.nextRow();
        }
        if (addVerticalGlue) {
            while (this.currentRows.size() > 1 || !this.allCellsEmpty()) {
                this.nextRow();
            }
            this.add(Box.createGlue(), this.columnCount, 1).expand(true, true).fill(true, true);
            this.nextRow();
        }
        this.valid = false;
    }

    private boolean hasFreeColumns(int num) {
        --num;
        Component[] row = this.currentRows.get(0);
        for (int i = this.nextColumn; i < this.columnCount; ++i) {
            if (row[i] != null) {
                return false;
            }
            if (i - this.nextColumn < num) continue;
            return true;
        }
        return false;
    }

    private void addCurrentControl() {
        if (this.currentGbc == null) {
            return;
        }
        this.container.add(this.currentGbc.component, this.currentGbc);
        for (int relrow = 0; relrow < this.currentGbc.gridheight; ++relrow) {
            if (this.currentRows.size() <= relrow) {
                this.currentRows.add(new Component[this.columnCount]);
            }
            Component[] row = this.currentRows.get(relrow);
            for (int relcol = 0; relcol < this.currentGbc.gridwidth; ++relcol) {
                if (row[relcol + this.currentGbc.gridx] != null) {
                    throw new IllegalStateException("Collision detected in cell (" + (relcol + this.currentGbc.gridx) + "|" + (relrow + this.currentGbc.gridy) + "): Have " + row[relcol + this.currentGbc.gridx].getClass().getSimpleName() + ", trying to add " + this.currentGbc.component.getClass().getSimpleName());
                }
                row[relcol + this.currentGbc.gridx] = this.currentGbc.component;
            }
        }
        this.currentGbc.valid = false;
        this.currentGbc = null;
    }

    private boolean allCellsEmpty() {
        Component[] row = this.currentRows.get(0);
        for (int i = 0; i < this.columnCount; ++i) {
            if (row[i] == null) continue;
            return false;
        }
        return true;
    }

    private void checkValid() {
        if (!this.valid) {
            throw new IllegalStateException("Layout is already finalized!");
        }
    }

    private void skipToFreeColumn() {
        Component[] row = this.currentRows.get(0);
        while (this.nextColumn < this.columnCount && row[this.nextColumn] != null) {
            ++this.nextColumn;
        }
    }

    public class GBC
    extends GridBagConstraints {
        private boolean valid = true;
        private final Component component;

        public GBC fill(boolean fillX, boolean fillY) {
            this.checkValid();
            this.fill = fillX && fillY ? 1 : (fillX ? 2 : (fillY ? 3 : 0));
            return this;
        }

        public GBC expand(boolean expandX, boolean expandY) {
            return this.expand(expandX ? 1.0 : 0.0, expandY ? 1.0 : 0.0);
        }

        public GBC expand(double expandX, double expandY) {
            this.checkValid();
            this.weightx = expandX;
            this.weighty = expandY;
            return this;
        }

        public GBC anchor(int value) {
            this.checkValid();
            this.anchor = value;
            return this;
        }

        public GBC insets(Insets insets) {
            this.checkValid();
            this.insets = insets;
            return this;
        }

        private GBC(Component component, int spanX, int spanY) {
            this.gridx = GridManager.this.nextColumn;
            this.gridy = GridManager.this.currentRow;
            this.gridwidth = spanX;
            this.gridheight = spanY;
            this.weightx = 0.0;
            this.weighty = 0.0;
            this.anchor = 21;
            this.fill = 0;
            this.insets = GridManager.this.defaultInsets;
            this.ipadx = 0;
            this.ipady = 0;
            this.component = component;
        }

        private void checkValid() {
            if (!this.valid) {
                throw new IllegalAccessError("Cannot modify constraints after adding next control");
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("{ ");
            for (Field f : this.getClass().getFields()) {
                String val;
                if (Modifier.isFinal(f.getModifiers()) || Modifier.isStatic(f.getModifiers())) continue;
                try {
                    val = f.get(this).toString();
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    val = "???";
                }
                sb.append(f.getName());
                sb.append('=');
                sb.append(val);
                sb.append(' ');
            }
            sb.append('}');
            return sb.toString();
        }
    }
}

