/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.gui.helper;

import java.util.Calendar;
import java.util.Date;
import javax.swing.JSpinner;
import org.apache.log4j.Logger;
import org.jdatepicker.JDatePicker;

public class DateTimeHelper {
    private static final Logger LOGGER = Logger.getLogger(DateTimeHelper.class);

    public static Date getDateFrom(JDatePicker datePicker, JSpinner timeSpinner) {
        int years = datePicker.getModel().getYear();
        int months = datePicker.getModel().getMonth();
        int days = datePicker.getModel().getDay();
        Object oTime = timeSpinner.getValue();
        if (!(oTime instanceof Date) || years < 1000) {
            return null;
        }
        Date time = (Date)oTime;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(time);
        int hours = calendar.get(11);
        int minutes = calendar.get(12);
        calendar.set(years, months, days, hours, minutes);
        Date date = calendar.getTime();
        return date;
    }

    public static Date addDaysTo(Date start, int days) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(start);
        calendar.add(5, days);
        return calendar.getTime();
    }

    public static int calculatePeriodInDays(Date start, Date end) {
        if (end.before(start)) {
            return 0;
        }
        return Math.round((float)(end.getTime() - start.getTime()) / 8.64E7f);
    }

    public static Date endOfDay(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        return cal.getTime();
    }
}

