/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.gui.control.table;

import org.openslx.bwlp.thrift.iface.NetShare;
import org.openslx.bwlp.thrift.iface.NetShareAuth;
import org.openslx.dozmod.gui.configurator.NetshareConfigurator;
import org.openslx.dozmod.gui.control.table.CheckListTable;
import org.openslx.dozmod.gui.control.table.ListTable;
import org.openslx.dozmod.thrift.Sorters;
import org.openslx.dozmod.util.FormatHelper;

public class NetshareTable
extends CheckListTable<NetShare> {
    public static final ListTable.ListTableColumn COL_NAME = new ListTable.ListTableColumn("Name");
    public static final ListTable.ListTableColumn COL_MOUNT = new ListTable.ListTableColumn("Ziel");
    public static final ListTable.ListTableColumn COL_PATH = new ListTable.ListTableColumn("Pfad");
    public static final ListTable.ListTableColumn COL_AUTH = new ListTable.ListTableColumn("Authentifizierung", Sorters.netShareAuth);
    public static final ListTable.ListTableColumn COL_USER = new ListTable.ListTableColumn("Username");
    public static final ListTable.ListTableColumn COL_PASSWORD = new ListTable.ListTableColumn("Passwort");

    public NetshareTable() {
        super(COL_NAME, COL_PATH, COL_MOUNT, COL_AUTH, COL_USER, COL_PASSWORD);
    }

    @Override
    protected Object getValueAtInternal2(NetShare item, ListTable.ListTableColumn columnIndex) {
        if (columnIndex == COL_NAME) {
            return item.displayname;
        }
        if (columnIndex == COL_MOUNT) {
            return item.mountpoint;
        }
        if (columnIndex == COL_PATH) {
            return item.path;
        }
        if (columnIndex == COL_AUTH) {
            return item.auth;
        }
        if (columnIndex == COL_USER) {
            return item.username;
        }
        if (columnIndex == COL_PASSWORD) {
            return item.password;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public Object modelValueToDisplayFormat(Object object, ListTable.ListTableColumn column) {
        if (column == COL_NAME) {
            return (String)object;
        }
        if (column == COL_MOUNT) {
            String input = (String)object;
            if (input.isEmpty()) {
                return String.valueOf(NetshareConfigurator.EMPTY_MARKER);
            }
            if (!input.equals(String.valueOf(NetshareConfigurator.EMPTY_MARKER)) && !input.equals("PRINTER")) {
                input = input + ":";
            }
            return input;
        }
        if (column == COL_PATH) {
            return (String)object;
        }
        if (column == COL_AUTH) {
            return FormatHelper.netShareAuthName((NetShareAuth)object);
        }
        if (column == COL_USER) {
            return (String)object;
        }
        if (column == COL_PASSWORD) {
            String pass = (String)object;
            return pass != null ? pass.replaceAll(".", "*") : "";
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    protected boolean isItemCheckable(NetShare item) {
        return item.shareId > 0;
    }
}

