/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.gui.control.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.UIManager;
import org.openslx.bwlp.thrift.iface.LectureSummary;
import org.openslx.dozmod.gui.control.table.ListTable;
import org.openslx.dozmod.gui.helper.ColorUtil;
import org.openslx.dozmod.thrift.Session;
import org.openslx.dozmod.thrift.Sorters;
import org.openslx.dozmod.thrift.cache.UserCache;
import org.openslx.dozmod.util.FormatHelper;

public class LectureTable
extends ListTable<LectureSummary> {
    public static final ListTable.ListTableColumn COL_NAME = new ListTable.ListTableColumn("Name");
    public static final ListTable.ListTableColumn COL_OWNER = new ListTable.ListTableColumn("Besitzer", Sorters.userNameById);
    public static final ListTable.ListTableColumn COL_STARTTIME = new ListTable.ListTableColumn("Startdatum", Long.class);
    public static final ListTable.ListTableColumn COL_ENDTIME = new ListTable.ListTableColumn("Ablaufdatum", Long.class);
    public static final ListTable.ListTableColumn COL_ENABLED = new ListTable.ListTableColumn("Aktiviert", Boolean.class);
    public static final ListTable.ListTableColumn COL_VALID = new ListTable.ListTableColumn("VM g\u00fcltig", Boolean.class);
    private final Font boldFont = this.getFont().deriveFont(1);
    private final Color invalidColor;
    private boolean highlightOwn = false;

    public LectureTable() {
        super(COL_NAME, COL_OWNER, COL_STARTTIME, COL_ENDTIME, COL_ENABLED, COL_VALID);
        Color fg = UIManager.getColor("Table.foreground");
        Color bg = UIManager.getColor("Table.background");
        this.invalidColor = ColorUtil.blend(fg, bg, 0.66f);
    }

    @Override
    protected Object getValueAtInternal(LectureSummary row, ListTable.ListTableColumn columnIndex) {
        if (columnIndex == COL_NAME) {
            return row.getLectureName();
        }
        if (columnIndex == COL_OWNER) {
            return row.getOwnerId();
        }
        if (columnIndex == COL_STARTTIME) {
            return row.getStartTime();
        }
        if (columnIndex == COL_ENDTIME) {
            return row.getEndTime();
        }
        if (columnIndex == COL_ENABLED) {
            return row.isIsEnabled();
        }
        if (columnIndex == COL_VALID) {
            return row.isIsImageVersionUsable();
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public Component prepareRenderHook(Component component, LectureSummary row, ListTable.ListTableColumn column, boolean isSelected) {
        boolean dateInvalid;
        Color fgOverride = null;
        if (this.highlightOwn && column == COL_OWNER && Session.getUserId().equals(row.ownerId)) {
            component.setFont(this.boldFont);
        }
        long now = System.currentTimeMillis() / 1000L;
        boolean bl = dateInvalid = column == COL_STARTTIME && row.startTime > now || column == COL_ENDTIME && row.endTime < now;
        if ((column == COL_STARTTIME || column == COL_ENDTIME) && dateInvalid) {
            fgOverride = Color.RED;
        }
        if (fgOverride == null) {
            if (dateInvalid || !row.isImageVersionUsable) {
                component.setForeground(this.invalidColor);
            } else {
                component.setForeground(isSelected ? this.getSelectionForeground() : this.getForeground());
            }
        } else {
            component.setForeground(Color.RED);
        }
        return component;
    }

    @Override
    public Object modelValueToDisplayFormat(Object value, ListTable.ListTableColumn column) {
        if (column == COL_NAME || column == COL_ENABLED || column == COL_VALID) {
            return value;
        }
        if (column == COL_OWNER) {
            return FormatHelper.userName(UserCache.find((String)value));
        }
        if (column == COL_STARTTIME || column == COL_ENDTIME) {
            return FormatHelper.shortDate((Long)value);
        }
        throw new IndexOutOfBoundsException();
    }

    public void setHighlightOwn(boolean enabled) {
        this.highlightOwn = enabled;
    }
}

