/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.gui.configurator;

import java.awt.Color;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.openslx.bwlp.thrift.iface.NetShareAuth;
import org.openslx.dozmod.gui.configurator.NetshareConfigurator;
import org.openslx.dozmod.gui.control.ComboBox;
import org.openslx.dozmod.gui.control.QLabel;
import org.openslx.dozmod.gui.control.table.NetshareTable;
import org.openslx.dozmod.gui.control.table.QScrollPane;
import org.openslx.dozmod.gui.helper.GridManager;
import org.openslx.dozmod.util.FormatHelper;

class NetshareConfiguratorLayout
extends JPanel {
    private static final long serialVersionUID = 6479525981542743622L;
    private static final String txtNetshareDesc = "<html>Hier k\u00f6nnen Sie Netzlaufwerke angeben, die automatisch beim Start der Veranstaltung eingebunden werden sollen. Der Platzhalter <em>%loginuser%</em> wird im Pfad durch den Loginnamen des Nutzers ersetzt.</html>";
    protected final JLabel lblError;
    protected final NetshareTable tblNetshare = new NetshareTable();
    protected final JTextField tfSharePath;
    protected final JTextField tfShareName;
    protected final JTextField tfUsername;
    protected final JPasswordField tfPassword;
    protected final JButton btnAdd;
    protected final JButton btnDel;
    protected final JCheckBox chkIsPrinter;
    protected final JCheckBox chkShowPass;
    protected final ComboBox<NetShareAuth> cboNetshareAuth = new ComboBox<NetShareAuth>(new ComboBox.ComboBoxRenderer<NetShareAuth>(){

        @Override
        public String renderItem(NetShareAuth item) {
            if (item == null) {
                return null;
            }
            return FormatHelper.netShareAuthName(item);
        }
    });
    protected final ComboBox<Character> cboNetshareMountPoint = new ComboBox<Character>(new ComboBox.ComboBoxRenderer<Character>(){

        @Override
        public String renderItem(Character letter) {
            if (letter == null) {
                return null;
            }
            return letter.equals(NetshareConfigurator.EMPTY_MARKER) ? letter.toString() : letter.toString() + ":";
        }
    });

    public NetshareConfiguratorLayout() {
        GridManager grid = new GridManager(this, 3, true, new Insets(3, 3, 3, 3));
        grid.add(new JLabel(txtNetshareDesc), 3).fill(true, false).expand(true, false);
        grid.nextRow();
        grid.add(new QScrollPane(this.tblNetshare), 3).fill(true, true).expand(true, true);
        grid.nextRow();
        JPanel pnlNewShare = new JPanel();
        GridManager gridNewShare = new GridManager(pnlNewShare, 6, true, new Insets(0, 3, 0, 3));
        pnlNewShare.setBorder(BorderFactory.createTitledBorder("Eigenes Netzlaufwerk definieren"));
        JPanel pnlSharePath = new JPanel();
        pnlSharePath.setLayout(new BoxLayout(pnlSharePath, 2));
        gridNewShare.add(new QLabel("Pfad"));
        this.tfSharePath = new JTextField();
        pnlSharePath.add(this.tfSharePath);
        pnlSharePath.add(Box.createGlue());
        pnlSharePath.add(Box.createHorizontalStrut(5));
        this.chkIsPrinter = new JCheckBox("Drucker");
        pnlSharePath.add(this.chkIsPrinter);
        pnlSharePath.add(Box.createHorizontalStrut(5));
        gridNewShare.add(pnlSharePath, 5).fill(true, false).expand(true, false);
        gridNewShare.nextRow();
        this.tfShareName = new JTextField();
        JPanel pnlShareName = new JPanel();
        pnlShareName.setLayout(new BoxLayout(pnlShareName, 2));
        pnlShareName.add(this.tfShareName);
        pnlShareName.add(Box.createHorizontalStrut(3));
        pnlShareName.add(new QLabel("Laufwerk"));
        pnlShareName.add(Box.createHorizontalStrut(3));
        pnlShareName.add(this.cboNetshareMountPoint);
        gridNewShare.add(new QLabel("Anzeigename"));
        gridNewShare.add(pnlShareName, 5).fill(true, false).expand(true, false);
        gridNewShare.nextRow();
        gridNewShare.add(new QLabel("Authentifizierung"));
        gridNewShare.add(this.cboNetshareAuth, 5).fill(true, false).expand(true, false);
        gridNewShare.nextRow();
        gridNewShare.add(new QLabel("Benutzername"));
        this.tfUsername = new JTextField(20);
        gridNewShare.add(this.tfUsername, 2).fill(true, false).expand(true, false);
        gridNewShare.add(new QLabel("Passwort"));
        this.tfPassword = new JPasswordField(20);
        gridNewShare.add(this.tfPassword, 2).fill(true, false).expand(true, false);
        gridNewShare.nextRow();
        this.chkShowPass = new JCheckBox("Passwort anzeigen");
        gridNewShare.add(Box.createGlue(), 5);
        gridNewShare.add(this.chkShowPass).anchor(13);
        gridNewShare.nextRow();
        grid.add(pnlNewShare, 3).fill(true, false).expand(true, false);
        grid.nextRow();
        this.btnAdd = new JButton("Hinzuf\u00fcgen");
        this.btnDel = new JButton("Entfernen");
        this.lblError = new QLabel("");
        this.lblError.setForeground(Color.RED);
        grid.add(this.lblError).fill(true, false).expand(true, false);
        grid.add(this.btnAdd).anchor(13);
        grid.add(this.btnDel).anchor(13);
        grid.finish(false);
    }
}

