/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.gui.activity;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.apache.log4j.Logger;
import org.openslx.dozmod.filetransfer.TransferEvent;
import org.openslx.dozmod.filetransfer.TransferEventEmitter;
import org.openslx.dozmod.filetransfer.TransferEventListener;
import org.openslx.dozmod.gui.Gui;
import org.openslx.dozmod.gui.activity.ActivityPanel;
import org.openslx.dozmod.gui.control.BlockProgressBar;
import org.openslx.dozmod.gui.control.QLabel;

public abstract class TransferPanel
extends ActivityPanel
implements TransferEventListener {
    protected final QLabel lblStatus;
    protected final QLabel lblError;
    protected final QLabel lblSpeed;
    protected final QLabel lblRemaining;
    protected final QLabel lblFilename;
    protected final JButton btnClose;
    protected final BlockProgressBar progress;
    private final TransferEventEmitter transfer;
    private final TransferPanel panel = this;
    private final Color defaultLabelColor;
    protected final JPanel header;
    private int errorCountdown = 0;
    private static final Logger LOGGER = Logger.getLogger(TransferPanel.class);
    private JPanel progressWrapper;
    protected JPanel footer;

    public TransferPanel(TransferEventEmitter transfer, String displayName, String fileName) {
        this.setLayout(new BoxLayout(this, 3));
        this.header = new JPanel();
        this.header.setLayout(new BoxLayout(this.header, 2));
        this.lblStatus = new QLabel("Initialisiere");
        this.header.add(this.lblStatus);
        this.header.add(Box.createHorizontalStrut(10));
        QLabel vmName = new QLabel(displayName);
        vmName.setMinimumSize(new Dimension(0, 0));
        vmName.setFont(vmName.getFont().deriveFont(1));
        this.header.add(vmName);
        this.header.add(Box.createHorizontalGlue());
        this.lblFilename = new QLabel(fileName);
        this.lblFilename.setMinimumSize(new Dimension(0, 0));
        this.header.add(this.lblFilename);
        this.header.add(Box.createHorizontalStrut(10));
        this.btnClose = new JButton("Abbrechen");
        this.header.add(this.btnClose);
        this.add(this.header);
        this.progressWrapper = new JPanel();
        this.progressWrapper.setLayout(new GridLayout(1, 1));
        this.progressWrapper.setMinimumSize(Gui.getScaledDimension(0, 50));
        this.progressWrapper.setPreferredSize(this.progressWrapper.getMinimumSize());
        this.progress = new BlockProgressBar(null);
        this.progressWrapper.add(this.progress);
        this.add(this.progressWrapper);
        this.footer = new JPanel();
        this.footer.setLayout(new BoxLayout(this.footer, 2));
        this.lblError = new QLabel();
        this.lblSpeed = new QLabel("-");
        this.lblRemaining = new QLabel("-");
        this.lblSpeed.setMinimumSize(Gui.getScaledDimension(50, 0));
        this.lblRemaining.setMinimumSize(Gui.getScaledDimension(60, 0));
        this.footer.add(this.lblError);
        this.footer.add(Box.createGlue());
        this.footer.add(this.lblSpeed);
        this.footer.add(Box.createRigidArea(Gui.getScaledDimension(6, 6)));
        this.footer.add(this.lblRemaining);
        this.add(this.footer);
        this.transfer = transfer;
        this.defaultLabelColor = this.lblError.getForeground();
    }

    @Override
    public boolean wantConfirmQuit() {
        return this.transfer != null && !this.transfer.isCanceled();
    }

    @Override
    public void update(final TransferEvent event) {
        Gui.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (event.errorMessage != null && !event.errorMessage.isEmpty()) {
                    TransferPanel.this.lblError.setText(event.errorMessage);
                    TransferPanel.this.lblError.setForeground(Color.RED);
                    TransferPanel.this.errorCountdown = 20;
                } else if (TransferPanel.this.errorCountdown > 0) {
                    TransferPanel.this.errorCountdown--;
                    if (TransferPanel.this.errorCountdown == 10) {
                        TransferPanel.this.lblError.setForeground(TransferPanel.this.defaultLabelColor);
                    } else if (TransferPanel.this.errorCountdown == 0) {
                        TransferPanel.this.lblError.setText("");
                    }
                }
                if (event.state != null) {
                    String status;
                    switch (event.state) {
                        case ERROR: {
                            TransferPanel.this.errorCountdown = 20;
                            status = "Fehler";
                            if (!TransferPanel.this.transfer.isCanceled()) break;
                            TransferPanel.this.transfer.removeListener(TransferPanel.this.panel);
                            break;
                        }
                        case FINISHED: {
                            TransferPanel.this.transferDone();
                            status = "Beendet";
                            break;
                        }
                        case IDLE: {
                            status = "Inaktiv";
                            break;
                        }
                        case WORKING: {
                            status = "\u00dcbertragung l\u00e4uft";
                            break;
                        }
                        default: {
                            status = event.state.toString();
                        }
                    }
                    TransferPanel.this.lblStatus.setText(status);
                }
                if (event.remainingRaw != 0L) {
                    TransferPanel.this.lblRemaining.setText(event.remaining);
                }
                if (event.speedRaw != 0L) {
                    if (event.virtualSpeedRaw != 0L) {
                        TransferPanel.this.lblSpeed.setText(event.speed + " (" + event.virtualSpeed + ")");
                    } else {
                        TransferPanel.this.lblSpeed.setText(event.speed);
                    }
                }
                if (event.progress != null) {
                    TransferPanel.this.progress.setStatus(event.progress);
                }
                TransferPanel.this.panel.validate();
            }
        });
    }

    private void transferDone() {
        this.transfer.removeListener(this.panel);
        this.lblRemaining.setText("-");
        this.btnClose.setText("Schlie\u00dfen");
        this.lblFilename.setText("");
        this.footer.setVisible(false);
        this.progressWrapper.setVisible(false);
    }
}

