/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.authentication;

import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.ParseException;
import org.apache.http.client.ClientProtocolException;
import org.apache.log4j.Logger;
import org.openslx.bwlp.thrift.iface.Satellite;
import org.openslx.bwlp.thrift.iface.TAuthorizationException;
import org.openslx.dozmod.authentication.Authenticator;
import org.openslx.dozmod.authentication.ServiceProviderResponse;
import org.openslx.dozmod.authentication.ShibbolethEcp;

public class EcpAuthenticator
implements Authenticator {
    private static final Logger LOGGER = Logger.getLogger(EcpAuthenticator.class);
    private final String ecpUrl;

    public EcpAuthenticator(String ecpUrl) {
        this.ecpUrl = !ecpUrl.isEmpty() ? ecpUrl : null;
    }

    @Override
    public void login(String username, String password, Authenticator.AuthenticatorCallback callback) throws TAuthorizationException, JsonSyntaxException, ClientProtocolException, ParseException, MalformedURLException, URISyntaxException, IOException {
        ShibbolethEcp.ReturnCode ret = ShibbolethEcp.doLogin(this.ecpUrl, username, password);
        if (ret == null) {
            LOGGER.warn("Shibboleth doLogin returned null as ReturnCode!");
            ret = ShibbolethEcp.ReturnCode.GENERIC_ERROR;
        }
        ServiceProviderResponse response = ShibbolethEcp.getResponse();
        RuntimeException errEx = null;
        if (response != null && response.error != null) {
            errEx = new RuntimeException(response.error);
        }
        Authenticator.AuthenticationData data = null;
        if (ret == ShibbolethEcp.ReturnCode.NO_ERROR) {
            String token = response.token;
            if (token == null || token.isEmpty()) {
                LOGGER.error("No token received from the service provider!");
                callback.postLogin(ShibbolethEcp.ReturnCode.SERVICE_PROVIDER_ERROR, null, errEx);
            }
            ArrayList<Satellite> sats = new ArrayList<Satellite>();
            if (response.satellites2 != null) {
                Base64 base64 = new Base64();
                for (Map.Entry<String, ServiceProviderResponse.JSatellite> it : response.satellites2.entrySet()) {
                    ServiceProviderResponse.JSatellite jsat = it.getValue();
                    ByteBuffer hash = jsat.certHash == null ? null : ByteBuffer.wrap(base64.decode(jsat.certHash));
                    sats.add(new Satellite(jsat.addresses, it.getKey(), hash));
                }
            }
            data = new Authenticator.AuthenticationData(response.token, response.sessionId, sats);
        }
        callback.postLogin(ret, data, errEx);
    }
}

