/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.bwlp.thrift.iface;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;

public class Satellite
implements TBase<Satellite, _Fields>,
Serializable,
Cloneable,
Comparable<Satellite> {
    private static final TStruct STRUCT_DESC = new TStruct("Satellite");
    private static final TField ADDRESS_LIST_FIELD_DESC = new TField("addressList", 15, 1);
    private static final TField DISPLAY_NAME_FIELD_DESC = new TField("displayName", 11, 2);
    private static final TField CERT_SHA256_FIELD_DESC = new TField("certSha256", 11, 3);
    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    public List<String> addressList;
    public String displayName;
    public ByteBuffer certSha256;
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public Satellite() {
    }

    public Satellite(List<String> addressList, String displayName, ByteBuffer certSha256) {
        this();
        this.addressList = addressList;
        this.displayName = displayName;
        this.certSha256 = TBaseHelper.copyBinary(certSha256);
    }

    public Satellite(Satellite other) {
        if (other.isSetAddressList()) {
            ArrayList<String> __this__addressList = new ArrayList<String>(other.addressList);
            this.addressList = __this__addressList;
        }
        if (other.isSetDisplayName()) {
            this.displayName = other.displayName;
        }
        if (other.isSetCertSha256()) {
            this.certSha256 = TBaseHelper.copyBinary(other.certSha256);
        }
    }

    public Satellite deepCopy() {
        return new Satellite(this);
    }

    @Override
    public void clear() {
        this.addressList = null;
        this.displayName = null;
        this.certSha256 = null;
    }

    public int getAddressListSize() {
        return this.addressList == null ? 0 : this.addressList.size();
    }

    public Iterator<String> getAddressListIterator() {
        return this.addressList == null ? null : this.addressList.iterator();
    }

    public void addToAddressList(String elem) {
        if (this.addressList == null) {
            this.addressList = new ArrayList<String>();
        }
        this.addressList.add(elem);
    }

    public List<String> getAddressList() {
        return this.addressList;
    }

    public Satellite setAddressList(List<String> addressList) {
        this.addressList = addressList;
        return this;
    }

    public void unsetAddressList() {
        this.addressList = null;
    }

    public boolean isSetAddressList() {
        return this.addressList != null;
    }

    public void setAddressListIsSet(boolean value) {
        if (!value) {
            this.addressList = null;
        }
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Satellite setDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public void unsetDisplayName() {
        this.displayName = null;
    }

    public boolean isSetDisplayName() {
        return this.displayName != null;
    }

    public void setDisplayNameIsSet(boolean value) {
        if (!value) {
            this.displayName = null;
        }
    }

    public byte[] getCertSha256() {
        this.setCertSha256(TBaseHelper.rightSize(this.certSha256));
        return this.certSha256 == null ? null : this.certSha256.array();
    }

    public ByteBuffer bufferForCertSha256() {
        return TBaseHelper.copyBinary(this.certSha256);
    }

    public Satellite setCertSha256(byte[] certSha256) {
        this.certSha256 = certSha256 == null ? (ByteBuffer)null : ByteBuffer.wrap(Arrays.copyOf(certSha256, certSha256.length));
        return this;
    }

    public Satellite setCertSha256(ByteBuffer certSha256) {
        this.certSha256 = TBaseHelper.copyBinary(certSha256);
        return this;
    }

    public void unsetCertSha256() {
        this.certSha256 = null;
    }

    public boolean isSetCertSha256() {
        return this.certSha256 != null;
    }

    public void setCertSha256IsSet(boolean value) {
        if (!value) {
            this.certSha256 = null;
        }
    }

    @Override
    public void setFieldValue(_Fields field, Object value) {
        switch (field) {
            case ADDRESS_LIST: {
                if (value == null) {
                    this.unsetAddressList();
                    break;
                }
                this.setAddressList((List)value);
                break;
            }
            case DISPLAY_NAME: {
                if (value == null) {
                    this.unsetDisplayName();
                    break;
                }
                this.setDisplayName((String)value);
                break;
            }
            case CERT_SHA256: {
                if (value == null) {
                    this.unsetCertSha256();
                    break;
                }
                this.setCertSha256((ByteBuffer)value);
            }
        }
    }

    @Override
    public Object getFieldValue(_Fields field) {
        switch (field) {
            case ADDRESS_LIST: {
                return this.getAddressList();
            }
            case DISPLAY_NAME: {
                return this.getDisplayName();
            }
            case CERT_SHA256: {
                return this.getCertSha256();
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case ADDRESS_LIST: {
                return this.isSetAddressList();
            }
            case DISPLAY_NAME: {
                return this.isSetDisplayName();
            }
            case CERT_SHA256: {
                return this.isSetCertSha256();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof Satellite) {
            return this.equals((Satellite)that);
        }
        return false;
    }

    public boolean equals(Satellite that) {
        if (that == null) {
            return false;
        }
        boolean this_present_addressList = this.isSetAddressList();
        boolean that_present_addressList = that.isSetAddressList();
        if (this_present_addressList || that_present_addressList) {
            if (!this_present_addressList || !that_present_addressList) {
                return false;
            }
            if (!this.addressList.equals(that.addressList)) {
                return false;
            }
        }
        boolean this_present_displayName = this.isSetDisplayName();
        boolean that_present_displayName = that.isSetDisplayName();
        if (this_present_displayName || that_present_displayName) {
            if (!this_present_displayName || !that_present_displayName) {
                return false;
            }
            if (!this.displayName.equals(that.displayName)) {
                return false;
            }
        }
        boolean this_present_certSha256 = this.isSetCertSha256();
        boolean that_present_certSha256 = that.isSetCertSha256();
        if (this_present_certSha256 || that_present_certSha256) {
            if (!this_present_certSha256 || !that_present_certSha256) {
                return false;
            }
            if (!this.certSha256.equals(that.certSha256)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        ArrayList<Object> list = new ArrayList<Object>();
        boolean present_addressList = this.isSetAddressList();
        list.add(present_addressList);
        if (present_addressList) {
            list.add(this.addressList);
        }
        boolean present_displayName = this.isSetDisplayName();
        list.add(present_displayName);
        if (present_displayName) {
            list.add(this.displayName);
        }
        boolean present_certSha256 = this.isSetCertSha256();
        list.add(present_certSha256);
        if (present_certSha256) {
            list.add(this.certSha256);
        }
        return list.hashCode();
    }

    @Override
    public int compareTo(Satellite other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetAddressList()).compareTo(other.isSetAddressList());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetAddressList() && (lastComparison = TBaseHelper.compareTo(this.addressList, other.addressList)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetDisplayName()).compareTo(other.isSetDisplayName());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetDisplayName() && (lastComparison = TBaseHelper.compareTo(this.displayName, other.displayName)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetCertSha256()).compareTo(other.isSetCertSha256());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetCertSha256() && (lastComparison = TBaseHelper.compareTo(this.certSha256, other.certSha256)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Override
    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        schemes.get(iprot.getScheme()).getScheme().read(iprot, (Satellite)this);
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        schemes.get(oprot.getScheme()).getScheme().write(oprot, (Satellite)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Satellite(");
        boolean first = true;
        sb.append("addressList:");
        if (this.addressList == null) {
            sb.append("null");
        } else {
            sb.append(this.addressList);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("displayName:");
        if (this.displayName == null) {
            sb.append("null");
        } else {
            sb.append(this.displayName);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("certSha256:");
        if (this.certSha256 == null) {
            sb.append("null");
        } else {
            TBaseHelper.toString(this.certSha256, sb);
        }
        first = false;
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write(new TCompactProtocol(new TIOStreamTransport(out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.read(new TCompactProtocol(new TIOStreamTransport(in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    static {
        schemes.put(StandardScheme.class, new SatelliteStandardSchemeFactory());
        schemes.put(TupleScheme.class, new SatelliteTupleSchemeFactory());
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.ADDRESS_LIST, new FieldMetaData("addressList", 3, new ListMetaData(15, new FieldValueMetaData(11))));
        tmpMap.put(_Fields.DISPLAY_NAME, new FieldMetaData("displayName", 3, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.CERT_SHA256, new FieldMetaData("certSha256", 3, new FieldValueMetaData(11, true)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(Satellite.class, metaDataMap);
    }

    private static class SatelliteTupleScheme
    extends TupleScheme<Satellite> {
        private SatelliteTupleScheme() {
        }

        @Override
        public void write(TProtocol prot, Satellite struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            BitSet optionals = new BitSet();
            if (struct.isSetAddressList()) {
                optionals.set(0);
            }
            if (struct.isSetDisplayName()) {
                optionals.set(1);
            }
            if (struct.isSetCertSha256()) {
                optionals.set(2);
            }
            oprot.writeBitSet(optionals, 3);
            if (struct.isSetAddressList()) {
                oprot.writeI32(struct.addressList.size());
                for (String _iter12 : struct.addressList) {
                    oprot.writeString(_iter12);
                }
            }
            if (struct.isSetDisplayName()) {
                oprot.writeString(struct.displayName);
            }
            if (struct.isSetCertSha256()) {
                oprot.writeBinary(struct.certSha256);
            }
        }

        @Override
        public void read(TProtocol prot, Satellite struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            BitSet incoming = iprot.readBitSet(3);
            if (incoming.get(0)) {
                TList _list13 = new TList(11, iprot.readI32());
                struct.addressList = new ArrayList<String>(_list13.size);
                for (int _i15 = 0; _i15 < _list13.size; ++_i15) {
                    String _elem14 = iprot.readString();
                    struct.addressList.add(_elem14);
                }
                struct.setAddressListIsSet(true);
            }
            if (incoming.get(1)) {
                struct.displayName = iprot.readString();
                struct.setDisplayNameIsSet(true);
            }
            if (incoming.get(2)) {
                struct.certSha256 = iprot.readBinary();
                struct.setCertSha256IsSet(true);
            }
        }
    }

    private static class SatelliteTupleSchemeFactory
    implements SchemeFactory {
        private SatelliteTupleSchemeFactory() {
        }

        public SatelliteTupleScheme getScheme() {
            return new SatelliteTupleScheme();
        }
    }

    private static class SatelliteStandardScheme
    extends StandardScheme<Satellite> {
        private SatelliteStandardScheme() {
        }

        @Override
        public void read(TProtocol iprot, Satellite struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 15) {
                            TList _list8 = iprot.readListBegin();
                            struct.addressList = new ArrayList<String>(_list8.size);
                            for (int _i10 = 0; _i10 < _list8.size; ++_i10) {
                                String _elem9 = iprot.readString();
                                struct.addressList.add(_elem9);
                            }
                            iprot.readListEnd();
                            struct.setAddressListIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 11) {
                            struct.displayName = iprot.readString();
                            struct.setDisplayNameIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 11) {
                            struct.certSha256 = iprot.readBinary();
                            struct.setCertSha256IsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        @Override
        public void write(TProtocol oprot, Satellite struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.addressList != null) {
                oprot.writeFieldBegin(ADDRESS_LIST_FIELD_DESC);
                oprot.writeListBegin(new TList(11, struct.addressList.size()));
                for (String _iter11 : struct.addressList) {
                    oprot.writeString(_iter11);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.displayName != null) {
                oprot.writeFieldBegin(DISPLAY_NAME_FIELD_DESC);
                oprot.writeString(struct.displayName);
                oprot.writeFieldEnd();
            }
            if (struct.certSha256 != null) {
                oprot.writeFieldBegin(CERT_SHA256_FIELD_DESC);
                oprot.writeBinary(struct.certSha256);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class SatelliteStandardSchemeFactory
    implements SchemeFactory {
        private SatelliteStandardSchemeFactory() {
        }

        public SatelliteStandardScheme getScheme() {
            return new SatelliteStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        ADDRESS_LIST(1, "addressList"),
        DISPLAY_NAME(2, "displayName"),
        CERT_SHA256(3, "certSha256");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return ADDRESS_LIST;
                }
                case 2: {
                    return DISPLAY_NAME;
                }
                case 3: {
                    return CERT_SHA256;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        @Override
        public short getThriftFieldId() {
            return this._thriftId;
        }

        @Override
        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

