/*
 * Decompiled with CFR 0.152.
 */
package org.jdatepicker;

import java.awt.Color;
import java.awt.SystemColor;
import java.util.HashMap;
import java.util.Map;

public final class ComponentColorDefaults {
    private static ComponentColorDefaults instance;
    private Map<Key, Color> colors = new HashMap<Key, Color>();

    public static ComponentColorDefaults getInstance() {
        if (instance == null) {
            instance = new ComponentColorDefaults();
        }
        return instance;
    }

    private ComponentColorDefaults() {
        this.colors.put(Key.FG_MONTH_SELECTOR, SystemColor.activeCaptionText);
        this.colors.put(Key.BG_MONTH_SELECTOR, SystemColor.activeCaption);
        this.colors.put(Key.FG_GRID_HEADER, new Color(10, 36, 106));
        this.colors.put(Key.BG_GRID_HEADER, Color.LIGHT_GRAY);
        this.colors.put(Key.FG_GRID_THIS_MONTH, Color.BLACK);
        this.colors.put(Key.FG_GRID_OTHER_MONTH, Color.LIGHT_GRAY);
        this.colors.put(Key.FG_GRID_TODAY, Color.RED);
        this.colors.put(Key.BG_GRID, Color.WHITE);
        this.colors.put(Key.BG_GRID_NOT_SELECTABLE, new Color(240, 240, 240));
        this.colors.put(Key.FG_GRID_SELECTED, Color.WHITE);
        this.colors.put(Key.BG_GRID_SELECTED, new Color(10, 36, 106));
        this.colors.put(Key.FG_GRID_TODAY_SELECTED, Color.RED);
        this.colors.put(Key.BG_GRID_TODAY_SELECTED, new Color(10, 36, 106));
        this.colors.put(Key.FG_TODAY_SELECTOR_ENABLED, Color.BLACK);
        this.colors.put(Key.FG_TODAY_SELECTOR_DISABLED, Color.LIGHT_GRAY);
        this.colors.put(Key.BG_TODAY_SELECTOR, Color.WHITE);
        this.colors.put(Key.POPUP_BORDER, Color.BLACK);
    }

    public Color getColor(Key key) {
        return this.colors.get((Object)key);
    }

    public void setColor(Key key, Color color) {
        this.colors.put(key, color);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Key {
        FG_MONTH_SELECTOR,
        BG_MONTH_SELECTOR,
        FG_GRID_HEADER,
        BG_GRID_HEADER,
        FG_GRID_THIS_MONTH,
        FG_GRID_OTHER_MONTH,
        FG_GRID_TODAY,
        BG_GRID,
        BG_GRID_NOT_SELECTABLE,
        FG_GRID_SELECTED,
        BG_GRID_SELECTED,
        FG_GRID_TODAY_SELECTED,
        BG_GRID_TODAY_SELECTED,
        FG_TODAY_SELECTOR_ENABLED,
        FG_TODAY_SELECTOR_DISABLED,
        BG_TODAY_SELECTOR,
        POPUP_BORDER;

    }
}

