/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.scc.dei.ecplean;

import edu.kit.scc.dei.ecplean.ECPAuthState;
import edu.kit.scc.dei.ecplean.ECPAuthenticationException;
import edu.kit.scc.dei.ecplean.ECPAuthenticationInfo;
import edu.kit.scc.dei.ecplean.ECPAuthenticatorBase;
import java.io.IOException;
import java.net.URI;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathException;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ECPAuthenticator
extends ECPAuthenticatorBase {
    public ECPAuthenticator(CloseableHttpClient client, String username, String password, URI idpEcpEndpoint, URI spUrl) {
        super(client);
        this.authInfo = new ECPAuthenticationInfo(username, password, idpEcpEndpoint, spUrl);
    }

    public ECPAuthenticator(String username, String password, URI idpEcpEndpoint, URI spUrl) {
        this.authInfo = new ECPAuthenticationInfo(username, password, idpEcpEndpoint, spUrl);
    }

    public HttpResponse authenticate() throws ECPAuthenticationException {
        String assertionConsumerUrl;
        String responseConsumerUrl;
        String relayState;
        Document initResponse;
        String responseBody;
        CloseableHttpResponse httpResponse;
        logger.info("Starting authentication");
        logger.info("Contacting SP " + this.authInfo.getSpUrl());
        this.authInfo.setAuthState(ECPAuthState.INITIAL_PAOS_SP);
        this.setChanged();
        this.notifyObservers(this.authInfo);
        logger.info("Sending initial SP Request xyz");
        HttpGet httpGet = new HttpGet(this.authInfo.getSpUrl().toString());
        httpGet.setHeader("Accept", "text/html, application/vnd.paos+xml");
        httpGet.setHeader("PAOS", "ver=\"urn:liberty:paos:2003-08\";\"urn:oasis:names:tc:SAML:2.0:profiles:SSO:ecp\"");
        HttpClientContext ctx = HttpClientContext.create();
        ctx.setCookieStore(new BasicCookieStore());
        try {
            httpResponse = this.client.execute((HttpUriRequest)httpGet, ctx);
            responseBody = EntityUtils.toString(httpResponse.getEntity());
            httpGet.reset();
        }
        catch (IOException | ParseException e) {
            logger.debug("Initial SP Request failed");
            throw new ECPAuthenticationException(e);
        }
        try {
            initResponse = this.buildDocumentFromString(responseBody);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            logger.debug("Parsing SP Request failed");
            throw new ECPAuthenticationException(e);
        }
        try {
            relayState = (String)this.queryDocument(initResponse, "//ecp:RelayState", XPathConstants.STRING);
        }
        catch (XPathException e) {
            logger.debug("Could not find relay state in PAOS answer from SP");
            throw new ECPAuthenticationException(e);
        }
        logger.info("Got relayState: " + relayState);
        try {
            responseConsumerUrl = (String)this.queryDocument(initResponse, "/S:Envelope/S:Header/paos:Request/@responseConsumerURL", XPathConstants.STRING);
        }
        catch (XPathException e) {
            logger.debug("Could not find response consumer url in PAOS answer from SP");
            throw new ECPAuthenticationException(e);
        }
        logger.info("Got responseConsumerUrl: " + responseConsumerUrl);
        Node firstChild = initResponse.getDocumentElement().getFirstChild();
        initResponse.getDocumentElement().removeChild(firstChild);
        Document idpResponse = this.authenticateIdP(initResponse);
        String statusCode = this.getStatusCode(idpResponse);
        if (statusCode == null) {
            throw new ECPAuthenticationException("IdP returned no status code!!!x");
        }
        if (!statusCode.endsWith(":Success") && !statusCode.endsWith(":success")) {
            throw new ECPAuthenticationException("IdP Returned StatusCode " + statusCode);
        }
        try {
            assertionConsumerUrl = (String)this.queryDocument(idpResponse, "/S:Envelope/S:Header/ecp:Response/@AssertionConsumerServiceURL", XPathConstants.STRING);
        }
        catch (Exception e) {
            logger.debug("Could not find assertion consumer url in answer from IdP");
            throw new ECPAuthenticationException(e);
        }
        logger.info("Got assertionConsumerUrl: " + assertionConsumerUrl);
        if (!assertionConsumerUrl.equals(responseConsumerUrl)) {
            throw new ECPAuthenticationException("Assertion- and ResponseConsumerURL don't match");
        }
        idpResponse.getDocumentElement().getFirstChild().getFirstChild().setTextContent(relayState);
        logger.info("Sending Assertion to SP");
        HttpPost httpPost = new HttpPost(assertionConsumerUrl);
        httpPost.setHeader("Content-Type", "application/vnd.paos+xml");
        try {
            httpPost.setEntity(new StringEntity(this.documentToString(idpResponse)));
            httpResponse = this.client.execute((HttpUriRequest)httpPost, ctx);
            logger.info("Asserting resulted in " + httpResponse.getStatusLine());
            httpPost.reset();
        }
        catch (IOException | TransformerException e) {
            logger.debug("Could not post assertion back to SP");
            throw new ECPAuthenticationException(e);
        }
        logger.info("Requesting original URL");
        httpGet = new HttpGet(this.authInfo.getSpUrl().toString());
        try {
            httpResponse = this.client.execute((HttpUriRequest)httpGet, ctx);
        }
        catch (IOException e) {
            logger.debug("Could not request original URL");
            throw new ECPAuthenticationException(e);
        }
        return httpResponse;
    }

    private String getStatusCode(Document idpResponse) {
        NodeList nl;
        String result = null;
        try {
            nl = (NodeList)this.queryDocument(idpResponse, "//*", XPathConstants.NODESET);
        }
        catch (XPathException e) {
            return null;
        }
        if (nl == null) {
            return null;
        }
        for (int i = 0; i < nl.getLength(); ++i) {
            Node val;
            Node ns = nl.item(i);
            if (!ns.getLocalName().endsWith("StatusCode") || !ns.hasAttributes() || (val = ns.getAttributes().getNamedItem("Value")) == null || result != null && !result.endsWith(":Responder")) continue;
            result = val.getNodeValue();
        }
        return result;
    }
}

