/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.util;

public class TimeoutReference<T> {
    private final long timeoutMs;
    private final boolean refreshOnGet;
    private final T item;
    private long deadline;
    private boolean invalid;

    public TimeoutReference(boolean refreshOnGet, long timeoutMs, T item) {
        this.refreshOnGet = refreshOnGet;
        this.item = item;
        this.timeoutMs = timeoutMs;
        this.deadline = System.currentTimeMillis() + timeoutMs;
    }

    public TimeoutReference(long timeoutMs, T item) {
        this(false, timeoutMs, item);
    }

    public synchronized T get() {
        if (this.item == null || this.invalid) {
            return null;
        }
        long now = System.currentTimeMillis();
        if (this.deadline < now) {
            this.invalid = true;
            return null;
        }
        if (this.refreshOnGet) {
            this.deadline = now + this.timeoutMs;
        }
        return this.item;
    }

    synchronized boolean isInvalid() {
        return this.invalid;
    }

    public int hashCode() {
        return this.item == null ? super.hashCode() : this.item.hashCode();
    }

    public boolean equals(Object o) {
        return this == o || this.item == o || o != null && o.equals(this.item);
    }
}

