/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.util;

import java.util.Timer;
import java.util.TimerTask;
import org.apache.log4j.Logger;

public class QuickTimer {
    private static final Logger LOGGER = Logger.getLogger(QuickTimer.class);
    private static final Timer timer = new Timer("QuickTimer", true);

    public static void scheduleAtFixedDelay(Task task, long delay, long period) {
        timer.schedule((TimerTask)task, delay, period);
    }

    public static void scheduleAtFixedRate(Task task, long delay, long period) {
        timer.scheduleAtFixedRate((TimerTask)task, delay, period);
    }

    public static void scheduleOnce(Task task, long delay) {
        timer.schedule((TimerTask)task, delay);
    }

    public static void scheduleOnce(Task timerTask) {
        QuickTimer.scheduleOnce(timerTask, 1L);
    }

    public static void cancel() {
        timer.cancel();
    }

    public static abstract class Task
    extends TimerTask {
        @Override
        public final void run() {
            try {
                this.fire();
            }
            catch (Throwable t) {
                LOGGER.warn("A Task threw an exception!", t);
            }
        }

        public abstract void fire();
    }
}

