/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.imagemaster.crcchecker;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class ImageFile {
    private File f;
    private RandomAccessFile file = null;
    private int blockSize;

    public ImageFile(String filename, int blockSize) {
        this.f = new File(filename);
        this.blockSize = blockSize;
    }

    public int getBlock(int block, byte[] array) throws IOException {
        if (block < 0) {
            return 0;
        }
        if ((long)block > this.f.length() / (long)this.blockSize) {
            return 0;
        }
        if (this.file == null) {
            this.file = new RandomAccessFile(this.f, "r");
        }
        this.file.seek((long)block * (long)this.blockSize);
        return this.file.read(array);
    }

    public long length() {
        return this.f.length();
    }

    public void close() {
        try {
            if (this.file == null) {
                return;
            }
            this.file.close();
            this.file = null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

