/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.imagemaster.crcchecker;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.zip.CRC32;
import org.apache.log4j.Logger;

public class CrcFile {
    private final int masterCrc;
    private final int[] crcSums;
    private Boolean valid = null;
    private final File file;
    private static Logger log = Logger.getLogger(CrcFile.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CrcFile(String filename) throws IOException {
        this.file = new File(filename);
        FilterInputStream dis = null;
        try {
            dis = new DataInputStream(new FileInputStream(this.file));
            int numSums = (int)(this.file.length() / 4L) - 1;
            if (numSums < 0) {
                throw new IOException("Invalid crc file: " + filename);
            }
            this.masterCrc = ((DataInputStream)dis).readInt();
            int[] sums = new int[numSums];
            for (int i = 0; i < numSums; ++i) {
                sums[i] = ((DataInputStream)dis).readInt();
            }
            this.crcSums = sums;
        }
        finally {
            if (dis != null) {
                try {
                    dis.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public CrcFile(int[] crcSumsWithLeadingMasterCrc) {
        this.file = null;
        this.masterCrc = crcSumsWithLeadingMasterCrc[0];
        this.crcSums = Arrays.copyOfRange(crcSumsWithLeadingMasterCrc, 1, crcSumsWithLeadingMasterCrc.length);
    }

    public CrcFile(List<Integer> crcSumsWithLeadingMasterCrc) {
        this.file = null;
        this.masterCrc = crcSumsWithLeadingMasterCrc.get(0);
        this.crcSums = new int[crcSumsWithLeadingMasterCrc.size() - 1];
        for (int i = 0; i < this.crcSums.length; ++i) {
            this.crcSums[i] = crcSumsWithLeadingMasterCrc.get(i + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeCrcFile(String filename) {
        File file = new File(filename);
        if (file.exists()) {
            file.delete();
        }
        FileOutputStream fos = null;
        DataOutputStream dos = null;
        try {
            fos = new FileOutputStream(file);
        }
        catch (FileNotFoundException e) {
            log.error("File " + filename + " not found.", e);
            return;
        }
        try {
            dos = new DataOutputStream(fos);
            dos.writeInt(Integer.reverseBytes(this.masterCrc));
            for (int sum : this.crcSums) {
                dos.writeInt(Integer.reverseBytes(sum));
            }
        }
        catch (IOException e) {
            log.error("IOException", e);
            return;
        }
        finally {
            if (dos != null) {
                try {
                    dos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public boolean isValid() {
        if (this.valid == null) {
            if (this.crcSums == null || this.crcSums.length < 1) {
                return false;
            }
            int masterSum = this.crcSums[0];
            CRC32 crcCalc = new CRC32();
            byte[] buffer = new byte[4];
            for (int i = 1; i < this.crcSums.length; ++i) {
                crcCalc.update(CrcFile.intToByteArrayLittleEndian(this.crcSums[i], buffer));
            }
            this.valid = masterSum == Integer.reverseBytes((int)crcCalc.getValue());
        }
        return this.valid;
    }

    public void delete() {
        if (this.file != null) {
            this.file.delete();
        }
    }

    public int getCRCSum(int blockNumber) {
        if (this.crcSums == null || blockNumber < 0 || blockNumber >= this.crcSums.length) {
            return 0;
        }
        return this.crcSums[blockNumber];
    }

    public List<Integer> getCrcSums() {
        ArrayList<Integer> ret = new ArrayList<Integer>(this.crcSums.length);
        for (int i = 0; i < this.crcSums.length; ++i) {
            ret.add(this.crcSums[i]);
        }
        return ret;
    }

    public int getMasterSum() {
        return this.masterCrc;
    }

    private static final byte[] intToByteArrayLittleEndian(int value, byte[] buffer) {
        buffer[3] = (byte)(value >>> 24);
        buffer[2] = (byte)(value >>> 16);
        buffer[1] = (byte)(value >>> 8);
        buffer[0] = (byte)value;
        return buffer;
    }
}

