/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.imagemaster.crcchecker;

import java.io.IOException;
import org.openslx.imagemaster.crcchecker.CrcChecker;
import org.openslx.imagemaster.crcchecker.CrcFile;
import org.openslx.imagemaster.crcchecker.ImageFile;

public class ClassTest {
    public static void main(String[] args) throws IOException {
        if (args.length != 2) {
            System.out.println("Usage: filename crcfilename");
            return;
        }
        String filename = args[0];
        String filenameCrc = args[1];
        int blockSize = 0x1000000;
        CrcFile f = new CrcFile(filenameCrc);
        System.out.println("Master sum: '" + f.getMasterSum() + "'");
        System.out.println("CRC file is '" + (f.isValid() ? "valid" : "invalid") + "'");
        ImageFile imageFile = new ImageFile(filename, 0x1000000);
        CrcChecker crcFile = new CrcChecker(imageFile, f);
        int blocks = ClassTest.getNumberOfBlocks(imageFile.length(), 0x1000000);
        for (int i = 0; i < blocks; ++i) {
            System.out.println("Block\t" + i + "\tis  '" + (crcFile.checkBlock(i) ? "valid" : "invalid") + "'");
        }
        crcFile.done();
    }

    public static int getNumberOfBlocks(long fileSize, int blockSize) {
        int blocks = (int)(fileSize / (long)blockSize);
        if (fileSize % (long)blockSize != 0L) {
            ++blocks;
        }
        return blocks;
    }
}

