/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.gui.wizard.page;

import java.awt.KeyboardFocusManager;
import java.awt.Window;
import org.apache.log4j.Logger;
import org.openslx.bwlp.thrift.iface.ImageSummaryRead;
import org.openslx.bwlp.thrift.iface.TransferState;
import org.openslx.dozmod.Branding;
import org.openslx.dozmod.filetransfer.TransferEvent;
import org.openslx.dozmod.filetransfer.TransferEventListener;
import org.openslx.dozmod.gui.Gui;
import org.openslx.dozmod.gui.MainWindow;
import org.openslx.dozmod.gui.wizard.LectureWizard;
import org.openslx.dozmod.gui.wizard.Wizard;
import org.openslx.dozmod.gui.wizard.layout.ImageUploadSummaryPageLayout;
import org.openslx.dozmod.state.UploadWizardState;
import org.openslx.dozmod.thrift.UploadInitiator;
import org.openslx.dozmod.thrift.cache.ImageCache;
import org.openslx.util.QuickTimer;

public class ImageUploadSummaryPage
extends ImageUploadSummaryPageLayout {
    private static final Logger LOGGER = Logger.getLogger(ImageUploadSummaryPage.class);
    private boolean pageIsVisible = false;
    private boolean uploadListenerAdded = false;
    private boolean allowCreateLecture = false;
    private final UploadWizardState state;
    private final TransferEventListener uploadListener = new TransferEventListener(){

        @Override
        public void update(TransferEvent event) {
            LOGGER.debug("update transfer event");
            if (!ImageUploadSummaryPage.this.pageIsVisible) {
                return;
            }
            if (event.progress != null) {
                ImageUploadSummaryPage.this.ctlUploadProgressBar.setStatus(event.progress);
            }
            if (event.state == TransferState.FINISHED) {
                ImageUploadSummaryPage.this.updateInfoText(null);
                ((ImageUploadSummaryPage)ImageUploadSummaryPage.this).state.upload.getUploadTask().removeListener(ImageUploadSummaryPage.this.uploadListener);
            }
        }
    };
    private final QuickTimer.Task updateHelpText = new QuickTimer.Task(){
        private UploadInitiator.UploadInitState lastInitState = null;

        @Override
        public void fire() {
            UploadInitiator.UploadInitState initState;
            LOGGER.debug("update help text");
            if (!ImageUploadSummaryPage.this.pageIsVisible) {
                this.cancel();
                return;
            }
            if (!ImageUploadSummaryPage.this.uploadListenerAdded && ((ImageUploadSummaryPage)ImageUploadSummaryPage.this).state.upload.getUploadTask() != null) {
                ImageUploadSummaryPage.this.uploadListenerAdded = true;
                ((ImageUploadSummaryPage)ImageUploadSummaryPage.this).state.upload.getUploadTask().addListener(ImageUploadSummaryPage.this.uploadListener);
            }
            if ((initState = ((ImageUploadSummaryPage)ImageUploadSummaryPage.this).state.upload.getState()) != this.lastInitState) {
                this.lastInitState = initState;
                ImageUploadSummaryPage.this.updateInfoText(initState);
            }
            if (this.lastInitState == UploadInitiator.UploadInitState.UPLOAD_STARTED || this.lastInitState == UploadInitiator.UploadInitState.ERROR) {
                this.cancel();
            }
        }
    };

    private void updateInfoText(final UploadInitiator.UploadInitState initState) {
        String text;
        if (this.state.upload.getUploadTask() != null && this.state.upload.getUploadTask().isComplete()) {
            text = "Die Virtuelle Maschine wurde erfolgreich auf den Server hochgeladen.";
        } else {
            if (initState == null) {
                return;
            }
            switch (initState) {
                case REQUESTING: {
                    text = "Der Upload-Vorgang wird mit dem Server ausgehandelt...";
                    break;
                }
                case WAITING_FOR_SLOT: {
                    text = "Der Server ist zur Zeit \u00fcberlastet, da zu viele Uploads gleichzeitig laufen. Es wird gewartet, bis der Server wieder Kapazit\u00e4ten frei hat. Bitte schlie\u00dfen Sie dieses Fenster nicht.";
                    break;
                }
                case UPLOAD_STARTING: {
                    text = "Die Verbindung zur \u00dcbertragung der VM wird aufgebaut...";
                    break;
                }
                case UPLOAD_STARTED: {
                    text = "Der Upload Ihrer Virtuellen Maschine wurde gestartet. Wenn Sie m\u00f6chten, k\u00f6nnen Sie diesen Assistenten schlie\u00dfen, und die Anwendung weiterverwenden. Die \u00dcbertragung l\u00e4uft dabei im Hintergrund weiter.";
                    break;
                }
                case ERROR: {
                    text = "Die Initialisierung des Uploads auf den Server ist fehlgeschlagen. Sie k\u00f6nnen versuchen, den Vorgang erneut zu starten. Falls das Problem weiterhin besteht, kontaktieren Sie den " + Branding.getServiceName() + "-Support Ihrer Einrichtung.";
                    if (this.state.upload.getErrorMessage() == null) break;
                    text = text + "<br><br>Weitere Informationen:<br>" + this.state.upload.getErrorMessage();
                    break;
                }
                default: {
                    return;
                }
            }
        }
        final String t = text;
        Gui.asyncExec(new Runnable(){

            @Override
            public void run() {
                ImageUploadSummaryPage.this.lblHelpText.setText("<html><body style ='width:100%'>" + t + "</body></html>");
                if (initState == UploadInitiator.UploadInitState.UPLOAD_STARTED) {
                    ImageUploadSummaryPage.this.setPageComplete(true);
                }
                if (((ImageUploadSummaryPage)ImageUploadSummaryPage.this).state.upload.getUploadTask() != null && ((ImageUploadSummaryPage)ImageUploadSummaryPage.this).state.upload.getUploadTask().isComplete()) {
                    ImageUploadSummaryPage.this.chkCreateLecture.setVisible(ImageUploadSummaryPage.this.allowCreateLecture);
                }
            }
        });
    }

    public ImageUploadSummaryPage(Wizard wizard, UploadWizardState state, boolean allowCreateLecture) {
        super(wizard);
        this.state = state;
        this.allowCreateLecture = allowCreateLecture;
        this.setPageComplete(false);
    }

    @Override
    protected void onPageEnter() {
        if (this.pageIsVisible) {
            return;
        }
        this.pageIsVisible = true;
        this.updateInfoText(UploadInitiator.UploadInitState.REQUESTING);
        QuickTimer.scheduleAtFixedDelay(this.updateHelpText, 500L, 3000L);
    }

    @Override
    protected void onPageLeave() {
        if (!this.pageIsVisible) {
            return;
        }
        this.pageIsVisible = false;
        this.state.upload.getUploadTask().removeListener(this.uploadListener);
        if (!this.wizard.isCancelled() && !this.state.upload.getUploadTask().isCanceled()) {
            MainWindow.addUpload(this.state);
        }
        if (!this.wizard.isCancelled() && this.chkCreateLecture.isSelected()) {
            this.wizard.setVisible(false);
            Window parent = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
            ImageSummaryRead image = null;
            for (ImageSummaryRead tmpImage : ImageCache.get(true)) {
                if (!tmpImage.imageBaseId.equals(this.state.uuid)) continue;
                image = tmpImage;
                break;
            }
            if (image != null) {
                new LectureWizard(parent, image, this.state.upload.getToken()).setVisible(true);
            } else {
                LOGGER.error("Couldn't find the new image in the image cache.");
            }
        }
    }
}

