/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.gui.wizard;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.openslx.dozmod.gui.Gui;
import org.openslx.dozmod.gui.control.QLabel;
import org.openslx.dozmod.gui.helper.GridManager;
import org.openslx.dozmod.gui.wizard.WizardPage;
import org.openslx.dozmod.util.ResourceLoader;

public abstract class Wizard
extends JDialog {
    private final QLabel titleLabel;
    private final QLabel messageLabel;
    private final List<WizardPage> pages = new ArrayList<WizardPage>();
    private WizardPage postFinishPage = null;
    private boolean isPostFinish = false;
    private final JPanel contentPanel;
    private int currentPage = -1;
    private boolean needsLayout = true;
    private boolean isCancelled = false;
    private final JButton btnPrev;
    private final JButton btnNext;
    private final JButton btnCancel;
    private final JButton btnFinish;

    public Wizard(Window parent) {
        super(parent, Dialog.ModalityType.APPLICATION_MODAL);
        this.setDefaultCloseOperation(0);
        this.setLayout(new BorderLayout());
        JPanel header = new JPanel();
        header.setMinimumSize(Gui.getScaledDimension(0, 100));
        header.setOpaque(true);
        header.setBackground(Color.WHITE);
        header.setLayout(new BoxLayout(header, 3));
        header.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.titleLabel = new QLabel("<title>");
        this.messageLabel = new QLabel("<message>");
        this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(1));
        this.titleLabel.setForeground(Color.BLACK);
        this.messageLabel.setForeground(Color.BLACK);
        this.messageLabel.setHorizontalTextPosition(4);
        header.add(this.titleLabel);
        header.add(this.messageLabel);
        JPanel headerWrapper = new JPanel();
        GridManager grid = new GridManager(headerWrapper, 1, false);
        grid.add(header).expand(true, false).fill(true, false);
        grid.add(new JSeparator()).expand(true, false).fill(true, false);
        grid.finish(false);
        this.getContentPane().add((Component)headerWrapper, "First");
        JPanel footer = new JPanel();
        footer.setLayout(new BoxLayout(footer, 2));
        footer.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        footer.add(Box.createHorizontalGlue());
        this.btnPrev = new JButton("< Zur\u00fcck");
        this.btnNext = new JButton("Weiter >");
        this.btnCancel = new JButton("Abbrechen");
        this.btnFinish = new JButton("Fertigstellen");
        footer.add(this.btnPrev);
        footer.add(this.btnNext);
        footer.add(Box.createRigidArea(new Dimension(10, 10)));
        footer.add(this.btnCancel);
        footer.add(Box.createRigidArea(new Dimension(5, 5)));
        footer.add(this.btnFinish);
        this.add((Component)footer, "Last");
        this.contentPanel = new JPanel();
        this.contentPanel.setLayout(new BoxLayout(this.contentPanel, 3));
        this.contentPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.add((Component)this.contentPanel, "Center");
        this.setPreferredSize(Gui.getScaledDimension(550, 420));
        this.setResizable(false);
        this.pack();
        Gui.centerShellOverShell(parent, this);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                Wizard.this.doCancel();
            }
        });
        this.btnNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Wizard.this.doNext();
            }
        });
        this.btnPrev.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Wizard.this.doPrevious();
            }
        });
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Wizard.this.doCancel();
            }
        });
        this.btnFinish.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Wizard.this.doFinish();
            }
        });
    }

    @Override
    public void show() {
        if (this.needsLayout) {
            this.needsLayout = false;
            this.pack();
            if (!this.pages.isEmpty()) {
                this.showPage(0);
            }
        }
        super.show();
    }

    private void showPage(int index) {
        if (this.currentPage != -1) {
            WizardPage old = this.getPage(this.currentPage);
            old.onPageLeave();
            old.setVisible(false);
        }
        WizardPage page = this.getPage(index);
        page.onPageEnter();
        page.setVisible(true);
        this.currentPage = index;
        this.updateHeader(page);
        this.updateButtons(page);
        this.validate();
    }

    void updateHeader(WizardPage page) {
        if (!(this.isPostFinish || this.currentPage != -1 && this.getPage(this.currentPage) == page)) {
            return;
        }
        String pageTitle = page.getTitle();
        String pageDesc = page.getMessage();
        if (pageTitle == null) {
            pageTitle = "Step " + this.currentPage;
        }
        if (pageDesc == null) {
            pageDesc = "";
        }
        this.titleLabel.setText(pageTitle);
        this.messageLabel.setText(pageDesc);
        this.messageLabel.setIcon(ResourceLoader.getScaledIcon(page.getMessageIcon(), this.messageLabel.getHeight(), this.messageLabel));
        this.messageLabel.setForeground(page.getMessageColor());
        this.messageLabel.validate();
        this.setTitle(this.getWindowTitle() + " - " + pageTitle);
    }

    public abstract String getWindowTitle();

    protected final void addPage(WizardPage page) {
        this.contentPanel.add(page);
        if (!this.pages.isEmpty()) {
            page.setVisible(false);
        }
        this.pages.add(page);
    }

    protected void addSummaryPage(WizardPage page) {
        this.postFinishPage = page;
    }

    void updateButtons(WizardPage page) {
        if (this.isPostFinish) {
            this.btnFinish.setEnabled(this.postFinishPage.isComplete());
            return;
        }
        boolean canFinish = true;
        for (WizardPage p : this.pages) {
            if (p.isComplete()) continue;
            canFinish = false;
            break;
        }
        this.btnFinish.setEnabled(canFinish);
        if (this.currentPage != -1 && this.getPage(this.currentPage) == page) {
            this.btnNext.setEnabled(this.currentPage + 1 < this.pages.size() && page.isComplete());
            this.btnPrev.setEnabled(this.currentPage > 0 && this.getPage((int)(this.currentPage - 1)).canComeBack);
        }
    }

    protected final boolean isSummaryPage() {
        return this.isPostFinish;
    }

    public final boolean isCancelled() {
        return this.isCancelled;
    }

    public final void doNext() {
        if (this.isPostFinish || !this.btnNext.isEnabled()) {
            return;
        }
        if (this.currentPage + 1 < this.pages.size()) {
            if (!this.getPage(this.currentPage).wantNextOrFinish()) {
                return;
            }
            this.showPage(this.currentPage + 1);
        }
    }

    protected final void doPrevious() {
        if (this.isPostFinish || !this.btnPrev.isEnabled()) {
            return;
        }
        if (this.currentPage > 0) {
            this.showPage(this.currentPage - 1);
        }
    }

    protected final void doCancel() {
        if (this.onCancelRequest()) {
            this.isCancelled = true;
            if (this.currentPage != -1) {
                this.getPage(this.currentPage).onPageLeave();
            }
            if (this.isPostFinish) {
                this.postFinishPage.onPageLeave();
            }
            this.dispose();
        }
    }

    protected final void doFinish() {
        if (this.isPostFinish) {
            this.postFinishPage.onPageLeave();
            this.dispose();
            return;
        }
        if (!this.btnFinish.isEnabled()) {
            return;
        }
        if (this.currentPage != -1 && !this.getPage(this.currentPage).wantNextOrFinish()) {
            return;
        }
        if (this.wantFinish()) {
            if (this.currentPage != -1) {
                this.getPage(this.currentPage).onPageLeave();
            }
            this.postFinishPage = this.performFinish();
            if (this.postFinishPage == null) {
                this.dispose();
            } else {
                this.isPostFinish = true;
                this.btnPrev.setVisible(false);
                this.btnNext.setVisible(false);
                this.btnFinish.setText("Schlie\u00dfen");
                this.postFinishPage.setVisible(false);
                this.contentPanel.add(this.postFinishPage);
                this.showPage(-1);
            }
        }
    }

    private WizardPage getPage(int index) {
        if (this.isPostFinish && index == -1) {
            return this.postFinishPage;
        }
        return this.pages.get(index);
    }

    protected boolean onCancelRequest() {
        return true;
    }

    protected boolean wantFinish() {
        return true;
    }

    protected WizardPage performFinish() {
        return null;
    }
}

