/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.gui.window.layout;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.openslx.bwlp.thrift.iface.Satellite;
import org.openslx.dozmod.gui.helper.GridManager;

public class SatelliteListWindowLayout
extends JDialog {
    protected final JButton btnCancel;
    protected final JButton btnContinue;
    protected final JTextField txtCustomAddress;
    protected final JRadioButton rdoCusomAddress;
    protected final Map<JRadioButton, Satellite> radioToSat = new HashMap<JRadioButton, Satellite>();
    private static String title = "Satellitenserver w\u00e4hlen";

    protected SatelliteListWindowLayout(Window modalParent, List<Satellite> satList) {
        super(modalParent, title, modalParent != null ? Dialog.ModalityType.APPLICATION_MODAL : Dialog.ModalityType.MODELESS);
        JPanel radioPanel = new JPanel();
        radioPanel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        GridManager selectionPanelGrid = new GridManager(radioPanel, 2);
        ButtonGroup btnGroup = new ButtonGroup();
        if (satList != null && !satList.isEmpty()) {
            selectionPanelGrid.add(new JLabel("Vorgegebene Server"), 2);
            selectionPanelGrid.nextRow();
            for (Satellite sat : satList) {
                JRadioButton radioButton = new JRadioButton(sat.getDisplayName());
                radioButton.setEnabled(sat.addressList != null && !sat.addressList.isEmpty());
                this.radioToSat.put(radioButton, sat);
                btnGroup.add(radioButton);
                selectionPanelGrid.add(radioButton, 2).fill(true, false).expand(true, false);
                selectionPanelGrid.nextRow();
            }
        }
        selectionPanelGrid.add(new JLabel("Server-Adresse selbst eingeben"), 2);
        selectionPanelGrid.nextRow();
        this.rdoCusomAddress = new JRadioButton("");
        btnGroup.add(this.rdoCusomAddress);
        this.txtCustomAddress = new JTextField("");
        selectionPanelGrid.add(this.rdoCusomAddress).fill(true, false).expand(false, false);
        selectionPanelGrid.add(this.txtCustomAddress).fill(true, false).expand(true, false);
        selectionPanelGrid.nextRow();
        selectionPanelGrid.finish(false);
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new BoxLayout(buttonPane, 2));
        buttonPane.setBorder(BorderFactory.createEmptyBorder(1, 3, 3, 3));
        this.btnCancel = new JButton("Abbrechen");
        buttonPane.add(this.btnCancel);
        buttonPane.add(Box.createHorizontalGlue());
        this.btnContinue = new JButton("Weiter");
        buttonPane.add(this.btnContinue);
        this.getContentPane().add((Component)radioPanel, "Center");
        this.getContentPane().add((Component)buttonPane, "Last");
        this.pack();
    }
}

