/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.gui.window.layout;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.apache.log4j.Logger;
import org.openslx.dozmod.gui.Gui;
import org.openslx.dozmod.gui.control.ImageListViewer;
import org.openslx.dozmod.gui.control.QLabel;
import org.openslx.dozmod.gui.helper.CompositePage;
import org.openslx.dozmod.gui.helper.GridManager;

public abstract class ImageListWindowLayout
extends CompositePage {
    private static final Logger LOGGER = Logger.getLogger(ImageListWindowLayout.class);
    private static final int ICON_SIZE_Y = 24;
    private final ImageListWindowLayout me = this;
    protected static final String infoTextString = "Hier k\u00f6nnen Sie Virtuelle Maschinen hochladen, herunterladen, bearbeiten und l\u00f6schen.";
    protected static final String infoTitleString = "\u00dcbersicht Virtuelle Maschinen";
    protected static final String newButtonLabel = "Neue VM";
    protected static final String newLectureButtonLabel = "Neue Veranstaltung";
    protected static final String editButtonLabel = "Bearbeiten";
    protected static final String downloadButtonLabel = "Download";
    protected static final String deleteButtonLabel = "L\u00f6schen";
    protected static final String switchViewButtonLabel = "Veranstaltungen zeigen";
    protected static final String showPublishedImagesLabel = "\u00d6ffentliche VMs";
    protected final ImageListViewer ctlImageListViewer;
    protected final JButton btnNewVm;
    protected final JButton btnNewLecture;
    protected final JButton btnEditDetails;
    protected final JButton btnDownload;
    protected final JButton btnDelete;
    protected final JButton btnSwitchView;
    protected final JButton btnShowPublishedImages;

    public ImageListWindowLayout() {
        super(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel infoPanel = new JPanel(new BorderLayout());
        QLabel infoTitle = new QLabel(infoTitleString);
        infoTitle.setFont(infoTitle.getFont().deriveFont(1));
        QLabel infoText = new QLabel(infoTextString);
        infoPanel.add((Component)infoTitle, "North");
        infoPanel.add((Component)infoText, "Center");
        this.ctlImageListViewer = new ImageListViewer(ImageListViewer.FilterType.USABLE);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 2));
        this.btnNewVm = new JButton(newButtonLabel, Gui.getScaledIconResource("/img/new-vm-icon.png", "New VM", 24, buttonPanel));
        this.btnEditDetails = new JButton(editButtonLabel, Gui.getScaledIconResource("/img/edit-icon.png", "Edit VM", 24, buttonPanel));
        this.btnDelete = new JButton(deleteButtonLabel, Gui.getScaledIconResource("/img/delete-icon.png", "Delete VM", 24, buttonPanel));
        this.btnDownload = new JButton(downloadButtonLabel, Gui.getScaledIconResource("/img/download-icon.png", "New VM", 24, buttonPanel));
        this.btnNewLecture = new JButton(newLectureButtonLabel, Gui.getScaledIconResource("/img/new-lecture-icon.png", "New Lecture", 24, buttonPanel));
        this.btnShowPublishedImages = new JButton(showPublishedImagesLabel, Gui.getScaledIconResource("/img/published-vm-icon.png", "Published Lectures", 24, buttonPanel));
        this.btnShowPublishedImages.setVisible(false);
        this.btnSwitchView = new JButton(switchViewButtonLabel, Gui.getScaledIconResource("/img/switch-icon.png", "Switch", 24, buttonPanel));
        buttonPanel.add(this.btnNewVm);
        buttonPanel.add(this.btnEditDetails);
        buttonPanel.add(this.btnDelete);
        buttonPanel.add(Box.createHorizontalStrut(5));
        buttonPanel.add(this.btnDownload);
        buttonPanel.add(Box.createHorizontalStrut(5));
        buttonPanel.add(this.btnNewLecture);
        buttonPanel.add(Box.createHorizontalStrut(5));
        buttonPanel.add(this.btnShowPublishedImages);
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(this.btnSwitchView);
        GridManager grid = new GridManager(this, 1);
        grid.add(infoPanel).fill(true, false).expand(true, false);
        grid.nextRow();
        grid.add(this.ctlImageListViewer).fill(true, true).expand(true, true);
        grid.nextRow();
        grid.add(buttonPanel).fill(true, false).expand(true, false);
        grid.nextRow();
        grid.finish(false);
    }
}

