/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.gui.window;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import org.openslx.dozmod.gui.Gui;
import org.openslx.dozmod.gui.control.JCheckBoxTree;
import org.openslx.dozmod.gui.helper.MessageType;
import org.openslx.dozmod.gui.helper.UiFeedback;
import org.openslx.dozmod.gui.window.LocationInfo;
import org.openslx.dozmod.gui.window.layout.LocationSelectionWindowLayout;
import org.openslx.dozmod.thrift.Session;

public class LocationSelectionWindow
extends LocationSelectionWindowLayout
implements UiFeedback {
    private static final long serialVersionUID = -5898656786160024212L;
    private boolean apply = false;

    public LocationSelectionWindow(Window modalParent, List<Integer> locations, boolean limitToLocations) {
        super(modalParent, locations, limitToLocations);
        this.ctlLocationSelector.setSelectedLocationsAsIds(locations);
        this.ctlLocationSelector.setOnlyInSelection(limitToLocations);
        this.btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LocationSelectionWindow.this.dispose();
            }
        });
        this.btnSaveChanges.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List<Integer> tempIntList = LocationSelectionWindow.this.ctlLocationSelector.getSelectedLocationsAsIds();
                if (tempIntList != null && tempIntList.size() > Session.getSatelliteConfig().maxLocationsPerLecture) {
                    LocationSelectionWindow.this.ctlLocationSelector.setSelectedLocationsAsIds(tempIntList);
                    Gui.showMessageBox("Bitten reduzieren Sie die Anzahl gew\u00e4hlter Orte", MessageType.WARNING, null, null);
                    return;
                }
                LocationSelectionWindow.this.apply = true;
                LocationSelectionWindow.this.dispose();
            }
        });
        this.ctlLocationSelector.addCheckChangeEventListener(new JCheckBoxTree.CheckChangeEventListener(){

            @Override
            public void checkStateChanged(JCheckBoxTree.CheckChangeEvent event) {
                List<Integer> tempIntList = LocationSelectionWindow.this.ctlLocationSelector.getSelectedLocationsAsIds();
                if (tempIntList != null) {
                    if (tempIntList.size() > Session.getSatelliteConfig().maxLocationsPerLecture) {
                        LocationSelectionWindow.this.lblError.setText("Zu viele Orte ausgew\u00e4hlt!");
                    } else {
                        LocationSelectionWindow.this.lblError.setText("");
                    }
                }
            }
        });
        Gui.centerShellOverShell(modalParent, this);
    }

    public LocationInfo runAndReturn() {
        this.setVisible(true);
        if (!this.apply) {
            return null;
        }
        return new LocationInfo(this.ctlLocationSelector.getSelectedLocationsAsIds(), this.ctlLocationSelector.getOnlyInSelection());
    }

    public static LocationInfo open(final Window modalParent, final List<Integer> locations, final boolean limitToLocations) {
        return Gui.syncExec(new Gui.GuiCallable<LocationInfo>(){

            @Override
            public LocationInfo run() {
                return new LocationSelectionWindow(modalParent, locations, limitToLocations).runAndReturn();
            }
        });
    }

    @Override
    public boolean wantConfirmQuit() {
        return false;
    }

    @Override
    public void escapePressed() {
        this.dispose();
    }
}

