/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.gui.helper;

import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import org.apache.log4j.Logger;

public class QFileChooser
extends JFileChooser {
    private static final Logger LOGGER = Logger.getLogger(QFileChooser.class);

    public QFileChooser(String path, boolean dirMode) {
        super(path);
        LookAndFeel old = UIManager.getLookAndFeel();
        if (old == null || !old.getName().toLowerCase().contains("gtk")) {
            old = null;
        } else {
            try {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            }
            catch (Exception e) {
                LOGGER.error("Unable to set cross-platform 'Look and Feel'", e);
            }
        }
        if (old != null) {
            this.updateUI();
            try {
                UIManager.setLookAndFeel(old);
            }
            catch (Exception e) {
                LOGGER.error("Unable to reset 'Look and Feel'", e);
            }
            QFileChooser.refreshUI(this, false);
        }
        this.setFileSelectionMode(dirMode ? 1 : 0);
    }

    private static void refreshUI(JComponent c, boolean includeParent) {
        if (includeParent) {
            c.updateUI();
        }
        for (int i = 0; i < c.getComponentCount(); ++i) {
            Component child = c.getComponent(i);
            if (!(child instanceof JComponent)) continue;
            QFileChooser.refreshUI((JComponent)child, true);
        }
    }
}

