/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.gui.helper;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.border.EmptyBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LoggingEvent;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.openslx.dozmod.gui.Gui;

public class DebugWindow
extends JPanel {
    private static final DateTimeFormatter formatter = DateTimeFormat.forPattern("HH:mm:ss");
    private final JTextPane txtLog;

    public DebugWindow() {
        this.setLayout(new BorderLayout());
        this.txtLog = new JTextPane();
        this.txtLog.setEditable(false);
        this.txtLog.setBackground(Color.WHITE);
        this.txtLog.setForeground(Color.BLACK);
        this.txtLog.setBorder(new EmptyBorder(new Insets(5, 5, 5, 5)));
        JScrollPane sp = new JScrollPane(this.txtLog, 22, 31);
        sp.setBorder(BorderFactory.createBevelBorder(1));
        this.add((Component)sp, "Center");
        this.registerLogger();
        this.validate();
    }

    private void registerLogger() {
        AppenderSkeleton appender = new AppenderSkeleton(){

            @Override
            public boolean requiresLayout() {
                return false;
            }

            @Override
            public void close() {
            }

            @Override
            protected void append(final LoggingEvent event) {
                Level l = event.getLevel();
                final Color c = l.isGreaterOrEqual(Priority.ERROR) ? Color.RED : (l.isGreaterOrEqual(Priority.WARN) ? Color.ORANGE : (l.isGreaterOrEqual(Priority.INFO) ? Color.BLACK : Color.GRAY));
                Gui.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        DebugWindow.this.log("[" + formatter.print(event.getTimeStamp()) + "] ", Color.BLACK);
                        DebugWindow.this.log(event.getThreadName() + "@" + event.getLoggerName().replaceAll("^.*\\.", ""), Color.GRAY);
                        DebugWindow.this.log("  " + event.getMessage() + "\n", c);
                    }
                });
            }
        };
        BasicConfigurator.configure(appender);
    }

    private void log(String msg, Color c) {
        StyledDocument doc = this.txtLog.getStyledDocument();
        SimpleAttributeSet keyWord = new SimpleAttributeSet();
        StyleConstants.setForeground(keyWord, c);
        try {
            doc.insertString(doc.getLength(), msg, keyWord);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        this.txtLog.setCaretPosition(doc.getLength());
    }
}

