/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.gui.control.table;

import java.util.Comparator;
import javax.swing.Icon;
import org.openslx.bwlp.thrift.iface.ImageSummaryRead;
import org.openslx.dozmod.gui.Gui;
import org.openslx.dozmod.gui.control.table.ListTable;
import org.openslx.dozmod.thrift.Sorters;
import org.openslx.dozmod.thrift.cache.MetaDataCache;
import org.openslx.dozmod.thrift.cache.UserCache;
import org.openslx.dozmod.util.FormatHelper;

public class ImageTable
extends ListTable<ImageSummaryRead> {
    public static final ListTable.ListTableColumn COL_TEMPLATE = new ListTable.ListTableColumn("Vorlage", Boolean.class);
    public static final ListTable.ListTableColumn COL_USABLE = new ListTable.ListTableColumn("Verwendbar", Boolean.class);
    public static final ListTable.ListTableColumn COL_SIZE = new ListTable.ListTableColumn("Gr\u00f6\u00dfe", Long.class);
    public static final ListTable.ListTableColumn COL_LASTCHANGE = new ListTable.ListTableColumn("Ge\u00e4ndert", Long.class);
    public static final ListTable.ListTableColumn COL_EXPIRING = new ListTable.ListTableColumn("Ablaufdatum", Long.class);
    public static final ListTable.ListTableColumn COL_OWNER = new ListTable.ListTableColumn("Besitzer", Sorters.userNameById);
    public static final ListTable.ListTableColumn COL_OS = new ListTable.ListTableColumn("OS", Integer.class, Sorters.osNameById);
    public static final ListTable.ListTableColumn COL_NAME = new ListTable.ListTableColumn("Name");
    public static final ListTable.ListTableColumn COL_HYPERVISOR = new ListTable.ListTableColumn("", Icon.class);
    public static final ListTable.ListTableColumn COL_VERSIONCOUNT = new ListTable.ListTableColumn("Versionen", Integer.class);
    public static final ListTable.ListTableColumn COL_TOTALSIZE = new ListTable.ListTableColumn("Gesamtgr\u00f6\u00dfe", Long.class);

    public ImageTable() {
        super(new Comparator<ImageSummaryRead>(){

            @Override
            public int compare(ImageSummaryRead o1, ImageSummaryRead o2) {
                if (o1 == null && o2 == null) {
                    return 0;
                }
                if (o1 == null) {
                    return 1;
                }
                if (o2 == null) {
                    return -1;
                }
                return o1.imageBaseId.compareTo(o2.imageBaseId);
            }
        }, COL_NAME, COL_OS, COL_OWNER, COL_LASTCHANGE, COL_EXPIRING, COL_SIZE, COL_USABLE, COL_TEMPLATE, COL_HYPERVISOR, COL_VERSIONCOUNT, COL_TOTALSIZE);
    }

    @Override
    protected Object getValueAtInternal(ImageSummaryRead row, ListTable.ListTableColumn column) {
        if (column == COL_NAME) {
            return row.getImageName();
        }
        if (column == COL_OS) {
            return row.getOsId();
        }
        if (column == COL_OWNER) {
            return row.getOwnerId();
        }
        if (column == COL_LASTCHANGE) {
            return row.getUpdateTime();
        }
        if (column == COL_EXPIRING) {
            return row.getExpireTime();
        }
        if (column == COL_SIZE) {
            return row.getFileSize();
        }
        if (column == COL_USABLE) {
            return row.isIsValid();
        }
        if (column == COL_TEMPLATE) {
            return row.isIsTemplate();
        }
        if (column == COL_HYPERVISOR) {
            return row.getVirtId();
        }
        if (column == COL_VERSIONCOUNT) {
            return row.getVersionCount();
        }
        if (column == COL_TOTALSIZE) {
            return row.getFileSizeSum();
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public Object modelValueToDisplayFormat(Object value, ListTable.ListTableColumn column) {
        if (column == COL_NAME || column == COL_USABLE || column == COL_TEMPLATE || column == COL_VERSIONCOUNT) {
            return value;
        }
        if (column == COL_OS) {
            return FormatHelper.osName(MetaDataCache.getOsById((int)((Integer)value), true));
        }
        if (column == COL_OWNER) {
            return FormatHelper.userName(UserCache.find((String)value));
        }
        if (column == COL_LASTCHANGE || column == COL_EXPIRING) {
            return FormatHelper.shortDate((Long)value);
        }
        if (column == COL_SIZE || column == COL_TOTALSIZE) {
            return FormatHelper.bytes((Long)value, false);
        }
        if (column == COL_HYPERVISOR) {
            return Gui.getScaledIconResource("/img/" + value + "-icon.png", "Virtualizer Icon", this.getRowHeight(), this);
        }
        throw new IndexOutOfBoundsException();
    }
}

