/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.gui.control.table;

import java.util.Comparator;
import org.openslx.bwlp.thrift.iface.ImageSummaryRead;
import org.openslx.bwlp.thrift.iface.UserInfo;
import org.openslx.dozmod.gui.control.table.ListTable;
import org.openslx.dozmod.thrift.Sorters;
import org.openslx.dozmod.thrift.cache.MetaDataCache;
import org.openslx.dozmod.thrift.cache.OrganizationCache;
import org.openslx.dozmod.thrift.cache.UserCache;
import org.openslx.dozmod.util.FormatHelper;

public class ImagePublishedTable
extends ListTable<ImageSummaryRead> {
    public static final ListTable.ListTableColumn COL_NAME = new ListTable.ListTableColumn("Name");
    public static final ListTable.ListTableColumn COL_OS = new ListTable.ListTableColumn("OS", Integer.class, Sorters.osNameById);
    public static final ListTable.ListTableColumn COL_OWNER = new ListTable.ListTableColumn("Besitzer", Sorters.userNameById);
    public static final ListTable.ListTableColumn COL_UPLOADER = new ListTable.ListTableColumn("Hochgeladen von", Sorters.userNameById);
    public static final ListTable.ListTableColumn COL_ORG = new ListTable.ListTableColumn("Organisation");

    public ImagePublishedTable() {
        super(new Comparator<ImageSummaryRead>(){

            @Override
            public int compare(ImageSummaryRead o1, ImageSummaryRead o2) {
                if (o1 == null && o2 == null) {
                    return 0;
                }
                if (o1 == null) {
                    return 1;
                }
                if (o2 == null) {
                    return -1;
                }
                return o1.imageBaseId.compareTo(o2.imageBaseId);
            }
        }, COL_NAME, COL_OS, COL_OWNER, COL_UPLOADER, COL_ORG);
    }

    @Override
    protected Object getValueAtInternal(ImageSummaryRead row, ListTable.ListTableColumn column) {
        if (column == COL_NAME) {
            return row.getImageName();
        }
        if (column == COL_OS) {
            return row.getOsId();
        }
        if (column == COL_OWNER) {
            return row.getOwnerId();
        }
        if (column == COL_UPLOADER) {
            return row.getUploaderId();
        }
        if (column == COL_ORG) {
            UserInfo user = UserCache.find(row.getOwnerId());
            if (user != null) {
                return user.getOrganizationId();
            }
            return null;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public Object modelValueToDisplayFormat(Object value, ListTable.ListTableColumn column) {
        if (column == COL_NAME) {
            return value;
        }
        if (column == COL_OS) {
            return FormatHelper.osName(MetaDataCache.getOsById((int)((Integer)value), true));
        }
        if (column == COL_OWNER || column == COL_UPLOADER) {
            return FormatHelper.userName(UserCache.find((String)value));
        }
        if (column == COL_ORG) {
            return FormatHelper.orgName(OrganizationCache.find((String)value));
        }
        throw new IndexOutOfBoundsException();
    }
}

