/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.gui.control;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import javax.swing.JPanel;
import org.openslx.dozmod.gui.Gui;
import org.openslx.thrifthelper.TransferStatusWrapper;

public class BlockProgressBar
extends JPanel {
    private final Color[] blockColors = new Color[6];
    private static final Color potentialCompleteColor = new Color(215, 230, 255, 255);
    private final TransferStatusWrapper blocks = new TransferStatusWrapper(null);
    private final TransferStatusWrapper.Progress progress = new TransferStatusWrapper.Progress();
    private boolean simpleMode = true;
    private boolean showEstimatedComplete = false;

    public BlockProgressBar(byte[] blocks) {
        this.setPreferredSize(Gui.getScaledDimension(100, 32));
        this.setupListeners();
        this.blockColors[0] = Color.BLACK;
        this.blockColors[1] = Color.RED;
        this.blockColors[2] = Color.YELLOW;
        this.blockColors[3] = Color.BLUE;
        this.blockColors[4] = Color.GREEN;
        this.blockColors[5] = Color.YELLOW.darker();
        this.blocks.setBlocks(blocks);
    }

    public void setStatus(byte[] blocks) {
        this.blocks.setBlocks(blocks);
        this.repaint(100L);
    }

    private void setupListeners() {
        final BlockProgressBar me = this;
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    me.toggleMode();
                }
            }
        });
    }

    private void toggleMode() {
        this.simpleMode = !this.simpleMode;
        this.repaint(100L);
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.blocks.isEmpty()) {
            g.setColor(Color.WHITE);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        } else if (this.simpleMode) {
            this.drawSimple(g);
        } else {
            this.drawDetailed(g);
        }
    }

    private void drawSimple(Graphics g) {
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        int width = this.getWidth();
        int height = this.getHeight();
        this.blocks.getCompleteEx(this.progress);
        int doneWidth = (int)((float)width * this.progress.done);
        int potentialWidth = (int)((float)width * this.progress.potentiallyDone);
        int sumWidth = doneWidth;
        g.setColor(Color.BLUE);
        g.fillRect(0, 0, doneWidth, height);
        if (this.showEstimatedComplete) {
            g.setColor(potentialCompleteColor);
            g.fillRect(doneWidth, 0, potentialWidth, height);
            sumWidth += potentialWidth;
        }
        g.setColor(Color.WHITE);
        g.fillRect(sumWidth, 0, width - sumWidth, height);
        String percentDisplay = (int)(this.progress.done * 100.0f) + "%";
        Rectangle2D textExtent = g.getFontMetrics().getStringBounds(percentDisplay, g);
        double tw = textExtent.getWidth();
        int textX = (int)(((double)width - tw) / 2.0);
        int textXEnd = (int)(((double)width + tw) / 2.0);
        int textY = (int)(((double)height + textExtent.getHeight()) / 2.0);
        if (doneWidth >= textX) {
            g.setColor(Color.WHITE);
            g.setClip(0, 0, doneWidth, height);
            g.drawString(percentDisplay, textX, textY);
        }
        if (doneWidth <= textXEnd) {
            g.setColor(Color.BLACK);
            g.setClip(doneWidth, 0, width - doneWidth, height);
            g.drawString(percentDisplay, textX, textY);
        }
    }

    private void drawDetailed(Graphics g) {
        float blockHeightVisible;
        float blockHeight;
        int blockCount = this.blocks.getBlockCount();
        int height = this.getHeight();
        float width = this.getWidth() - 2;
        float blockWidth = width / (float)blockCount;
        int rows = 1;
        while (blockWidth * (float)rows < 6.0f && (float)height / (float)rows > 7.0f) {
            ++rows;
        }
        blockWidth *= (float)rows;
        if (rows == 1) {
            blockHeightVisible = blockHeight = (float)height;
        } else {
            blockHeight = (height + 2) / rows;
            blockHeightVisible = blockHeight - 2.0f;
        }
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        float x = 0.0f;
        float y = 0.0f;
        for (byte block : this.blocks.getBlocks()) {
            float toX = x + blockWidth;
            if (block >= 0 && block < this.blockColors.length) {
                g.setColor(this.blockColors[block]);
                int boxWidth = (int)toX - (int)x - 1;
                int boxHeight = (int)(y + blockHeightVisible) - (int)y;
                g.fillRect((int)x, (int)y, boxWidth > 1 ? boxWidth : 1, boxHeight > 1 ? boxHeight : 1);
            }
            if (!((double)(x = toX) + 0.5 > (double)width)) continue;
            x = 0.0f;
            y += blockHeight;
        }
    }

    public void showOptimisticComplete(boolean b) {
        this.showEstimatedComplete = b;
    }
}

