/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.openslx.dozmod.Branding;
import org.openslx.dozmod.util.OsHelper;
import org.openslx.util.QuickTimer;
import org.openslx.util.Util;

public class Config {
    private static final Logger LOGGER = Logger.getLogger(Config.class);
    public static final int TRANSFER_TIMEOUT = 20000;
    public static final int FONT_SCALING_MIN = 75;
    public static final int FONT_SCALING_MAX = 175;
    private static final Properties prop = new Properties();
    private static ErrorCallback errorCb = null;
    private static File configFile = null;
    private static boolean writePending = false;

    public static void init() throws IOException {
        String configPath = null;
        String osName = System.getProperty("os.name").toLowerCase();
        LOGGER.info("Machine's OS: " + osName);
        if (OsHelper.isWindows()) {
            String appDataPath = System.getenv("APPDATA");
            if (!appDataPath.isEmpty()) {
                configPath = appDataPath;
            } else {
                LOGGER.warn("APPDATA is empty.");
                configPath = System.getProperty("user.home") + "\\AppData\\Roaming";
            }
        } else if (OsHelper.isLinux()) {
            configPath = System.getProperty("user.home") + "/.config";
        }
        if (configPath == null || configPath.isEmpty()) {
            configPath = ".";
        }
        if (!(configFile = new File(configPath + File.separatorChar + Branding.getConfigDirectory() + File.separatorChar + "config.properties").getAbsoluteFile()).getParentFile().exists()) {
            LOGGER.info("Folder " + configFile.getParentFile() + " does not exist, creating it.");
            if (!configFile.getParentFile().mkdirs()) {
                throw new IOException("Could not create '" + configFile.getParentFile() + "'.");
            }
        }
        if (!configFile.exists()) {
            Config.forceSaveInternal();
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                Config.forceSave();
            }
        });
        try (FileInputStream in = new FileInputStream(configFile);){
            prop.load(in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void forceSaveInternal() throws FileNotFoundException, IOException {
        Properties properties = prop;
        synchronized (properties) {
            prop.store(new FileOutputStream(configFile), Branding.getServiceName() + " Dozentenmodul Client Config");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean forceSave() {
        Properties properties = prop;
        synchronized (properties) {
            if (!writePending) {
                return true;
            }
            writePending = false;
            if (configFile == null) {
                return false;
            }
            try {
                Config.forceSaveInternal();
                return true;
            }
            catch (Exception e) {
                if (errorCb != null) {
                    errorCb.writeError(e);
                }
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void queueSave() {
        Properties properties = prop;
        synchronized (properties) {
            if (writePending) {
                return;
            }
            writePending = true;
            QuickTimer.scheduleOnce(new QuickTimer.Task(){

                @Override
                public void fire() {
                    Config.forceSave();
                }
            }, 1000L);
        }
    }

    public static void setErrorCallback(ErrorCallback cb) {
        errorCb = cb;
    }

    public static String getPath() {
        return configFile.getParent();
    }

    public static String getDisclaimerAgreement() {
        return Config.getString("disclaimer.accepted_version", "");
    }

    public static void setDisclaimerAgreement(String value) {
        Config.setString("disclaimer.accepted_version", value);
    }

    public static String getPrivacyAgreement() {
        return Config.getString("privacy.accepted_version", "");
    }

    public static void setPrivacyAgreement(String value) {
        Config.setString("privacy.accepted_version", value);
    }

    public static boolean getVirtualizerRead() {
        return Config.getBoolean("notice.virtualizer", false);
    }

    public static void setVirtualizerRead(boolean selection) {
        Config.setBoolean("notice.virtualizer", selection);
    }

    public static String getUsername() {
        return Config.getString("login.name", "");
    }

    public static void setUsername(String value) {
        Config.setString("login.name", value);
    }

    public static String getDownloadPath() {
        return Config.getString("download.path", System.getProperty("user.home"));
    }

    public static void setDownloadPath(String value) {
        Config.setString("download.path", value);
    }

    public static String getUploadPath() {
        return Config.getString("upload.path", System.getProperty("user.home"));
    }

    public static void setUploadPath(String value) {
        Config.setString("upload.path", value);
    }

    public static String getIdentityProvider() {
        return Config.getString("login.idp", "");
    }

    public static void setIdentityProvider(String value) {
        Config.setString("login.idp", value);
    }

    public static String getAuthenticationMethod() {
        return Config.getString("login.method", "ECP");
    }

    public static void setAuthenticationMethod(String value) {
        Config.setString("login.method", value);
    }

    public static void saveCurrentSession(String satAddress, String satToken, String masterToken) {
        Config.setString("session.address", satAddress);
        Config.setString("session.token", satToken);
        Config.setString("session.mastertoken", masterToken);
    }

    public static SavedSession getSavedSession() {
        SavedSession session = new SavedSession(Config.getString("session.address", ""), Config.getString("session.token", ""), Config.getString("session.mastertoken", ""));
        if (session.token.isEmpty() || session.address.isEmpty() || session.masterToken.isEmpty()) {
            return null;
        }
        return session;
    }

    public static void setLastSatellite(String value) {
        Config.setString("session.last-satellite", value);
    }

    public static String getLastSatellite() {
        return Config.getString("session.last-satellite", "");
    }

    public static void setFontScaling(int percent) {
        Config.setInteger("gui.fontscaling", percent);
    }

    public static int getFontScaling() {
        int savedFontScaling = Config.getInteger("gui.fontscaling", 100);
        if (savedFontScaling < 75 || savedFontScaling > 175) {
            Config.setFontScaling(100);
            return 100;
        }
        return savedFontScaling;
    }

    public static void setTransferConnectionCount(int count) {
        Config.setInteger("transfer.connections-per-transfer", count);
    }

    public static int getTransferConnectionCount() {
        int count = Config.getInteger("transfer.connections-per-transfer", 1);
        if (count < 1 || count > 4) {
            count = 4;
        }
        return count;
    }

    public static void setProxyMode(ProxyMode mode) {
        Config.setString("proxy.mode", mode.toString());
    }

    public static ProxyMode getProxyMode() {
        try {
            return ProxyMode.valueOf(Config.getString("proxy.mode", Branding.getProxyMode()));
        }
        catch (Exception e) {
            return ProxyMode.AUTO;
        }
    }

    public static void setLookAndFeel(String value) {
        Config.setString("gui.lookandfeel", value);
    }

    public static String getLookAndFeel() {
        return Config.getString("gui.lookandfeel", null);
    }

    private static boolean getBoolean(String key, boolean defaultValue) {
        return Boolean.parseBoolean(prop.getProperty(key, Boolean.toString(defaultValue)));
    }

    private static void setBoolean(String key, boolean value) {
        prop.setProperty(key, Boolean.toString(value));
        Config.queueSave();
    }

    private static int getInteger(String key, int defaultValue) {
        return Util.parseInt(prop.getProperty(key), defaultValue);
    }

    private static void setInteger(String key, int value) {
        prop.setProperty(key, Integer.toString(value));
        Config.queueSave();
    }

    private static String getString(String key, String defaultValue) {
        return prop.getProperty(key, defaultValue);
    }

    private static void setString(String key, String value) {
        prop.setProperty(key, value);
        Config.queueSave();
    }

    public static enum ProxyMode {
        NONE,
        AUTO,
        SOCKS,
        HTTP_CONNECT;

    }

    public static class SavedSession {
        public final String address;
        public final String token;
        public final String masterToken;

        public SavedSession(String address, String token, String masterToken) {
            this.address = address;
            this.token = token;
            this.masterToken = masterToken;
        }
    }

    public static interface ErrorCallback {
        public void writeError(Throwable var1);
    }
}

