/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.thrift.cache;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.thrift.TException;
import org.openslx.bwlp.thrift.iface.UserInfo;
import org.openslx.dozmod.thrift.Session;
import org.openslx.thrifthelper.ThriftManager;
import org.openslx.util.GenericDataCache;

public class UserCache {
    private static final Logger LOGGER = Logger.getLogger(UserCache.class);
    private static final int CACHE_TIME_MS = 300000;
    private static final GenericDataCache<List<UserInfo>> cache = new GenericDataCache<List<UserInfo>>(300000){

        @Override
        protected List<UserInfo> update() throws Exception {
            List<UserInfo> result = null;
            int pageSize = Session.getSatelliteConfig().pageSize;
            int i = 0;
            while (true) {
                List<UserInfo> page = ThriftManager.getSatClient().getUserList(Session.getSatelliteToken(), i);
                if (result == null) {
                    result = page;
                } else {
                    result.addAll(page);
                }
                if (page.size() < pageSize) break;
                ++i;
            }
            if (result != null) {
                result = Collections.unmodifiableList(result);
            }
            return result;
        }
    };
    private static final Map<String, UserInfo> cachedUserFromMaster = new HashMap<String, UserInfo>();

    private UserCache() {
    }

    public static List<UserInfo> getAll() {
        return cache.get();
    }

    public static UserInfo find(String userId) {
        List<UserInfo> list = cache.get(GenericDataCache.CacheMode.PREFER_CACHED);
        UserInfo user = UserCache.find(userId, list);
        if (user != null) {
            return user;
        }
        if (cachedUserFromMaster.containsKey(userId)) {
            return cachedUserFromMaster.get(userId);
        }
        List<UserInfo> newList = cache.get(GenericDataCache.CacheMode.DEFAULT);
        if (list != newList) {
            user = UserCache.find(userId, newList);
        }
        if (user == null) {
            try {
                user = ThriftManager.getMasterClient().getUser(Session.getMasterToken(), userId);
            }
            catch (TException e) {
                LOGGER.error("User with ID '" + userId + "' not found on the masterserver.", e);
                return null;
            }
            if (user != null) {
                cachedUserFromMaster.put(userId, user);
            }
        }
        return user;
    }

    private static UserInfo find(String userId, List<UserInfo> list) {
        if (list != null) {
            for (UserInfo user : list) {
                if (!user.userId.equals(userId)) continue;
                return user;
            }
        }
        return null;
    }
}

