/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.thrift;

import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.thrift.TException;
import org.openslx.bwlp.thrift.iface.ImagePermissions;
import org.openslx.bwlp.thrift.iface.LecturePermissions;
import org.openslx.bwlp.thrift.iface.SatelliteConfig;
import org.openslx.bwlp.thrift.iface.WhoamiInfo;
import org.openslx.sat.thrift.version.Feature;
import org.openslx.thrifthelper.ThriftManager;

public class Session {
    private static final Logger LOGGER = Logger.getLogger(Session.class);
    private static WhoamiInfo data = null;
    private static String satelliteAddress = null;
    private static String satelliteToken = null;
    private static String masterToken = null;
    private static long satelliteApiVersion = -1L;
    private static SatelliteConfig satConf = null;
    private static Set<Feature> features = null;

    public static synchronized void initialize(WhoamiInfo whoami2, String satAddress, String satToken, String masToken, long satApiVersion) {
        if (whoami2 == null || whoami2.user == null || whoami2.user.userId == null) {
            throw new IllegalArgumentException("Cannot initialize session: whoami-Information from satellite incomplete");
        }
        if (data != null && !Session.data.user.userId.equals(whoami2.user.userId)) {
            throw new IllegalArgumentException("Cannot set new session data with different user id");
        }
        if (satelliteAddress != null && !satelliteAddress.equals(satAddress)) {
            throw new IllegalArgumentException("Cannot set new session data with different satellite address");
        }
        data = whoami2;
        masterToken = masToken;
        satelliteToken = satToken;
        satelliteAddress = satAddress;
        satelliteApiVersion = satApiVersion;
    }

    public static String getFirstName() {
        if (data == null) {
            return null;
        }
        return Session.data.user.firstName;
    }

    public static String getLastName() {
        if (data == null) {
            return null;
        }
        return Session.data.user.lastName;
    }

    public static String getEMail() {
        if (data == null) {
            return null;
        }
        return Session.data.user.eMail;
    }

    public static String getUserId() {
        if (data == null) {
            return null;
        }
        return Session.data.user.userId;
    }

    public static String getOrganizationId() {
        if (data == null) {
            return null;
        }
        return Session.data.user.organizationId;
    }

    public static boolean isSuperUser() {
        if (data == null) {
            return false;
        }
        return Session.data.isSuperUser;
    }

    public static boolean canListImages() {
        if (data == null) {
            return false;
        }
        return Session.data.canListImages;
    }

    public static String getSatelliteToken() {
        return satelliteToken;
    }

    public static String getMasterToken() {
        return masterToken;
    }

    public static String getSatelliteAddress() {
        return satelliteAddress;
    }

    public static long getSatApiVersion() {
        return satelliteApiVersion;
    }

    public static boolean isImagePublishSupported() {
        return satelliteApiVersion >= 3L;
    }

    public static boolean isLectureRestrictionsSupported() {
        return satelliteApiVersion >= 4L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SatelliteConfig getSatelliteConfig() {
        Class<SatelliteConfig> clazz = SatelliteConfig.class;
        synchronized (SatelliteConfig.class) {
            if (satConf != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return satConf;
            }
            try {
                satConf = ThriftManager.getSatClient().getConfiguration();
                // ** MonitorExit[var0] (shouldn't be in output)
                return satConf;
            }
            catch (TException e) {
                LOGGER.warn("Could not get satellite configuration, falling back to builtin defaults", e);
                SatelliteConfig satConfig = new SatelliteConfig();
                satConfig.setDefaultImagePermissions(new ImagePermissions(true, true, false, false));
                satConfig.setDefaultLecturePermissions(new LecturePermissions(false, false));
                satConfig.setMaxImageValidityDays(200);
                satConfig.setMaxLectureValidityDays(100);
                satConfig.setPageSize(200);
                // ** MonitorExit[var0] (shouldn't be in output)
                return satConfig;
            }
        }
    }

    public static boolean canExtendImageExpiry() {
        return Session.isSuperUser() && satelliteApiVersion >= 3L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasFeature(Feature feature) {
        Class<Feature> clazz = Feature.class;
        synchronized (Feature.class) {
            if (features == null) {
                String ret;
                try {
                    ret = ThriftManager.getSatClient().getSupportedFeatures();
                }
                catch (TException e) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return false;
                }
                if (ret == null) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return false;
                }
                features = new HashSet<Feature>();
                for (String f : ret.split(" ")) {
                    try {
                        features.add(Feature.valueOf(f));
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return features.contains((Object)feature);
        }
    }
}

