/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.gui.wizard.page;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;
import org.openslx.dozmod.gui.helper.DateTimeHelper;
import org.openslx.dozmod.gui.helper.TextChangeListener;
import org.openslx.dozmod.gui.wizard.Wizard;
import org.openslx.dozmod.gui.wizard.layout.LectureCreationPageLayout;
import org.openslx.dozmod.state.LectureWizardState;
import org.openslx.dozmod.thrift.Session;
import org.openslx.dozmod.util.FormatHelper;

public class LectureCreationPage
extends LectureCreationPageLayout {
    private static final Logger LOGGER = Logger.getLogger(LectureCreationPage.class);
    private LectureWizardState state = null;

    public LectureCreationPage(Wizard wizard, LectureWizardState state) {
        super(wizard, state.image != null ? state.image.imageName : "Neu");
        this.state = state;
        TextChangeListener docListener = new TextChangeListener(){

            @Override
            public void changed() {
                LectureCreationPage.this.reactToUserInput();
            }
        };
        this.txtName.getDocument().addDocumentListener(docListener);
        this.txtDescription.getDocument().addDocumentListener(docListener);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LectureCreationPage.this.reactToUserInput();
            }
        };
        ChangeListener changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                LectureCreationPage.this.reactToUserInput();
            }
        };
        this.spnStartTime.addChangeListener(changeListener);
        this.spnEndTime.addChangeListener(changeListener);
        this.dtpStartDate.addActionListener(actionListener);
        this.dtpEndDate.addActionListener(actionListener);
        this.calculateDatePeriod();
    }

    @Override
    protected boolean wantNextOrFinish() {
        return this.reactToUserInput();
    }

    private boolean reactToUserInput() {
        boolean b = this.isPageValid();
        this.calculateDatePeriod();
        this.setPageComplete(b);
        return b;
    }

    private void calculateDatePeriod() {
        Date start = DateTimeHelper.getDateFrom(this.dtpStartDate, this.spnStartTime);
        Date end = DateTimeHelper.getDateFrom(this.dtpEndDate, this.spnEndTime);
        if (end.before(start)) {
            this.lblCalcPeriod.setText("Endzeitpunkt ist vor Startzeitpunkt!");
        } else {
            int numberOfDays = DateTimeHelper.calculatePeriodInDays(start, end);
            this.lblCalcPeriod.setText(numberOfDays + "Tag(e)");
            this.lblCalcPeriod.setForeground(numberOfDays < 7 ? Color.RED : null);
        }
    }

    private boolean isPageValid() {
        Date end;
        if (this.txtName.getText().isEmpty()) {
            this.setWarningMessage("Geben Sie einen Veranstaltungsnamen ein.");
            return false;
        }
        this.state.name = this.txtName.getText();
        if (this.txtDescription.getText().isEmpty()) {
            this.setWarningMessage("F\u00fcgen Sie eine Beschreibung hinzu.");
            return false;
        }
        this.state.description = this.txtDescription.getText();
        Date now = new Date();
        Date start = DateTimeHelper.getDateFrom(this.dtpStartDate, this.spnStartTime);
        if (start.after(end = DateTimeHelper.getDateFrom(this.dtpEndDate, this.spnEndTime))) {
            this.setWarningMessage("Startzeit ist nach Endzeit!");
            return false;
        }
        if (now.after(end)) {
            this.setWarningMessage("Endzeit liegt in die Vergangenheit!");
            return false;
        }
        int validityPeriod = Session.getSatelliteConfig().getMaxLectureValidityDays();
        Date validityPeriodEnd = DateTimeHelper.addDaysTo(start, validityPeriod);
        if (end.after(validityPeriodEnd)) {
            this.setWarningMessage("Endzeit liegt nach dem sp\u00e4test m\u00f6glichen Datum: " + FormatHelper.shortDate(validityPeriodEnd.getTime() / 1000L));
            return false;
        }
        this.state.start = start;
        this.state.end = end;
        String nextText = this.state.image == null ? ", um eine Virtuelle Maschine auszuw\u00e4hlen" : " f\u00fcr Berechtigungen oder 'Fertigstellen'.";
        this.setDescription("Klicken Sie auf 'Weiter' " + nextText);
        return true;
    }
}

