/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.gui.window;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JFrame;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.openslx.bwlp.thrift.iface.Organization;
import org.openslx.bwlp.thrift.iface.Satellite;
import org.openslx.dozmod.App;
import org.openslx.dozmod.Config;
import org.openslx.dozmod.authentication.Authenticator;
import org.openslx.dozmod.authentication.EcpAuthenticator;
import org.openslx.dozmod.authentication.FingerprintManager;
import org.openslx.dozmod.authentication.ShibbolethEcp;
import org.openslx.dozmod.authentication.TestAccountAuthenticator;
import org.openslx.dozmod.gui.Gui;
import org.openslx.dozmod.gui.MainWindow;
import org.openslx.dozmod.gui.helper.MessageType;
import org.openslx.dozmod.gui.helper.TextChangeListener;
import org.openslx.dozmod.gui.window.BwIdmLinkWindow;
import org.openslx.dozmod.gui.window.ConfigWindow;
import org.openslx.dozmod.gui.window.layout.LoginWindowLayout;
import org.openslx.dozmod.thrift.Session;
import org.openslx.dozmod.thrift.ThriftActions;
import org.openslx.dozmod.thrift.ThriftError;
import org.openslx.dozmod.thrift.cache.OrganizationCache;
import org.openslx.dozmod.util.DesktopEnvironment;
import org.openslx.util.QuickTimer;

public class LoginWindow
extends LoginWindowLayout {
    private static final Logger LOGGER = Logger.getLogger(LoginWindow.class);
    protected LoginType loginType = null;
    private final String NO_USERNAME = "Kein Benutzername angegeben!";
    private final String NO_PASSWORD = "Kein Passwort angegeben!";
    private boolean forceCustomSatellite = false;

    public LoginWindow(Frame modalParent) {
        super(modalParent);
        LoginType savedLoginType;
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Gui.exit(0);
            }
        });
        for (final LoginType type : LoginType.values()) {
            this.rdoLoginType[type.id].setActionCommand(type.toString());
            this.rdoLoginType[type.id].addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        LoginWindow.this.cboOrganization.setEnabled(LoginWindow.this.cboOrganization.getModel().getSize() != 0 && type == LoginType.ECP);
                        LoginWindow.this.loginType = type;
                        LoginWindow.this.btnOpenRegistration.setEnabled(type == LoginType.ECP);
                    }
                }
            });
        }
        String savedAuthMethod = Config.getAuthenticationMethod();
        try {
            savedLoginType = LoginType.valueOf(savedAuthMethod);
        }
        catch (Exception e) {
            savedLoginType = LoginType.ECP;
        }
        if (savedLoginType == LoginType.ECP) {
            this.enableLogin(false);
        }
        this.cboOrganization.setEnabled(false);
        this.rdoLoginType[LoginType.DIRECT_CONNECT.id].setEnabled(false);
        this.rdoLoginType[savedLoginType.id].setSelected(true);
        this.loginType = savedLoginType;
        QuickTimer.scheduleOnce(new QuickTimer.Task(){
            List<Organization> orgs = null;

            @Override
            public void fire() {
                try {
                    App.waitForInit();
                    this.orgs = OrganizationCache.getAll();
                }
                catch (Exception e) {
                    LOGGER.error("Error during execution: ", e);
                }
                Iterator<Organization> iterator = this.orgs.iterator();
                while (iterator.hasNext()) {
                    Organization current = iterator.next();
                    if (current != null && current.isSetEcpUrl() && !current.getEcpUrl().isEmpty()) continue;
                    iterator.remove();
                }
                Gui.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        LoginWindow.this.populateIdpCombo(orgs);
                        LoginWindow.this.enableLogin(true);
                    }
                });
            }
        });
        this.btnLogin.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int mods = e.getModifiers();
                LoginWindow.this.forceCustomSatellite = (mods & 1) == 1;
                LoginWindow.this.doLogin();
            }
        });
        this.btnOpenRegistration.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DesktopEnvironment.openWebpage(DesktopEnvironment.Link.REGISTER_BWIDM);
            }
        });
        this.pnlLoginForm.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "login");
        this.pnlLoginForm.getActionMap().put("login", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                LoginWindow.this.btnLogin.doClick();
            }
        });
        this.btnSettings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigWindow.open(LoginWindow.this);
            }
        });
        this.btnLogDir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DesktopEnvironment.openLocal(new File(Config.getPath()));
            }
        });
        this.txtUsername.getDocument().addDocumentListener(new TextChangeListener(){

            @Override
            public void changed() {
                if (LoginWindow.this.cboOrganization.getSelectedIndex() != -1) {
                    return;
                }
                String name = LoginWindow.this.txtUsername.getText();
                int at = name.indexOf(64);
                if (at == -1) {
                    return;
                }
                final int oldCursorPos = LoginWindow.this.txtUsername.getCaretPosition();
                String suffix = name.substring(at + 1);
                Organization organization = OrganizationCache.find(suffix);
                if (organization == null) {
                    return;
                }
                final String nameOnly = name.substring(0, at);
                LoginWindow.this.cboOrganization.setSelectedItem(organization);
                Gui.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        LoginWindow.this.txtUsername.setText(nameOnly);
                        LoginWindow.this.txtUsername.setCaretPosition(Math.min(oldCursorPos, nameOnly.length()));
                    }
                });
            }
        });
    }

    public void populateIdpCombo(List<Organization> orgs) {
        if (orgs == null) {
            LOGGER.error("No organizations received from the cache.");
            return;
        }
        this.cboOrganization.setModel(new DefaultComboBoxModel<Organization>(orgs.toArray(new Organization[orgs.size()])));
        String savedOrganizationId = Config.getIdentityProvider();
        this.cboOrganization.setSelectedItem(OrganizationCache.find(savedOrganizationId));
        this.cboOrganization.setEnabled(this.cboOrganization.getModel().getSize() != 0 && this.loginType == LoginType.ECP);
    }

    private void doSaveConfig() {
        if (this.chkSaveUsername.isSelected()) {
            String username = this.txtUsername.getText();
            if (!username.isEmpty()) {
                Config.setUsername(username);
            }
        } else {
            Config.setUsername("");
        }
        Config.setAuthenticationMethod(this.loginType.toString());
        Organization selectedOrg = (Organization)this.cboOrganization.getItemAt(this.cboOrganization.getSelectedIndex());
        if (selectedOrg != null) {
            Config.setIdentityProvider(selectedOrg.organizationId);
        }
    }

    private void doLogin() {
        Authenticator authenticator;
        Organization orgInUsername;
        String[] usernameSplit;
        if (this.loginType == null) {
            Gui.showMessageBox(this, "Bitte w\u00e4hlen Sie eine Authentifizierungsart.", MessageType.ERROR, LOGGER, null);
            return;
        }
        if (this.loginType == LoginType.ECP && this.cboOrganization.getSelectedIndex() == -1) {
            Gui.showMessageBox(this, "Bitte w\u00e4hlen Sie ihre Organisation als 'Identity Provider'.", MessageType.ERROR, LOGGER, null);
            this.cboOrganization.requestFocusInWindow();
            return;
        }
        String username = this.txtUsername.getText();
        final String password = String.copyValueOf(this.txtPassword.getPassword());
        if (username.isEmpty()) {
            Gui.showMessageBox(this, "Kein Benutzername angegeben!", MessageType.ERROR, LOGGER, null);
            return;
        }
        if (password.isEmpty()) {
            Gui.showMessageBox(this, "Kein Passwort angegeben!", MessageType.ERROR, LOGGER, null);
            return;
        }
        Organization selectedOrg = (Organization)this.cboOrganization.getItemAt(this.cboOrganization.getSelectedIndex());
        if (this.loginType == LoginType.ECP && username.contains("@") && !(usernameSplit = username.split("@", 2))[1].isEmpty() && (orgInUsername = OrganizationCache.find(usernameSplit[1])) != null) {
            boolean ret;
            if (!selectedOrg.equals(orgInUsername) && (ret = Gui.showMessageBox(this, "Der angegebene Benutzername enth\u00e4lt eine Organisation, die nicht mit Ihrer IDP-Auswahl \u00fcbereinstimmt.\nWollen Sie die in Ihrem Benutzername gefundene Organisation verwenden?", MessageType.QUESTION_YESNO, null, null))) {
                this.cboOrganization.setSelectedItem(orgInUsername);
                selectedOrg = orgInUsername;
            }
            this.txtUsername.setText(usernameSplit[0]);
            username = usernameSplit[0];
        }
        this.doSaveConfig();
        final LoginWindow me = this;
        final Authenticator.AuthenticatorCallback authenticatorCallback = new Authenticator.AuthenticatorCallback(){

            @Override
            public void postLogin(ShibbolethEcp.ReturnCode returnCode, final Authenticator.AuthenticationData data, Throwable t) {
                switch (returnCode) {
                    case NO_ERROR: {
                        Gui.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                LoginWindow.this.postSuccessfulLogin(data);
                            }
                        });
                        return;
                    }
                    case IDENTITY_PROVIDER_ERROR: {
                        Gui.showMessageBox(me, "IdP Error", MessageType.ERROR, LOGGER, null);
                        break;
                    }
                    case SERVICE_PROVIDER_ERROR: {
                        Gui.showMessageBox(me, "Invalid token from the service provider!", MessageType.ERROR, LOGGER, t);
                        break;
                    }
                    case UNREGISTERED_ERROR: {
                        LOGGER.error("User not registered!");
                        BwIdmLinkWindow.open((JFrame)SwingUtilities.getWindowAncestor(me));
                        break;
                    }
                    case INVALID_URL_ERROR: {
                        Gui.showMessageBox(me, "ECP Authenticator says: Invalid URL.", MessageType.ERROR, LOGGER, t);
                        break;
                    }
                    default: {
                        if (t == null || !t.getClass().equals(RuntimeException.class)) {
                            Gui.showMessageBox(me, "Internal error!", MessageType.ERROR, null, t);
                            break;
                        }
                        Gui.showMessageBox(me, "Der Masterserver hat den Loginversuch mit der folgenden Nachricht abgewiesen:\n\n" + t.getMessage(), MessageType.ERROR, null, null);
                    }
                }
                LoginWindow.this.enableLogin(true);
            }
        };
        switch (this.loginType) {
            case ECP: {
                authenticator = new EcpAuthenticator(selectedOrg.getEcpUrl());
                break;
            }
            case TEST_ACCOUNT: {
                authenticator = new TestAccountAuthenticator();
                break;
            }
            case DIRECT_CONNECT: {
                Gui.showMessageBox(this, "Not yet implemented", MessageType.ERROR, LOGGER, null);
                return;
            }
            default: {
                Gui.showMessageBox(this, "No login type selected!", MessageType.ERROR, LOGGER, null);
                return;
            }
        }
        this.enableLogin(false);
        final String finalUsername = username;
        QuickTimer.scheduleOnce(new QuickTimer.Task(){

            @Override
            public void fire() {
                App.waitForInit();
                try {
                    authenticator.login(finalUsername, password, authenticatorCallback);
                    return;
                }
                catch (TException e) {
                    ThriftError.showMessage(LoginWindow.this, LOGGER, e, "Anmeldung fehlgeschlagen");
                }
                catch (Exception e) {
                    Gui.showMessageBox(LoginWindow.this, "Anmeldung fehlgeschlagen", MessageType.ERROR, LOGGER, e);
                }
                LoginWindow.this.enableLogin(true);
            }
        });
    }

    private void postSuccessfulLogin(Authenticator.AuthenticationData data) {
        LOGGER.info(this.loginType.toString() + " succeeded, token " + data.satelliteToken);
        this.importFingerprints(data.satellites);
        if (ThriftActions.initSession(data, this.forceCustomSatellite, SwingUtilities.getWindowAncestor(this))) {
            if (this.chkSaveUsername.isSelected()) {
                Config.saveCurrentSession(Session.getSatelliteAddress(), Session.getSatelliteToken(), Session.getMasterToken());
            }
            this.dispose();
            return;
        }
        this.enableLogin(true);
    }

    private void enableLogin(boolean enable) {
        this.btnLogin.setEnabled(enable);
        this.txtUsername.setEnabled(enable);
        this.txtPassword.setEnabled(enable);
        this.pnlLoginType.setEnabled(enable);
        this.pnlLoginForm.setEnabled(enable);
        this.chkSaveUsername.setEnabled(enable);
        if (enable) {
            String savedUsername = Config.getUsername();
            if (savedUsername != null && !savedUsername.isEmpty()) {
                this.txtUsername.setText(savedUsername);
                this.chkSaveUsername.setSelected(true);
                this.txtPassword.requestFocusInWindow();
            } else {
                this.txtUsername.requestFocusInWindow();
            }
        }
    }

    private void importFingerprints(List<Satellite> satellites) {
        if (satellites == null || satellites.isEmpty()) {
            return;
        }
        for (Satellite sat : satellites) {
            if (sat.addressList == null || sat.certSha256 == null || sat.addressList.isEmpty()) continue;
            byte[] fingerprint = TBaseHelper.byteBufferToByteArray(sat.certSha256);
            for (String address : sat.addressList) {
                FingerprintManager.saveSuggestedFingerprint(address, fingerprint);
            }
        }
    }

    @Override
    public void show() {
        if (!this.isVisible()) {
            this.pack();
            MainWindow.centerShell(this);
        }
        super.show();
    }

    public static void open(Frame modalParent) {
        LoginWindow win = new LoginWindow(modalParent);
        win.setVisible(true);
    }

    public static enum LoginType {
        ECP(0),
        TEST_ACCOUNT(1),
        DIRECT_CONNECT(2);

        public final int id;

        private LoginType(int id) {
            this.id = id;
        }
    }
}

